/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeImpl<X, T>
implements Attribute<X, T>,
Serializable {
    private ManagedTypeImpl<X> managedType;
    private DatabaseMapping mapping;

    protected AttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping) {
        this.mapping = mapping;
        this.mapping.setProperty((Object)this.getClass().getName(), (Object)this);
        this.managedType = managedType;
    }

    public ManagedType<X> getDeclaringType() {
        return this.getManagedTypeImpl();
    }

    protected RelationalDescriptor getDescriptor() {
        return this.getManagedTypeImpl().getDescriptor();
    }

    public Member getJavaMember() {
        AttributeAccessor accessor = this.getMapping().getAttributeAccessor();
        if (accessor.isMethodAttributeAccessor()) {
            return ((MethodAttributeAccessor)accessor).getGetMethod();
        }
        Field aMember = ((InstanceVariableAttributeAccessor)accessor).getAttributeField();
        if (null == aMember && this.getManagedTypeImpl().isMappedSuperclass()) {
            AttributeImpl inheritingTypeMember = ((MappedSuperclassTypeImpl)this.getManagedTypeImpl()).getMemberFromInheritingType(this.mapping.getAttributeName());
            aMember = ((InstanceVariableAttributeAccessor)inheritingTypeMember.getMapping().getAttributeAccessor()).getAttributeField();
        }
        return aMember;
    }

    public abstract Class<T> getJavaType();

    public ManagedTypeImpl<X> getManagedTypeImpl() {
        return this.managedType;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected MetamodelImpl getMetamodel() {
        return this.managedType.getMetamodel();
    }

    public String getName() {
        return this.getMapping().getAttributeName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        if (this.getMapping().isDirectToFieldMapping()) {
            return Attribute.PersistentAttributeType.BASIC;
        }
        if (this.getMapping().isAggregateObjectMapping()) {
            return Attribute.PersistentAttributeType.EMBEDDED;
        }
        if (this.getMapping().isOneToManyMapping()) {
            return Attribute.PersistentAttributeType.ONE_TO_MANY;
        }
        if (this.getMapping().isOneToOneMapping()) {
            return Attribute.PersistentAttributeType.ONE_TO_ONE;
        }
        if (this.getMapping().isRelationalMapping() && (this.getMapping() instanceof OneToOneMapping || this.getMapping() instanceof VariableOneToOneMapping)) {
            return Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
        if (this.getMapping().isManyToManyMapping()) {
            return Attribute.PersistentAttributeType.MANY_TO_MANY;
        }
        return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    public boolean isAssociation() {
        return this.getMapping().isReferenceMapping();
    }

    public boolean isCollection() {
        return this.getMapping().isCollectionMapping();
    }

    public abstract boolean isPlural();
}

