/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBElementConverter
implements XMLConverter {
    private XPathFragment rootFragment;
    private XMLField associatedField;
    private DatabaseMapping mapping;
    private Converter nestedConverter;
    private Class declaredType;
    private Class scope;

    public JAXBElementConverter(XMLField associatedField, Class declaredType, Class scope) {
        this.associatedField = associatedField;
        this.declaredType = declaredType;
        this.scope = scope;
    }

    public Converter getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(Converter nestedConverter) {
        this.nestedConverter = nestedConverter;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        return this.convertDataValueToObjectValue(dataValue, session);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        return this.convertObjectValueToDataValue(objectValue, session);
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        QName name = new QName(this.rootFragment.getNamespaceURI(), this.rootFragment.getLocalName());
        if (this.mapping.isAbstractDirectMapping() && (dataValue == null || dataValue.getClass() != this.mapping.getAttributeClassification())) {
            try {
                dataValue = session.getDatasourcePlatform().convertObject(dataValue, this.mapping.getAttributeClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, (Object)this.mapping.getDescriptor(), (ConversionException)e);
            }
        }
        if (null != this.nestedConverter) {
            dataValue = this.nestedConverter.convertDataValueToObjectValue(dataValue, session);
        }
        if (dataValue instanceof JAXBElement) {
            return dataValue;
        }
        if (null == this.declaredType) {
            return new JAXBElement(name, Object.class, this.scope, dataValue);
        }
        return new JAXBElement(name, this.declaredType, this.scope, dataValue);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        if (objectValue instanceof JAXBElement) {
            objectValue = ((JAXBElement)objectValue).getValue();
        } else if (objectValue instanceof XMLRoot) {
            objectValue = ((XMLRoot)objectValue).getObject();
        }
        if (null != this.nestedConverter) {
            objectValue = this.nestedConverter.convertObjectValueToDataValue(objectValue, session);
        }
        return objectValue;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        if (null != this.nestedConverter) {
            this.nestedConverter.initialize(mapping, session);
        }
        XPathFragment fragment = this.associatedField.getXPathFragment();
        while (fragment.getNextFragment() != null && !fragment.getNextFragment().nameIsText()) {
            fragment = fragment.getNextFragment();
        }
        if (fragment.hasNamespace() && this.associatedField.getNamespaceResolver() != null) {
            String uri = this.associatedField.getNamespaceResolver().resolveNamespacePrefix(fragment.getPrefix());
            fragment.setNamespaceURI(uri);
        }
        this.rootFragment = fragment;
        this.mapping = mapping;
    }

    public boolean isMutable() {
        return false;
    }
}

