/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.PrimitiveType;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.TransientCompatibleAnnotations;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAnnotatedElement
extends MetadataAccessibleObject {
    public static final String JPA_PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";
    public static final String ECLIPSELINK_PERSISTENCE_PACKAGE_PREFIX = "org.eclipse.persistence.annotations";
    private String m_name;
    private int m_modifiers;
    private MetadataClass m_rawClass;
    private List<String> m_genericType;
    private String m_type;
    PrimitiveType m_primitiveType;
    private String m_attributeName;
    private Map<String, MetadataAnnotation> m_annotations = new HashMap<String, MetadataAnnotation>();

    public MetadataAnnotatedElement(MetadataFactory factory) {
        super(factory);
    }

    public void addAnnotation(MetadataAnnotation annotation) {
        this.m_annotations.put(annotation.getName(), annotation);
    }

    public void addGenericType(String genericType) {
        if (this.m_genericType == null) {
            this.m_genericType = new ArrayList<String>();
        }
        this.m_genericType.add(genericType);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getName() == null) {
            return ((MetadataAnnotatedElement)object).getName() == null;
        }
        return object.getClass() == this.getClass() && this.getName().equals(((MetadataAnnotatedElement)object).getName());
    }

    public MetadataAnnotation getAnnotation(Class annotation) {
        if (this.m_annotations == null) {
            return null;
        }
        return this.m_annotations.get(annotation.getName());
    }

    public MetadataAnnotation getAnnotation(String annotationClassName, MetadataDescriptor descriptor) {
        if (this.m_annotations == null) {
            return null;
        }
        MetadataAnnotation annotation = this.m_annotations.get(annotationClassName);
        if (annotation != null && descriptor.ignoreAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_annotation", annotation, this);
            return null;
        }
        return annotation;
    }

    public Map<String, MetadataAnnotation> getAnnotations() {
        return this.m_annotations;
    }

    @Override
    public String getAttributeName() {
        return this.m_attributeName;
    }

    protected int getDeclaredAnnotationsCount(MetadataDescriptor descriptor) {
        if (descriptor.ignoreAnnotations() || this.m_annotations == null) {
            return 0;
        }
        return this.m_annotations.size();
    }

    public List<String> getGenericType() {
        return this.m_genericType;
    }

    public MetadataClass getMapKeyClass(MetadataDescriptor descriptor) {
        if (this.isGenericCollectionType()) {
            String type = descriptor.getGenericType(this.m_genericType.get(2));
            if (type != null) {
                return this.getMetadataFactory().getMetadataClass(type);
            }
            return this.getMetadataFactory().getMetadataClass(this.m_genericType.get(1));
        }
        return null;
    }

    public int getModifiers() {
        return this.m_modifiers;
    }

    public String getName() {
        return this.m_name;
    }

    public PrimitiveType getPrimitiveType() {
        return this.m_primitiveType;
    }

    public MetadataClass getRawClass(MetadataDescriptor descriptor) {
        if (this.m_rawClass == null) {
            if (this.isGenericType()) {
                String type = descriptor.getGenericType(this.getGenericType().get(0));
                if (type == null) {
                    return this.getMetadataFactory().getMetadataClass("java.lang.String");
                }
                return this.getMetadataFactory().getMetadataClass(type);
            }
            return this.getMetadataFactory().getMetadataClass(this.getType());
        }
        return this.m_rawClass;
    }

    public MetadataClass getReferenceClassFromGeneric(MetadataDescriptor descriptor) {
        if (this.isGenericCollectionType()) {
            MetadataClass metadataClass;
            String elementClass = this.m_genericType.get(1);
            if (this.m_genericType.size() > 4) {
                elementClass = this.m_genericType.get(4);
            } else if (this.m_genericType.size() > 3) {
                elementClass = this.m_genericType.get(3);
            } else if (this.m_genericType.size() > 2) {
                elementClass = this.m_genericType.get(2);
            }
            if (elementClass.length() == 1) {
                elementClass = descriptor.getGenericType(elementClass);
            }
            if ((metadataClass = this.getMetadataFactory().getMetadataClass(elementClass)) == null && descriptor.isMappedSuperclass()) {
                return new MetadataClass(this.getMetadataFactory(), Void.class);
            }
            return metadataClass;
        }
        return null;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasDeclaredAnnotations(MetadataDescriptor descriptor) {
        return this.getDeclaredAnnotationsCount(descriptor) > 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean areAnnotationsCompatibleWithTransient(MetadataDescriptor descriptor) {
        int legalAnnotationCount = 1;
        Iterator annotations = TransientCompatibleAnnotations.getTransientCompatibleAnnotations().iterator();
        while (annotations.hasNext()) {
            if (!this.m_annotations.containsKey(annotations.next())) continue;
            ++legalAnnotationCount;
        }
        return this.getDeclaredAnnotationsCount(descriptor) <= legalAnnotationCount;
    }

    public boolean isAnnotationNotPresent(Class annotation) {
        return !this.isAnnotationPresent(annotation);
    }

    public boolean isAnnotationPresent(Class annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public boolean isAnnotationPresent(Class annotationClass, MetadataDescriptor descriptor) {
        MetadataAnnotation annotation = this.getAnnotation(annotationClass);
        if (annotation != null && descriptor.ignoreAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_annotation", annotation, this);
            return false;
        }
        return annotation != null;
    }

    public boolean isBasic(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(Basic.class, descriptor) || this.isAnnotationPresent(Lob.class, descriptor) || this.isAnnotationPresent(Temporal.class, descriptor) || this.isAnnotationPresent(Enumerated.class, descriptor);
    }

    public boolean isBasicCollection(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(BasicCollection.class, descriptor);
    }

    public boolean isBasicMap(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(BasicMap.class, descriptor);
    }

    public boolean isDerivedId(MetadataDescriptor descriptor) {
        return this.isId(descriptor) && (this.isOneToOne(descriptor) || this.isManyToOne(descriptor));
    }

    public boolean isElementCollection(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ElementCollection.class, descriptor);
    }

    public boolean isEmbedded(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(Embedded.class) && this.isAnnotationNotPresent(EmbeddedId.class)) {
            MetadataClass rawClass = this.getRawClass(descriptor);
            return rawClass.isAnnotationPresent(Embeddable.class) || descriptor.getProject().hasEmbeddable(rawClass);
        }
        return this.isAnnotationPresent(Embedded.class, descriptor);
    }

    public boolean isEmbeddedId(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(EmbeddedId.class, descriptor);
    }

    public boolean isGenericCollectionType() {
        return this.m_genericType != null && this.m_genericType.size() > 1;
    }

    public boolean isGenericType() {
        return this.m_genericType != null && this.m_genericType.size() > 1 && this.m_genericType.get(0).length() == 1;
    }

    public boolean isId(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(Id.class, descriptor);
    }

    public boolean isDerivedIdClass(MetadataDescriptor descriptor) {
        return descriptor.isEmbeddable() && descriptor.getProject().isIdClass(this.getRawClass(descriptor));
    }

    public boolean isManyToMany(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ManyToMany.class, descriptor);
    }

    public boolean isManyToOne(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ManyToOne.class, descriptor);
    }

    public boolean isOneToMany(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(OneToMany.class) && !descriptor.ignoreDefaultMappings()) {
            if (this.isGenericCollectionType() && this.isSupportedToManyCollectionClass(descriptor) && descriptor.getProject().hasEntity(this.getReferenceClassFromGeneric(descriptor))) {
                this.getLogger().logConfigMessage("metadata_default_one_to_many_mapping", this);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToMany.class, descriptor);
    }

    public boolean isOneToOne(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(OneToOne.class) && !descriptor.ignoreDefaultMappings()) {
            if (descriptor.getProject().hasEntity(this.getRawClass(descriptor)) && !this.isEmbedded(descriptor)) {
                this.getLogger().logConfigMessage("metadata_default_one_to_one_mapping", this);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToOne.class, descriptor);
    }

    public boolean isSupportedCollectionClass(MetadataDescriptor descriptor) {
        return this.getRawClass(descriptor).isCollection();
    }

    public boolean isSupportedMapClass(MetadataDescriptor descriptor) {
        return this.getRawClass(descriptor).isMap();
    }

    public boolean isSupportedToManyCollectionClass(MetadataDescriptor descriptor) {
        return this.isSupportedCollectionClass(descriptor) || this.isSupportedMapClass(descriptor);
    }

    public boolean isTransformation(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ReadTransformer.class, descriptor) || this.isAnnotationPresent(WriteTransformers.class, descriptor) || this.isAnnotationPresent(WriteTransformer.class, descriptor);
    }

    protected boolean isValidPersistenceElement(boolean mustBeExplicit, String explicitType, MetadataDescriptor descriptor) {
        if (mustBeExplicit) {
            MetadataAnnotation annotation = this.getAnnotation("javax.persistence.Access", descriptor);
            if (annotation == null) {
                return false;
            }
            String access = (String)annotation.getAttribute("value");
            if (!access.equals(explicitType)) {
                throw ValidationException.invalidExplicitAccessTypeSpecified((Object)this, (Object)descriptor.getJavaClass(), (String)explicitType);
            }
        }
        return true;
    }

    protected boolean isValidPersistenceElement(int modifiers) {
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    public boolean isVariableOneToOne(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(VariableOneToOne.class) && !descriptor.ignoreDefaultMappings()) {
            if (this.getRawClass(descriptor).isInterface() && !this.getRawClass(descriptor).isMap() && !this.getRawClass(descriptor).isCollection() && !this.getRawClass(descriptor).extendsInterface(ValueHolderInterface.class)) {
                this.getLogger().logConfigMessage("metadata_default_variable_one_to_one_mapping", this);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(VariableOneToOne.class, descriptor);
    }

    public boolean isVersion(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(Version.class, descriptor);
    }

    public void setAnnotations(Map<String, MetadataAnnotation> annotations) {
        this.m_annotations = annotations;
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setGenericType(List<String> genericType) {
        this.m_genericType = genericType;
    }

    public void setModifiers(int modifiers) {
        this.m_modifiers = modifiers;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPrimitiveType(PrimitiveType primitiveType) {
        this.m_primitiveType = primitiveType;
        this.m_type = primitiveType.toString();
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        return className.substring("Metadata".length(), className.length()).toLowerCase() + " " + this.getName();
    }
}

