/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregatePathToColumn;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class AggregateMappingColumnsPanel
extends ScrollablePropertiesPage {
    private ListValueModel sortedPathsToFieldsAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;

    AggregateMappingColumnsPanel(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.sortedPathsToFieldsAdapter = this.buildSortedPathToFieldsAdapter();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ListValueModel buildSortedPathToFieldsAdapter() {
        return new SortedListValueModelAdapter(this.buildPathsToFieldsAdapter());
    }

    private CollectionValueModel buildPathsToFieldsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "pathsToFields"){

            protected Iterator getValueFromSubject() {
                return ((MWAggregateMapping)this.subject).pathsToFields();
            }

            protected int sizeFromSubject() {
                return ((MWAggregateMapping)this.subject).pathsToFieldsSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedPathsToFieldsAdapter, this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new ColumnColumnAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel result = new ObjectListSelectionModel(new ListModelAdapter(this.sortedPathsToFieldsAdapter));
        result.setSelectionMode(0);
        return result;
    }

    protected Component buildPage() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JTable table = this.buildTable();
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        scrollPane.getViewport().setBackground(table.getBackground());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)scrollPane, constraints);
        this.addHelpTopicId(mainPanel, this.helpTopicId());
        return mainPanel;
    }

    private JTable buildTable() {
        JTable table = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        this.updateTableColumns(table);
        SwingComponentFactory.attachTableEditorCanceler(table, this.getSelectionHolder());
        return table;
    }

    private void updateTableColumns(JTable table) {
        int rowHeight = 20;
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(200);
        TableColumn fieldColumn = table.getColumnModel().getColumn(1);
        fieldColumn.setPreferredWidth(100);
        ComboBoxTableCellRenderer fieldRenderer = this.buildColumnsComboBoxRenderer();
        fieldColumn.setCellRenderer(fieldRenderer);
        fieldColumn.setCellEditor(new TableCellEditorAdapter(this.buildColumnsComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, fieldRenderer.getPreferredHeight());
        table.setRowHeight(rowHeight);
    }

    private ComboBoxTableCellRenderer buildColumnsComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildColumnsComboBoxModel(), this.buildColumnListCellRenderer());
    }

    private CachingComboBoxModel buildColumnsComboBoxModel() {
        return RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(new SimplePropertyValueModel(), this.buildParentDescriptorHolder());
    }

    private ListCellRenderer buildColumnListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private PropertyValueModel buildParentDescriptorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWAggregateMapping)this.subject).getParentDescriptor();
            }
        };
    }

    protected String helpTopicId() {
        return "mapping.aggregate.fields";
    }

    public static class ColumnColumnAdapter
    implements ColumnAdapter {
        ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int COLUMN_DESCRIPTION_COLUMN = 0;
        public static final int COLUMN_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"FIELD_DESCRIPTION_COLUMN_HEADER", "FIELDS_COLUMN_HEADER"};

        protected ColumnColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index != 0;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWAggregatePathToColumn pathToField = (MWAggregatePathToColumn)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildColumnDescriptionAdapter(pathToField), this.buildColumnAdapter(pathToField)};
            return result;
        }

        private PropertyValueModel buildColumnDescriptionAdapter(MWAggregatePathToColumn pathToField) {
            return new PropertyAspectAdapter("aggregateRuntimeFieldNameGenerator", (Model)pathToField){

                protected Object getValueFromSubject() {
                    MWAggregatePathToColumn ptf = (MWAggregatePathToColumn)this.subject;
                    AggregateFieldDescription fieldDescription = ptf.getAggregateRuntimeFieldNameGenerator().fullFieldDescription();
                    return ptf.getPathDescription() + ColumnColumnAdapter.this.resourceRepository.getString(fieldDescription.getMessageKey(), fieldDescription.getMessageArguments());
                }
            };
        }

        private PropertyValueModel buildColumnAdapter(MWAggregatePathToColumn pathToField) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("column", (Model)pathToField){

                protected Object getValueFromSubject() {
                    return ((MWAggregatePathToColumn)this.subject).getColumn();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWAggregatePathToColumn)this.subject).setColumn((MWColumn)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter(adapter, "qualifiedName", "databaseType");
        }
    }
}

