/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class GroupingAttributesPanel
extends AbstractAttributeItemsPanel {
    GroupingAttributesPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(queryHolder, contextHolder);
    }

    String listTitleKey() {
        return "REPORT_QUERY_GROUPING_ATTRIBUTES_LIST";
    }

    protected String helpTopicId() {
        return "query.report.groupings";
    }

    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public String optionalButtonKey() {
                return "REPORT_QUERY_GROUPING_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                GroupingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)((MWGroupingItem)listSelectionModel.getSelectedValue()));
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                GroupingAttributesPanel.this.addGroupingAttribute();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] selectedValues = listSelectionModel.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).removeGroupingItem((MWGroupingItem)selectedValues[i]);
                }
            }

            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).moveGroupingItemDown((MWGroupingItem)items[i]);
                }
            }

            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).moveGroupingItemUp((MWGroupingItem)items[i]);
                }
            }
        };
    }

    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "groupingItems"){

            protected ListIterator getValueFromSubject() {
                return ((MWReportQuery)this.subject).groupingItems();
            }

            protected int sizeFromSubject() {
                return ((MWReportQuery)this.subject).groupingItemsSize();
            }
        };
    }

    protected boolean panelEnabled(MWQueryFormat queryFormat) {
        return queryFormat.groupingAtributesAllowed();
    }

    private void addGroupingAttribute() {
        this.editSelectedAttribute(null);
    }

    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem item) {
        AttributeItemDialog dialog = new AttributeItemDialog(this.getQuery(), item, this.getWorkbenchContext()){

            protected String titleKey() {
                return "GROUPING_ATTRIBUTES_DIALOG_TITLE";
            }

            protected String editTitleKey() {
                return "GROUPING_ATTRIBUTES_EDIT_DIALOG_TITLE";
            }

            protected String helpTopicId() {
                return "dialog.groupingAttribute";
            }

            protected int attributeItemsSize() {
                return ((MWReportQuery)this.getQuery()).groupingItemsSize();
            }

            protected int indexOfAttributeItem(MWAttributeItem attributeItem) {
                return ((MWReportQuery)this.getQuery()).indexOfGroupingItem((MWGroupingItem)attributeItem);
            }

            protected void removeAttributeItem(int index) {
                ((MWReportQuery)this.getQuery()).removeGroupingItem(index);
            }

            protected void addAttributeItem(int index, Iterator queryables, Iterator allowsNulls) {
                ((MWReportQuery)this.getQuery()).addGroupingItem(index, queryables, allowsNulls);
            }
        };
        return dialog;
    }
}

