/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ListChangeEvent
extends EventObject {
    private String listName;
    private int index = -1;
    private List items;
    private List replacedItems;
    private static final long serialVersionUID = 1L;

    public ListChangeEvent(Object source) {
        super(source);
    }

    public ListChangeEvent(Object source, String listName) {
        this(source);
        this.listName = listName;
    }

    public ListChangeEvent(Object source, String listName, int index, List items) {
        this(source, listName);
        this.index = index;
        this.items = items;
    }

    public ListChangeEvent(Object source, String listName, int index, List items, List replacedItems) {
        this(source, listName, index, items);
        this.replacedItems = replacedItems;
    }

    public String getListName() {
        return this.listName;
    }

    public int getIndex() {
        return this.index;
    }

    public ListIterator items() {
        if (this.items == null) {
            return NullListIterator.instance();
        }
        return new ReadOnlyListIterator(this.items);
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public ListIterator replacedItems() {
        if (this.replacedItems == null) {
            return NullListIterator.instance();
        }
        return new ReadOnlyListIterator(this.replacedItems);
    }

    public ListChangeEvent cloneWithSource(Object newSource) {
        return new ListChangeEvent(newSource, this.listName, this.index, this.items, this.replacedItems);
    }

    public ListChangeEvent cloneWithSource(Object newSource, String newListName) {
        return new ListChangeEvent(newSource, newListName, this.index, this.items, this.replacedItems);
    }

    public ListChangeEvent cloneWithSource(Object newSource, String newListName, int offset) {
        return new ListChangeEvent(newSource, newListName, this.index + offset, this.items, this.replacedItems);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.listName);
    }
}

