/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.JarArchiver;

public class WarArchiver
extends JarArchiver {
    static final String DEFAULT_WAR_FILENAME = "dbws.war";

    public WarArchiver() {
    }

    public WarArchiver(DBWSPackager packager) {
        super(packager);
    }

    @Override
    public void setFilename(String jarFilename) {
        if (!jarFilename.endsWith(".war")) {
            jarFilename = jarFilename + ".war";
        }
        this.jarFilename = jarFilename;
    }

    @Override
    protected JarEntry getOrJarEntry() {
        return new JarEntry("WEB-INF/classes" + Util.META_INF_PATHS[1] + "eclipselink-dbws-or.xml");
    }

    @Override
    protected JarEntry getOxJarEntry() {
        return new JarEntry("WEB-INF/classes" + Util.META_INF_PATHS[1] + "eclipselink-dbws-ox.xml");
    }

    @Override
    protected JarEntry getSchemaJarEntry() {
        return new JarEntry("WEB-INF/wsdl/eclipselink-dbws-schema.xsd");
    }

    @Override
    protected JarEntry getServiceJarEntry() {
        return new JarEntry("WEB-INF/classes" + Util.META_INF_PATHS[1] + "eclipselink-dbws.xml");
    }

    @Override
    protected JarEntry getSessionsJarEntry() {
        return new JarEntry("WEB-INF/classes" + Util.META_INF_PATHS[1] + this.packager.getSessionsFileName());
    }

    @Override
    protected JarEntry getSWARefJarEntry() {
        return new JarEntry("WEB-INF/wsdl/swaref.xsd");
    }

    @Override
    public String getOrProjectPathPrefix() {
        return Util.META_INF_PATHS[1];
    }

    @Override
    public String getOxProjectPathPrefix() {
        return Util.META_INF_PATHS[1];
    }

    protected ZipEntry getWebXmlJarEntry() {
        return new JarEntry("WEB-INF/web.xml");
    }

    protected ZipEntry getDBWSProviderClassJarEntry() {
        return new JarEntry("WEB-INF/classes/_dbws/DBWSProvider.class");
    }

    protected ZipEntry getDBWSProviderSourceJarEntry() {
        return new JarEntry("WEB-INF/classes/_dbws/DBWSProvider.java");
    }

    protected ZipEntry getWSDLJarEntry() {
        return new JarEntry("WEB-INF/wsdl/eclipselink-dbws.wsdl");
    }

    @Override
    protected JarOutputStream buildJarOutputStream() {
        JarOutputStream jarOutputStream = null;
        try {
            if (this.jarFilename == null || this.jarFilename.length() == 0) {
                this.jarFilename = DEFAULT_WAR_FILENAME;
            }
            jarOutputStream = new JarOutputStream(new FileOutputStream(new File(this.packager.getStageDir(), this.jarFilename)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jarOutputStream;
    }

    @Override
    protected void addFilesToJarOutputStream(JarOutputStream jarOutputStream) {
        super.addFilesToJarOutputStream(jarOutputStream);
        try {
            jarOutputStream.putNextEntry(this.getWebXmlJarEntry());
            this.f = new File(this.packager.getStageDir(), "web.xml");
            this.fis = new FileInputStream(this.f);
            int read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getDBWSProviderClassJarEntry());
            this.f = new File(this.packager.getStageDir(), "DBWSProvider.class");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            this.f = new File(this.packager.getStageDir(), "DBWSProvider.java");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getDBWSProviderSourceJarEntry());
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getWSDLJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws.wsdl");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

