/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.xr.IndexInfo;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRDynamicEntity;
import org.eclipse.persistence.internal.xr.XRDynamicEntityAccessor;
import org.eclipse.persistence.internal.xr.XRDynamicEntityVHAccessor;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class ProjectHelper {
    public static void fixOROXAccessors(Project orProject, Project oxProject) {
        XRDynamicClassLoader xrdecl;
        ConversionManager conversionManager;
        Platform platform;
        for (ClassDescriptor desc : orProject.getDescriptors().values()) {
            if (!XRDynamicEntity.class.isAssignableFrom(desc.getJavaClass())) continue;
            HashMap<String, IndexInfo> propertyNames2indexes = new HashMap<String, IndexInfo>();
            ClassDescriptor xdesc = null;
            if (oxProject != null) {
                xdesc = oxProject.getDescriptorForAlias(desc.getAlias());
            }
            int idx = 0;
            for (DatabaseMapping dm : desc.getMappings()) {
                String attributeName = dm.getAttributeName();
                IndexInfo info = new IndexInfo(idx, false);
                DatabaseMapping xdm = null;
                if (xdesc != null) {
                    xdm = xdesc.getMappingForAttributeName(attributeName);
                }
                dm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(attributeName, idx));
                if (xdm != null) {
                    if (dm.isForeignReferenceMapping()) {
                        ForeignReferenceMapping frm = (ForeignReferenceMapping)dm;
                        if (frm.usesIndirection() && frm.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                            xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityVHAccessor(attributeName, idx));
                            info.derefVH = true;
                        } else {
                            xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(attributeName, idx));
                        }
                    } else {
                        Class<?> clz;
                        XMLField xmlField;
                        xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(attributeName, idx));
                        if (xdm.isDirectToFieldMapping()) {
                            XMLDirectMapping xmlDM = (XMLDirectMapping)xdm;
                            xmlField = (XMLField)xmlDM.getField();
                            clz = Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                            if (clz != null) {
                                xmlField.setType(clz);
                            } else {
                                xmlField.setType(ClassConstants.OBJECT);
                            }
                        } else if (xdm.isAbstractCompositeDirectCollectionMapping()) {
                            AbstractCompositeDirectCollectionMapping acdcm = (AbstractCompositeDirectCollectionMapping)xdm;
                            xmlField = (XMLField)acdcm.getField();
                            clz = Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                            if (clz != null) {
                                xmlField.setType(clz);
                            } else {
                                xmlField.setType(ClassConstants.OBJECT);
                            }
                        }
                    }
                }
                propertyNames2indexes.put(attributeName, info);
                ++idx;
            }
            if (desc.getJavaClassName().endsWith("_CollectionWrapper")) continue;
            InstantiationPolicy iPolicy = new InstantiationPolicy(){
                Map<String, IndexInfo> propertyNames2indexes;

                public Object buildNewInstance() throws DescriptorException {
                    Object o = null;
                    try {
                        Class clz = this.descriptor.getJavaClass();
                        Constructor constructor = clz.getConstructor(Map.class);
                        o = constructor.newInstance(this.propertyNames2indexes);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return o;
                }

                public InstantiationPolicy setUp(ClassDescriptor descriptor, Map<String, IndexInfo> propertyNames2indexes) {
                    this.setDescriptor(descriptor);
                    this.propertyNames2indexes = propertyNames2indexes;
                    return this;
                }
            }.setUp(desc, propertyNames2indexes);
            desc.setInstantiationPolicy(iPolicy);
            if (xdesc == null) continue;
            InstantiationPolicy iPolicy2 = (InstantiationPolicy)iPolicy.clone();
            iPolicy2.setDescriptor(xdesc);
            xdesc.setInstantiationPolicy(iPolicy2);
        }
        ClassLoader cl = null;
        Login login = orProject.getDatasourceLogin();
        if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
            cl = conversionManager.getLoader();
        }
        if (cl != null && cl instanceof XRDynamicClassLoader) {
            xrdecl = (XRDynamicClassLoader)((Object)cl);
            xrdecl.dontGenerateSubclasses();
        }
        if (oxProject != null) {
            cl = null;
            login = oxProject.getDatasourceLogin();
            if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
                cl = conversionManager.getLoader();
            }
            if (cl != null && cl instanceof XRDynamicClassLoader) {
                xrdecl = (XRDynamicClassLoader)((Object)cl);
                xrdecl.dontGenerateSubclasses();
            }
        }
    }
}

