/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories.model.sequencing;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.NativeSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.TableSequenceConfig;

public class SequencingConfig {
    private SequenceConfig m_defaultSequenceConfig;
    private Vector m_sequenceConfigs;

    public void setDefaultSequenceConfig(SequenceConfig defaultSequenceConfig) {
        this.m_defaultSequenceConfig = defaultSequenceConfig;
    }

    public SequenceConfig getDefaultSequenceConfig() {
        return this.m_defaultSequenceConfig;
    }

    public void setSequenceConfigs(Vector sequenceConfigs) {
        this.m_sequenceConfigs = sequenceConfigs;
    }

    public Vector getSequenceConfigs() {
        return this.m_sequenceConfigs;
    }

    public void setNativeSequencing(boolean nativeSequencing) {
        Integer preallocationSize = null;
        if (this.getDefaultSequenceConfig() != null) {
            if (this.getNativeSequencing() == nativeSequencing) {
                return;
            }
            preallocationSize = this.getDefaultSequenceConfig().getPreallocationSize();
        }
        this.setDefaultSequenceConfig(nativeSequencing);
        if (preallocationSize != null) {
            this.getDefaultSequenceConfig().setPreallocationSize(preallocationSize);
        }
    }

    public boolean getNativeSequencing() {
        if (this.getDefaultSequenceConfig() == null) {
            return false;
        }
        return this.getDefaultSequenceConfig() instanceof NativeSequenceConfig;
    }

    public void setSequencePreallocationSize(Integer sequencePreallocationSize) {
        if (this.getDefaultSequenceConfig() == null) {
            this.setDefaultSequenceConfig(false);
        }
        this.getDefaultSequenceConfig().setPreallocationSize(sequencePreallocationSize);
    }

    public Integer getSequencePreallocationSize() {
        if (this.getDefaultSequenceConfig() == null) {
            return null;
        }
        return this.getDefaultSequenceConfig().getPreallocationSize();
    }

    public void setSequenceTable(String sequenceTable) {
        if (this.getDefaultSequenceConfig() == null) {
            this.setDefaultSequenceConfig(false);
        }
        if (this.getDefaultSequenceConfig() instanceof TableSequenceConfig) {
            ((TableSequenceConfig)this.getDefaultSequenceConfig()).setTable(sequenceTable);
        }
    }

    public String getSequenceTable() {
        if (this.getDefaultSequenceConfig() != null && this.getDefaultSequenceConfig() instanceof TableSequenceConfig) {
            return ((TableSequenceConfig)this.getDefaultSequenceConfig()).getTable();
        }
        return null;
    }

    public void setSequenceNameField(String sequenceNameField) {
        if (this.getDefaultSequenceConfig() == null) {
            this.setDefaultSequenceConfig(false);
        }
        if (this.getDefaultSequenceConfig() instanceof TableSequenceConfig) {
            ((TableSequenceConfig)this.getDefaultSequenceConfig()).setNameField(sequenceNameField);
        }
    }

    public String getSequenceNameField() {
        if (this.getDefaultSequenceConfig() != null && this.getDefaultSequenceConfig() instanceof TableSequenceConfig) {
            return ((TableSequenceConfig)this.getDefaultSequenceConfig()).getNameField();
        }
        return null;
    }

    public void setSequenceCounterField(String sequenceCounterField) {
        if (this.getDefaultSequenceConfig() == null) {
            this.setDefaultSequenceConfig(false);
        }
        if (this.getDefaultSequenceConfig() instanceof TableSequenceConfig) {
            ((TableSequenceConfig)this.getDefaultSequenceConfig()).setCounterField(sequenceCounterField);
        }
    }

    public String getSequenceCounterField() {
        if (this.getDefaultSequenceConfig() != null && this.getDefaultSequenceConfig() instanceof TableSequenceConfig) {
            return ((TableSequenceConfig)this.getDefaultSequenceConfig()).getCounterField();
        }
        return null;
    }

    protected void setDefaultSequenceConfig(boolean nativeSequencing) {
        SequenceConfig sequenceConfig;
        if (nativeSequencing) {
            NativeSequenceConfig nativeSequenceConfig;
            sequenceConfig = nativeSequenceConfig = new NativeSequenceConfig();
        } else {
            TableSequenceConfig tableSequenceConfig = new TableSequenceConfig();
            tableSequenceConfig.setTable("SEQUENCE");
            tableSequenceConfig.setNameField("SEQ_NAME");
            tableSequenceConfig.setCounterField("SEQ_COUNT");
            sequenceConfig = tableSequenceConfig;
        }
        sequenceConfig.setName("");
        sequenceConfig.setPreallocationSize(new Integer(50));
        this.setDefaultSequenceConfig(sequenceConfig);
    }
}

