/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MarshalRecord
extends XMLRecord {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public void addGroupingElement(XPathNode xPathNode) {
        if (null == this.groupingElements) {
            this.groupingElements = new ArrayList();
        }
        this.groupingElements.add(xPathNode);
    }

    public void removeGroupingElement(XPathNode xPathNode) {
        if (null != this.groupingElements) {
            this.groupingElements.remove(xPathNode);
        }
    }

    public String transformToXML() {
        return null;
    }

    public void add(DatabaseField key, Object value) {
        if (null == value) {
            return;
        }
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        XMLConversionManager xcm = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (lastFragment.nameIsText()) {
            String stringValue = (String)xcm.convertObject(value, String.class);
            this.characters(stringValue);
        } else if (lastFragment.isAttribute()) {
            String stringValue = (String)xcm.convertObject(value, String.class);
            this.attribute(lastFragment, xmlField.getNamespaceResolver(), stringValue);
        } else {
            this.element(lastFragment.getNamespaceURI(), lastFragment.getLocalName(), lastFragment.getShortName(), lastFragment.getPrefix());
        }
    }

    public Object put(DatabaseField key, Object value) {
        this.add(key, value);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (null != namespaceURI) {
            this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", namespaceURI);
        }
        for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
            String namespacePrefix = entry.getKey();
            this.attribute("http://www.w3.org/2000/xmlns/", namespacePrefix, "xmlns:" + namespacePrefix, entry.getValue());
        }
    }

    public abstract void startDocument(String var1, String var2);

    public abstract void endDocument();

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.endPrefixMapping(entry.getKey());
            }
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(String var1, String var2, String var3);

    public void element(String namespaceURI, String localName, String name, String prefix) {
        this.element(namespaceURI, localName, name);
    }

    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    public abstract void attribute(String var1, String var2, String var3, String var4);

    public abstract void closeStartElement();

    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    public abstract void characters(String var1);

    public abstract void cdata(String var1);

    public abstract void node(Node var1, NamespaceResolver var2);

    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (null == this.groupingElements) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int groupingElementsSize = this.groupingElements.size();
        for (int x = 0; x < groupingElementsSize; ++x) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            if (x == groupingElementsSize - 1) continue;
            this.closeStartElement();
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (null != groupingFragment) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            Integer index = (Integer)this.getPositionalNodes().get(xPathFragment.getShortName());
            int start = null == index ? 1 : index;
            for (int x = start; x < xPathFragment.getIndexValue(); ++x) {
                this.element(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), xPathFragment.getShortName(), xPathFragment.getPrefix());
            }
            this.getPositionalNodes().put(xPathFragment.getShortName(), new Integer(xPathFragment.getIndexValue() + 1));
        }
    }
}

