/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public abstract class JPAInitializer {
    protected boolean shouldCreateInternalLoader = true;
    protected ClassLoader initializationClassloader = null;

    public static void initializeTopLinkLoggingFile() {
        String loggingFile = System.getProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                AbstractSessionLog.getLog().setWriter(new FileWriter(loggingFile));
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", loggingFile, e);
        }
    }

    public EntityManagerSetupImpl callPredeploy(SEPersistenceUnitInfo persistenceUnitInfo, Map m, PersistenceInitializationHelper persistenceHelper, String persistenceUnitUniqueName, String sessionName) {
        AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", persistenceUnitInfo.getPersistenceUnitName());
        Map mergedProperties = EntityManagerFactoryProvider.mergeMaps(m, persistenceUnitInfo.getProperties());
        this.checkWeaving(mergedProperties);
        Set<String> tempLoaderSet = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo, Thread.currentThread().getContextClassLoader());
        ClassLoader tempLoader = this.createTempLoader(tempLoaderSet);
        persistenceUnitInfo.setNewTempClassLoader(tempLoader);
        persistenceUnitInfo.setClassLoader(persistenceHelper.getClassLoader(persistenceUnitInfo.getPersistenceUnitName(), m));
        EntityManagerSetupImpl emSetupImpl = new EntityManagerSetupImpl(persistenceUnitUniqueName, sessionName);
        ClassTransformer transformer = emSetupImpl.predeploy(persistenceUnitInfo, mergedProperties);
        persistenceUnitInfo.setNewTempClassLoader(persistenceUnitInfo.getClassLoader());
        this.registerTransformer(transformer, persistenceUnitInfo);
        return emSetupImpl;
    }

    public abstract void checkWeaving(Map var1);

    protected abstract ClassLoader createTempLoader(Collection var1);

    protected abstract ClassLoader createTempLoader(Collection var1, boolean var2);

    public SEPersistenceUnitInfo findPersistenceUnitInfo(String puName, Map m, PersistenceInitializationHelper persistenceHelper) {
        SEPersistenceUnitInfo persistenceUnitInfo = null;
        if (EntityManagerFactoryProvider.initialPuInfos != null && (persistenceUnitInfo = EntityManagerFactoryProvider.initialPuInfos.get(puName)) != null) {
            return persistenceUnitInfo;
        }
        return this.findPersistenceUnitInfoInArchives(puName, m, persistenceHelper);
    }

    protected SEPersistenceUnitInfo findPersistenceUnitInfoInArchives(String puName, Map m, PersistenceInitializationHelper persistenceHelper) {
        Archive archive;
        SEPersistenceUnitInfo persistenceUnitInfo = null;
        Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader);
        Iterator<Archive> i$ = pars.iterator();
        while (i$.hasNext() && (persistenceUnitInfo = this.findPersistenceUnitInfoInArchive(puName, archive = i$.next(), m, persistenceHelper)) == null) {
        }
        return persistenceUnitInfo;
    }

    protected SEPersistenceUnitInfo findPersistenceUnitInfoInArchive(String puName, Archive archive, Map m, PersistenceInitializationHelper persistenceActivator) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.initializationClassloader)) {
            if (!this.isPersistenceProviderSupported(persistenceUnitInfo.getPersistenceProviderClassName()) || !persistenceUnitInfo.getPersistenceUnitName().equals(puName)) continue;
            return persistenceUnitInfo;
        }
        return null;
    }

    public boolean isPersistenceProviderSupported(String providerClassName) {
        return providerClassName == null || providerClassName.equals("") || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName());
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound(entityClassName, classLoader, cnfEx);
            }
        }
        return entityClasses;
    }

    public abstract void registerTransformer(ClassTransformer var1, PersistenceUnitInfo var2);

    public boolean isPersistenceUnitUniquelyDefinedByName() {
        return true;
    }

    public String createUniquePersistenceUnitName(PersistenceUnitInfo puInfo) {
        return PersistenceUnitProcessor.buildPersistenceUnitName(puInfo.getPersistenceUnitRootUrl(), puInfo.getPersistenceUnitName());
    }
}

