/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ChangeTracking;
import org.eclipse.persistence.annotations.CloneCopyPolicy;
import org.eclipse.persistence.annotations.CopyPolicy;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.annotations.InstantiationCopyPolicy;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.Transformation;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DerivedIdClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ElementCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.TransformationAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VariableOneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VersionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.ChangeTrackingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CloneCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CustomCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.InstantiationCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassAccessor
extends MetadataAccessor {
    private boolean m_isPreProcessed = false;
    private boolean m_isProcessed = false;
    private Boolean m_excludeDefaultMappings;
    private Boolean m_metadataComplete;
    private ChangeTrackingMetadata m_changeTracking;
    private MetadataClass m_customizerClass;
    private CloneCopyPolicyMetadata m_cloneCopyPolicy;
    private CustomCopyPolicyMetadata m_customCopyPolicy;
    private InstantiationCopyPolicyMetadata m_instantiationCopyPolicy;
    private List<MetadataDescriptor> m_owningDescriptors = new ArrayList<MetadataDescriptor>();
    private String m_className;
    private String m_customizerClassName;
    private String m_description;
    private XMLAttributes m_attributes;

    protected ClassAccessor(String xmlElement) {
        super(xmlElement);
    }

    public ClassAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, new MetadataDescriptor(cls), project);
        this.getDescriptor().setClassAccessor(this);
    }

    protected ClassAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataDescriptor descriptor) {
        super(annotation, cls, descriptor, descriptor.getProject());
    }

    protected void addAccessor(MappingAccessor accessor) {
        if (accessor != null) {
            accessor.addConverters();
            if (accessor.isEmbeddedId()) {
                this.getProject().addIdClass(accessor.getReferenceClassName());
            }
            this.addPotentialEmbeddableAccessor(accessor.getReferenceClass(), accessor.getClassAccessor());
            if (accessor.isMappedKeyMapAccessor()) {
                MappedKeyMapAccessor mapAccessor = (MappedKeyMapAccessor)((Object)accessor);
                MetadataClass mapKeyClass = mapAccessor.getMapKeyClass();
                if (mapKeyClass == null || mapKeyClass.equals(Void.TYPE)) {
                    mapKeyClass = accessor.getAccessibleObject().getMapKeyClass(this.getDescriptor());
                    if (mapKeyClass == null && mapAccessor.getMapKey() == null) {
                        throw ValidationException.unableToDetermineMapKeyClass(accessor.getAttributeName(), accessor.getJavaClass());
                    }
                    mapAccessor.setMapKeyClass(mapKeyClass);
                }
                this.addPotentialEmbeddableAccessor(mapKeyClass, accessor.getReferenceDescriptor(), accessor.getClassAccessor());
            }
            this.getDescriptor().addAccessor(accessor);
        }
    }

    public void addAccessors() {
        if (this.m_attributes != null) {
            for (MappingAccessor accessor : this.m_attributes.getAccessors()) {
                MetadataAnnotatedElement accessibleObject = null;
                accessor.initXMLMappingAccessor(this);
                if (accessor.usesPropertyAccess(this.getDescriptor())) {
                    if (accessor.getAccessMethods() != null) {
                        String getMethodName = accessor.getAccessMethods().getGetMethodName();
                        MetadataMethod getMethod = this.getJavaClass().getMethod(getMethodName, new String[0]);
                        String setMethodName = accessor.getAccessMethods().getSetMethodName();
                        MetadataMethod setMethod = this.getJavaClass().getMethod(setMethodName, Arrays.asList(getMethod.getReturnType()));
                        getMethod.setSetMethod(setMethod);
                        accessibleObject = getMethod;
                    } else {
                        MetadataMethod method = this.getJavaClass().getMethodForPropertyName(accessor.getName());
                        if (method == null) {
                            throw ValidationException.invalidPropertyForClass(accessor.getName(), this.getJavaClass());
                        }
                        if (accessor.isTransient() || method.isValidPersistenceMethod(this.getDescriptor(), true)) {
                            accessibleObject = method;
                        }
                    }
                } else {
                    MetadataField field = this.getJavaClass().getField(accessor.getName());
                    if (field == null) {
                        throw ValidationException.invalidFieldForClass(accessor.getName(), this.getJavaClass());
                    }
                    if (accessor.isTransient() || field.isValidPersistenceField(this.getDescriptor(), true)) {
                        accessibleObject = field;
                    }
                }
                accessor.initXMLObject(accessibleObject, this.getEntityMappings());
                accessor.initAccess();
                this.addAccessor(accessor);
            }
        }
        if (this.usesPropertyAccess()) {
            this.addAccessorMethods(false);
        } else {
            this.addAccessorFields(false);
        }
    }

    protected void addAccessorFields(boolean processingInverse) {
        for (MetadataField metadataField : this.getJavaClass().getFields().values()) {
            if (metadataField.isAnnotationPresent(Transient.class, this.getDescriptor())) {
                if (metadataField.areAnnotationsCompatibleWithTransient(this.getDescriptor())) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(metadataField);
            }
            if (!metadataField.isValidPersistenceField(processingInverse, this.getDescriptor()) || this.getDescriptor().hasAccessorFor(metadataField.getAttributeName()) && (!this.getDescriptor().hasAccessorFor(metadataField.getAttributeName()) || !processingInverse)) continue;
            this.addAccessor(this.buildAccessor(metadataField));
        }
        if (this.hasAccess() && !processingInverse) {
            this.addAccessorMethods(true);
        }
    }

    protected void addAccessorMethods(boolean processingInverse) {
        for (MetadataMethod metadataMethod : this.getJavaClass().getMethods().values()) {
            if (metadataMethod.isAnnotationPresent(Transient.class, this.getDescriptor())) {
                if (metadataMethod.areAnnotationsCompatibleWithTransient(this.getDescriptor())) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(metadataMethod);
            }
            if (!metadataMethod.isValidPersistenceMethod(processingInverse, this.getDescriptor()) || this.getDescriptor().hasAccessorFor(metadataMethod.getAttributeName()) && (!this.getDescriptor().hasAccessorFor(metadataMethod.getAttributeName()) || !processingInverse)) continue;
            this.addAccessor(this.buildAccessor(metadataMethod));
        }
        if (this.hasAccess() && !processingInverse) {
            this.addAccessorFields(true);
        }
    }

    protected void addPotentialEmbeddableAccessor(MetadataClass potentialEmbeddableClass, ClassAccessor embeddingAccessor) {
        this.addPotentialEmbeddableAccessor(potentialEmbeddableClass, this.getDescriptor(), embeddingAccessor);
    }

    protected void addPotentialEmbeddableAccessor(MetadataClass potentialEmbeddableClass, MetadataDescriptor owningDescriptor, ClassAccessor embeddingAccessor) {
        EmbeddableAccessor embeddableAccessor;
        if (potentialEmbeddableClass != null && (embeddableAccessor = this.getProject().getEmbeddableAccessor(potentialEmbeddableClass)) != null) {
            embeddableAccessor.addEmbeddingAccessor(embeddingAccessor);
            embeddableAccessor.addOwningDescriptor(owningDescriptor);
            this.getProject().addRootEmbeddableAccessor(embeddableAccessor);
        }
    }

    protected MappingAccessor buildAccessor(MetadataAnnotatedElement accessibleObject) {
        if (accessibleObject.isBasicCollection(this.getDescriptor())) {
            return new BasicCollectionAccessor(accessibleObject.getAnnotation(BasicCollection.class), accessibleObject, this);
        }
        if (accessibleObject.isBasicMap(this.getDescriptor())) {
            return new BasicMapAccessor(accessibleObject.getAnnotation(BasicMap.class), accessibleObject, this);
        }
        if (accessibleObject.isElementCollection(this.getDescriptor())) {
            return new ElementCollectionAccessor(accessibleObject.getAnnotation(ElementCollection.class), accessibleObject, this);
        }
        if (accessibleObject.isVersion(this.getDescriptor())) {
            return new VersionAccessor(accessibleObject.getAnnotation(Version.class), accessibleObject, this);
        }
        if (accessibleObject.isId(this.getDescriptor()) && !accessibleObject.isDerivedId(this.getDescriptor())) {
            return new IdAccessor(accessibleObject.getAnnotation(Id.class), accessibleObject, this);
        }
        if (accessibleObject.isDerivedIdClass(this.getDescriptor())) {
            return new DerivedIdClassAccessor(accessibleObject, this);
        }
        if (accessibleObject.isBasic(this.getDescriptor())) {
            return new BasicAccessor(accessibleObject.getAnnotation(Basic.class), accessibleObject, this);
        }
        if (accessibleObject.isEmbedded(this.getDescriptor())) {
            return new EmbeddedAccessor(accessibleObject.getAnnotation(Embedded.class), accessibleObject, this);
        }
        if (accessibleObject.isEmbeddedId(this.getDescriptor())) {
            return new EmbeddedIdAccessor(accessibleObject.getAnnotation(EmbeddedId.class), accessibleObject, this);
        }
        if (accessibleObject.isTransformation(this.getDescriptor())) {
            return new TransformationAccessor(accessibleObject.getAnnotation(Transformation.class), accessibleObject, this);
        }
        if (accessibleObject.isManyToMany(this.getDescriptor())) {
            return new ManyToManyAccessor(accessibleObject.getAnnotation(ManyToMany.class), accessibleObject, this);
        }
        if (accessibleObject.isManyToOne(this.getDescriptor())) {
            return new ManyToOneAccessor(accessibleObject.getAnnotation(ManyToOne.class), accessibleObject, this);
        }
        if (accessibleObject.isOneToMany(this.getDescriptor())) {
            return new OneToManyAccessor(accessibleObject.getAnnotation(OneToMany.class), accessibleObject, this);
        }
        if (accessibleObject.isOneToOne(this.getDescriptor())) {
            return new OneToOneAccessor(accessibleObject.getAnnotation(OneToOne.class), accessibleObject, this);
        }
        if (accessibleObject.isVariableOneToOne(this.getDescriptor())) {
            return new VariableOneToOneAccessor(accessibleObject.getAnnotation(VariableOneToOne.class), accessibleObject, this);
        }
        if (this.getDescriptor().ignoreDefaultMappings()) {
            return null;
        }
        return new BasicAccessor(accessibleObject.getAnnotation(Basic.class), accessibleObject, this);
    }

    public boolean excludeDefaultMappings() {
        return this.m_excludeDefaultMappings != null && this.m_excludeDefaultMappings != false;
    }

    public String getAccessType() {
        if (this.hasAccess()) {
            return super.getAccess();
        }
        return this.getDescriptor().getDefaultAccess();
    }

    public XMLAttributes getAttributes() {
        return this.m_attributes;
    }

    public ChangeTrackingMetadata getChangeTracking() {
        return this.m_changeTracking;
    }

    public String getClassName() {
        return this.m_className;
    }

    public CopyPolicyMetadata getCopyPolicy() {
        if (this.m_cloneCopyPolicy != null) {
            return this.m_cloneCopyPolicy;
        }
        if (this.m_instantiationCopyPolicy != null) {
            return this.m_instantiationCopyPolicy;
        }
        return this.m_customCopyPolicy;
    }

    public CloneCopyPolicyMetadata getCloneCopyPolicy() {
        return this.m_cloneCopyPolicy;
    }

    public CustomCopyPolicyMetadata getCustomCopyPolicy() {
        return this.m_customCopyPolicy;
    }

    public MetadataClass getCustomizerClass() {
        return this.m_customizerClass;
    }

    public String getCustomizerClassName() {
        return this.m_customizerClassName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Boolean getExcludeDefaultMappings() {
        return this.m_excludeDefaultMappings;
    }

    @Override
    public String getIdentifier() {
        return this.getJavaClassName();
    }

    public InstantiationCopyPolicyMetadata getInstantiationCopyPolicy() {
        return this.m_instantiationCopyPolicy;
    }

    @Override
    public MetadataClass getJavaClass() {
        return (MetadataClass)this.getAnnotatedElement();
    }

    @Override
    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public Boolean getMetadataComplete() {
        return this.m_metadataComplete;
    }

    public MetadataDescriptor getOwningDescriptor() {
        return this.getDescriptor();
    }

    public List<MetadataDescriptor> getOwningDescriptors() {
        if (this.m_owningDescriptors.isEmpty() && !this.isEmbeddableAccessor()) {
            this.m_owningDescriptors.add(this.getDescriptor());
        }
        return this.m_owningDescriptors;
    }

    public boolean hasDerivedId() {
        return !this.getDescriptor().getDerivedIdAccessors().isEmpty();
    }

    protected boolean havePersistenceFieldAnnotationsDefined(Collection<MetadataField> fields) {
        for (MetadataField field : fields) {
            if (!field.hasDeclaredAnnotations(this.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    protected boolean havePersistenceMethodAnnotationsDefined(Collection<MetadataMethod> methods) {
        for (MetadataMethod method : methods) {
            if (!method.hasDeclaredAnnotations(this.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    public boolean isMappedSuperclass() {
        return false;
    }

    public boolean isMetadataComplete() {
        return this.m_metadataComplete != null && this.m_metadataComplete != false;
    }

    public boolean isPreProcessed() {
        return this.m_isPreProcessed;
    }

    @Override
    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    public void initXMLClassAccessor(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project, XMLEntityMappings entityMappings) {
        this.initXMLAccessor(descriptor, project);
        this.initXMLObject(accessibleObject, entityMappings);
        this.initAccess();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_changeTracking, accessibleObject);
        this.initXMLObject(this.m_cloneCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_customCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_instantiationCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_attributes, accessibleObject);
        this.m_customizerClass = this.initXMLClassName(this.m_customizerClassName);
    }

    public boolean isClassAccessor() {
        return true;
    }

    public boolean isEmbeddableAccessor() {
        return false;
    }

    public boolean isEntityAccessor() {
        return false;
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        ClassAccessor accessor = (ClassAccessor)metadata;
        this.m_customizerClass = (MetadataClass)this.mergeSimpleObjects(this.m_customizerClass, accessor.getCustomizerClass(), accessor, "<customizer>");
        this.m_description = (String)this.mergeSimpleObjects(this.m_description, accessor.getDescription(), accessor, "<description>");
        this.m_metadataComplete = (Boolean)this.mergeSimpleObjects(this.m_metadataComplete, accessor.getMetadataComplete(), accessor, "@metadata-complete");
        this.m_excludeDefaultMappings = (Boolean)this.mergeSimpleObjects(this.m_excludeDefaultMappings, accessor.getExcludeDefaultMappings(), accessor, "@exclude-default-mappings");
        this.m_cloneCopyPolicy = (CloneCopyPolicyMetadata)this.mergeORObjects(this.m_cloneCopyPolicy, accessor.getCloneCopyPolicy());
        this.m_customCopyPolicy = (CustomCopyPolicyMetadata)this.mergeORObjects(this.m_customCopyPolicy, accessor.getCustomCopyPolicy());
        this.m_instantiationCopyPolicy = (InstantiationCopyPolicyMetadata)this.mergeORObjects(this.m_instantiationCopyPolicy, accessor.getInstantiationCopyPolicy());
        this.m_changeTracking = (ChangeTrackingMetadata)this.mergeORObjects(this.m_changeTracking, accessor.getChangeTracking());
        if (this.m_attributes == null) {
            this.m_attributes = accessor.getAttributes();
        } else {
            this.m_attributes.merge(accessor.getAttributes());
        }
    }

    public abstract void preProcess();

    public abstract void preProcessForCanonicalModel();

    @Override
    public abstract void process();

    public void processAccessors() {
        this.getDescriptor().processAccessors();
    }

    protected void processChangeTracking() {
        MetadataAnnotation changeTracking = this.getAnnotation(ChangeTracking.class);
        if (this.m_changeTracking != null || changeTracking != null) {
            if (this.getDescriptor().hasChangeTracking()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_change_tracking", this.getDescriptor().getJavaClass(), (Object)this.getJavaClass());
            } else if (this.m_changeTracking == null) {
                new ChangeTrackingMetadata(changeTracking, this.getAccessibleObject()).process(this.getDescriptor());
            } else {
                if (changeTracking != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", changeTracking, (Object)this.getJavaClassName(), this.getLocation());
                }
                this.m_changeTracking.process(this.getDescriptor());
            }
        }
    }

    protected void processCopyPolicy() {
        MetadataAnnotation copyPolicy = this.getAnnotation(CopyPolicy.class);
        MetadataAnnotation instantiationCopyPolicy = this.getAnnotation(InstantiationCopyPolicy.class);
        MetadataAnnotation cloneCopyPolicy = this.getAnnotation(CloneCopyPolicy.class);
        if (this.getCopyPolicy() != null || copyPolicy != null || instantiationCopyPolicy != null || cloneCopyPolicy != null) {
            if (this.getDescriptor().hasCopyPolicy()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_copy_policy", this.getDescriptor().getJavaClass(), (Object)this.getJavaClass());
            }
            if (this.getCopyPolicy() == null) {
                if (copyPolicy != null) {
                    if (instantiationCopyPolicy != null || cloneCopyPolicy != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass(this.getJavaClassName());
                    }
                    new CustomCopyPolicyMetadata(copyPolicy, this.getAccessibleObject()).process(this.getDescriptor());
                }
                if (instantiationCopyPolicy != null) {
                    if (cloneCopyPolicy != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass(this.getJavaClassName());
                    }
                    new InstantiationCopyPolicyMetadata(instantiationCopyPolicy, this.getAccessibleObject()).process(this.getDescriptor());
                }
                if (cloneCopyPolicy != null) {
                    new CloneCopyPolicyMetadata(cloneCopyPolicy, this.getAccessibleObject()).process(this.getDescriptor());
                }
            } else {
                if (copyPolicy != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", copyPolicy, (Object)this.getJavaClassName(), this.getLocation());
                }
                if (instantiationCopyPolicy != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", instantiationCopyPolicy, (Object)this.getJavaClassName(), this.getLocation());
                }
                if (cloneCopyPolicy != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", cloneCopyPolicy, (Object)this.getJavaClassName(), this.getLocation());
                }
                this.getCopyPolicy().process(this.getDescriptor());
            }
        }
    }

    protected void processCustomizer() {
        MetadataAnnotation customizer = this.getAnnotation(Customizer.class);
        if (this.m_customizerClass != null && !this.m_customizerClass.equals(Void.TYPE) || customizer != null) {
            if (this.getDescriptor().hasCustomizer()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_customizer", this.getDescriptor().getJavaClass(), (Object)this.getJavaClass());
            } else {
                if (this.m_customizerClass == null || this.m_customizerClass.equals(Void.TYPE)) {
                    this.m_customizerClass = this.getMetadataClass((String)customizer.getAttribute("value"));
                } else if (customizer != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", customizer, (Object)this.getJavaClassName(), this.getLocation());
                }
                this.getProject().addAccessorWithCustomizer(this);
            }
        }
    }

    public void processDerivedId(HashSet<ClassAccessor> processing, HashSet<ClassAccessor> processed) {
        if (!processed.contains(this)) {
            if (processing.contains(this)) {
                throw ValidationException.idRelationshipCircularReference(processing);
            }
            processing.add(this);
            for (ObjectAccessor accessor : this.getDescriptor().getDerivedIdAccessors()) {
                MetadataDescriptor referenceDescriptor = accessor.getReferenceDescriptor();
                ClassAccessor referenceAccessor = referenceDescriptor.getClassAccessor();
                if (referenceAccessor.hasDerivedId()) {
                    referenceAccessor.processDerivedId(processing, processed);
                }
                accessor.processRelationship();
            }
            processing.remove(this);
            processed.add(this);
        }
    }

    protected void processProperties() {
        MetadataAnnotation metadataAnnotation;
        for (PropertyMetadata propertyMetadata : this.getProperties()) {
            this.getDescriptor().addProperty(propertyMetadata);
        }
        MetadataAnnotation properties = this.getAnnotation(Properties.class);
        if (properties != null) {
            for (Object property3 : (Object[])properties.getAttributeArray("value")) {
                this.getDescriptor().addProperty(new PropertyMetadata((MetadataAnnotation)property3, this.getAccessibleObject()));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(Property.class)) != null) {
            this.getDescriptor().addProperty(new PropertyMetadata(metadataAnnotation, this.getAccessibleObject()));
        }
    }

    public void setAttributes(XMLAttributes attributes) {
        this.m_attributes = attributes;
    }

    public void setChangeTracking(ChangeTrackingMetadata changeTracking) {
        this.m_changeTracking = changeTracking;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setCloneCopyPolicy(CloneCopyPolicyMetadata copyPolicy) {
        this.m_cloneCopyPolicy = copyPolicy;
    }

    public void setCustomCopyPolicy(CustomCopyPolicyMetadata copyPolicy) {
        this.m_customCopyPolicy = copyPolicy;
    }

    public void setCustomizerClassName(String customizerClassName) {
        this.m_customizerClassName = customizerClassName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setExcludeDefaultMappings(Boolean excludeDefaultMappings) {
        this.m_excludeDefaultMappings = excludeDefaultMappings;
    }

    public void setInstantiationCopyPolicy(InstantiationCopyPolicyMetadata copyPolicy) {
        this.m_instantiationCopyPolicy = copyPolicy;
    }

    protected void setIsPreProcessed() {
        this.m_isPreProcessed = true;
    }

    protected void setIsProcessed() {
        this.m_isProcessed = true;
    }

    public void setJavaClass(MetadataClass cls) {
        this.setAccessibleObject(cls);
        this.getDescriptor().setJavaClass(cls);
    }

    public void setMetadataComplete(Boolean metadataComplete) {
        this.m_metadataComplete = metadataComplete;
    }

    public String toString() {
        return this.getJavaClassName();
    }

    public boolean usesPropertyAccess() {
        return this.getAccessType().equals("PROPERTY");
    }
}

