/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitProperty;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.oxm.XMLContext;

public class PersistenceUnit {
    protected List<XMLEntityMappings> xmlEntityMappings;
    protected MetadataProject project;
    protected MetadataMirrorFactory factory;
    protected PersistenceUnitReader persistenceUnitReader;
    protected ProcessingEnvironment processingEnv;
    protected SEPersistenceUnitInfo persistenceUnitInfo;
    protected HashMap<String, String> persistenceUnitProperties;

    public PersistenceUnit(SEPersistenceUnitInfo puInfo, MetadataMirrorFactory mirrorFactory, PersistenceUnitReader reader) {
        this.factory = mirrorFactory;
        this.persistenceUnitInfo = puInfo;
        this.persistenceUnitReader = reader;
        this.processingEnv = this.factory.getProcessingEnvironment();
        this.project = this.factory.getMetadataProject(this.persistenceUnitInfo);
        this.initPersistenceUnitProperties();
        this.initXMLEntityMappings();
    }

    public void addEmbeddableAccessor(Element element) {
        MetadataClass cls = this.factory.getMetadataClass(element);
        if (this.project.hasEmbeddable(cls)) {
            EmbeddableAccessor embeddableAccessor = this.project.getEmbeddableAccessor(cls);
            if (!embeddableAccessor.loadedFromXML() && !this.excludeUnlistedClasses(cls)) {
                this.addEmbeddableAccessor(new EmbeddableAccessor(cls.getAnnotation(Embeddable.class), cls, this.project));
            }
        } else if (!this.excludeUnlistedClasses(cls)) {
            this.addEmbeddableAccessor(new EmbeddableAccessor(cls.getAnnotation(Embeddable.class), cls, this.project));
        }
    }

    protected void addEmbeddableAccessor(EmbeddableAccessor embeddableAccessor) {
        if (this.project.hasEmbeddable(embeddableAccessor.getJavaClass())) {
            EmbeddableAccessor existingEmbeddableAccessor = this.project.getEmbeddableAccessor(embeddableAccessor.getJavaClass());
            embeddableAccessor.addEmbeddingAccessors(existingEmbeddableAccessor.getEmbeddingAccessors());
            embeddableAccessor.addOwningDescriptors(existingEmbeddableAccessor.getOwningDescriptors());
        }
        this.project.addEmbeddableAccessor(embeddableAccessor);
    }

    public void addEntityAccessor(Element element) {
        MetadataClass cls = this.factory.getMetadataClass(element);
        if (this.project.hasEntity(cls)) {
            EntityAccessor entityAccessor = this.project.getEntityAccessor(cls);
            if (!entityAccessor.loadedFromXML() && !this.excludeUnlistedClasses(cls)) {
                this.project.addEntityAccessor(new EntityAccessor(cls.getAnnotation(Entity.class), cls, this.project));
            }
        } else if (!this.excludeUnlistedClasses(cls)) {
            this.project.addEntityAccessor(new EntityAccessor(cls.getAnnotation(Entity.class), cls, this.project));
        }
    }

    public void addMappedSuperclassAccessor(Element element) {
        MetadataClass cls = this.factory.getMetadataClass(element);
        if (this.project.hasMappedSuperclass(cls)) {
            MappedSuperclassAccessor mappedSuperclassAccessor = this.project.getMappedSuperclass(cls);
            if (!mappedSuperclassAccessor.loadedFromXML() && !this.excludeUnlistedClasses(cls)) {
                this.project.addMappedSuperclass(new MappedSuperclassAccessor(cls.getAnnotation(MappedSuperclass.class), cls, this.project));
            }
        } else if (!this.excludeUnlistedClasses(cls)) {
            this.project.addMappedSuperclass(new MappedSuperclassAccessor(cls.getAnnotation(MappedSuperclass.class), cls, this.project));
        }
    }

    protected void addPropertyFromOptions(String propertyName) {
        if (!this.persistenceUnitProperties.containsKey(propertyName) || this.persistenceUnitProperties.get(propertyName) == null) {
            this.persistenceUnitProperties.put(propertyName, this.processingEnv.getOptions().get(propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addXMLEntityMappings(FileObject fileObject, String mappingFile, XMLContext context) throws IOException {
        InputStream in = null;
        try {
            in = fileObject.openInputStream();
            XMLEntityMappings entityMappings = (XMLEntityMappings)context.createUnmarshaller().unmarshal(in);
            entityMappings.setIsEclipseLinkORMFile(mappingFile.equals("META-INF/eclipselink-orm.xml"));
            entityMappings.setMappingFile(mappingFile);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "File loaded : " + mappingFile + ", is eclipselink-orm file: " + entityMappings.isEclipseLinkORMFile());
            this.xmlEntityMappings.add(entityMappings);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void addXMLEntityMappings(String mappingFile) {
        try {
            FileObject fileObject = null;
            try {
                fileObject = this.persistenceUnitReader.getFileObject(mappingFile, this.processingEnv);
                this.addXMLEntityMappings(fileObject, mappingFile, XMLEntityMappingsReader.getEclipseLinkOrmProject());
            }
            catch (XMLMarshalException e) {
                try {
                    this.addXMLEntityMappings(fileObject, mappingFile, XMLEntityMappingsReader.getOrm2Project());
                }
                catch (XMLMarshalException ee) {
                    this.addXMLEntityMappings(fileObject, mappingFile, XMLEntityMappingsReader.getOrm1Project());
                }
            }
        }
        catch (IOException exception) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "File was not found: " + mappingFile);
        }
    }

    public boolean containsElement(Element element) {
        MetadataClass cls = this.factory.getMetadataClass(element);
        if (this.project.hasEntity(cls)) {
            return this.isValidAccessor(this.project.getEntityAccessor(cls), (Annotation)element.getAnnotation(Entity.class));
        }
        if (this.project.hasEmbeddable(cls)) {
            return this.isValidAccessor(this.project.getEmbeddableAccessor(cls), (Annotation)element.getAnnotation(Embeddable.class));
        }
        if (this.project.hasMappedSuperclass(cls)) {
            return this.isValidAccessor(this.project.getMappedSuperclass(cls), (Annotation)element.getAnnotation(MappedSuperclass.class));
        }
        return false;
    }

    protected boolean excludeUnlistedClasses(MetadataClass cls) {
        return !this.persistenceUnitInfo.getManagedClassNames().contains(cls.getName()) && this.persistenceUnitInfo.excludeUnlistedClasses();
    }

    public ClassAccessor getClassAccessor(Element element) {
        String elementString = element.toString();
        if (this.project.hasEntity(elementString)) {
            return this.project.getEntityAccessor(elementString);
        }
        if (this.project.hasEmbeddable(elementString)) {
            return this.project.getEmbeddableAccessor(elementString);
        }
        if (this.project.hasMappedSuperclass(elementString)) {
            return this.project.getMappedSuperclass(elementString);
        }
        return null;
    }

    public String getQualifiedCanonicalName(String qualifiedName) {
        return MetadataHelper.getQualifiedCanonicalName(qualifiedName, this.persistenceUnitProperties);
    }

    public void initPersistenceUnitProperties() {
        this.persistenceUnitProperties = new HashMap();
        for (SEPersistenceUnitProperty property : this.persistenceUnitInfo.getPersistenceUnitProperties()) {
            if (property.getName() == null) continue;
            this.persistenceUnitProperties.put(property.getName(), property.getValue());
        }
        this.addPropertyFromOptions("eclipselink.canonicalmodel.prefix");
        this.addPropertyFromOptions("eclipselink.canonicalmodel.suffix");
        this.addPropertyFromOptions("eclipselink.canonicalmodel.subpackage");
    }

    protected void initXMLEntityMappings() {
        this.xmlEntityMappings = new ArrayList<XMLEntityMappings>();
        this.addXMLEntityMappings("META-INF/orm.xml");
        Boolean excludeEclipseLinkORM = false;
        if (this.persistenceUnitProperties.containsKey("eclipselink.exclude-eclipselink-orm")) {
            excludeEclipseLinkORM = new Boolean(this.persistenceUnitProperties.get("eclipselink.exclude-eclipselink-orm"));
        }
        if (!excludeEclipseLinkORM.booleanValue()) {
            this.addXMLEntityMappings("META-INF/eclipselink-orm.xml");
        }
        for (String mappingFile : this.persistenceUnitInfo.getMappingFileNames()) {
            if (mappingFile.equals("META-INF/orm.xml") || mappingFile.equals("META-INF/eclipselink-orm.xml")) continue;
            this.addXMLEntityMappings(mappingFile);
        }
        for (XMLEntityMappings entityMappings : this.xmlEntityMappings) {
            entityMappings.setLoader(this.factory.getLoader());
            entityMappings.setProject(this.project);
            entityMappings.setMetadataFactory(this.factory);
            entityMappings.processPersistenceUnitMetadata();
        }
        HashMap<String, EntityAccessor> entities = new HashMap<String, EntityAccessor>();
        HashMap<String, EmbeddableAccessor> embeddables = new HashMap<String, EmbeddableAccessor>();
        for (XMLEntityMappings entityMappings : this.xmlEntityMappings) {
            entityMappings.initPersistenceUnitClasses(entities, embeddables);
        }
        for (EntityAccessor entity : entities.values()) {
            this.project.addEntityAccessor(entity);
            entity.getEntityMappings().processEntityMappingsDefaults(entity);
        }
        for (EmbeddableAccessor embeddable : embeddables.values()) {
            this.addEmbeddableAccessor(embeddable);
            embeddable.getEntityMappings().processEntityMappingsDefaults(embeddable);
        }
    }

    protected boolean isValidAccessor(ClassAccessor accessor, Annotation annotation) {
        if (!accessor.loadedFromXML()) {
            return annotation != null;
        }
        return true;
    }

    public void preProcessForCanonicalModel() {
        for (EntityAccessor entityAccessor : this.project.getEntityAccessors()) {
            if (!this.shouldPreProcess(entityAccessor)) continue;
            entityAccessor.preProcessForCanonicalModel();
        }
        for (MappedSuperclassAccessor mappedSuperclassAccessor : this.project.getMappedSuperclasses()) {
            if (!this.shouldPreProcess(mappedSuperclassAccessor)) continue;
            mappedSuperclassAccessor.preProcessForCanonicalModel();
        }
        for (EmbeddableAccessor embeddableAccessor : this.project.getRootEmbeddableAccessors()) {
            if (!this.shouldPreProcess(embeddableAccessor)) continue;
            embeddableAccessor.preProcessForCanonicalModel();
        }
        for (EmbeddableAccessor embeddableAccessor : this.project.getEmbeddableAccessors()) {
            if (!this.shouldPreProcess(embeddableAccessor)) continue;
            if (embeddableAccessor.getAccessType() == null) {
                embeddableAccessor.getDescriptor().setDefaultAccess("FIELD");
            }
            embeddableAccessor.preProcessForCanonicalModel();
        }
    }

    protected boolean shouldPreProcess(ClassAccessor accessor) {
        return !accessor.isPreProcessed() && this.factory.isRoundElement((MetadataClass)accessor.getAccessibleObject());
    }

    public String toString() {
        return this.persistenceUnitInfo.getPersistenceUnitName();
    }
}

