/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRefs;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransient;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;
import org.eclipse.persistence.oxm.NamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProcessor {
    private Map<String, XmlBindings> xmlBindingMap;
    private JavaModelInput jModelInput;
    private AnnotationsProcessor aProcessor;
    private JAXBMetadataLogger logger;

    public XMLProcessor(Map<String, XmlBindings> bindings) {
        this.xmlBindingMap = bindings;
    }

    public void processXML(AnnotationsProcessor annotationsProcessor, JavaModelInput jModelInput) {
        this.jModelInput = jModelInput;
        this.aProcessor = annotationsProcessor;
        annotationsProcessor.init();
        Map<String, ArrayList<JavaClass>> pkgToClassMap = this.buildPackageToJavaClassMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            ArrayList<JavaClass> classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) {
                this.getLogger().logWarning("jaxb_metadata_warning_no_classes_to_process", new Object[]{packageName});
                continue;
            }
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            NamespaceInfo nsInfo = this.processXmlSchema(xmlBindings, packageName);
            if (nsInfo != null) {
                annotationsProcessor.addPackageToNamespaceMapping(packageName, nsInfo);
            }
            JavaClass[] javaClasses = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            Map<String, TypeInfo> typeInfoMap = annotationsProcessor.preBuildTypeInfo(javaClasses);
            nsInfo = annotationsProcessor.getPackageToNamespaceMappings().get(packageName);
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    TypeInfo info = typeInfoMap.get(javaType.getName());
                    if (javaType.getXmlJavaTypeAdapter() != null) {
                        info.setXmlJavaTypeAdapter(javaType.getXmlJavaTypeAdapter());
                    }
                    if (javaType.isSetXmlAccessorOrder()) {
                        info.setXmlAccessOrder(javaType.getXmlAccessorOrder());
                    } else if (!info.isSetXmlAccessOrder()) {
                        if (xmlBindings.isSetXmlAccessorOrder()) {
                            info.setXmlAccessOrder(xmlBindings.getXmlAccessorOrder());
                        } else {
                            info.setXmlAccessOrder(nsInfo.getAccessOrder());
                        }
                    }
                    if (javaType.isSetXmlAccessorType()) {
                        info.setXmlAccessType(javaType.getXmlAccessorType());
                    } else if (!info.isSetXmlAccessType()) {
                        if (xmlBindings.isSetXmlAccessorType()) {
                            info.setXmlAccessType(xmlBindings.getXmlAccessorType());
                        } else {
                            info.setXmlAccessType(nsInfo.getAccessType());
                        }
                    }
                    if (javaType.isSetXmlTransient()) {
                        info.setXmlTransient(javaType.isXmlTransient());
                    }
                    if (javaType.getXmlRootElement() != null) {
                        info.setXmlRootElement(javaType.getXmlRootElement());
                    }
                    if (javaType.getXmlSeeAlso() != null && javaType.getXmlSeeAlso().size() > 0) {
                        info.setXmlSeeAlso(javaType.getXmlSeeAlso());
                    }
                    if (javaType.getXmlType() != null) {
                        info.setXmlType(javaType.getXmlType());
                    }
                    if (javaType.getXmlCustomizer() == null) continue;
                    info.setXmlCustomizer(javaType.getXmlCustomizer());
                }
            }
            if (xmlBindings.getXmlJavaTypeAdapters() != null) {
                Map<String, TypeInfo> typeInfos = this.aProcessor.getTypeInfosForPackage(packageName);
                for (TypeInfo tInfo : typeInfos.values()) {
                    List<XmlJavaTypeAdapter> adapters = xmlBindings.getXmlJavaTypeAdapters().getXmlJavaTypeAdapter();
                    for (XmlJavaTypeAdapter xja : adapters) {
                        JavaClass adapterClass = jModelInput.getJavaModel().getClass(xja.getValue());
                        JavaClass boundType = jModelInput.getJavaModel().getClass(xja.getType());
                        if (boundType == null) continue;
                        tInfo.addPackageLevelAdapterClass(adapterClass, boundType);
                    }
                }
            }
            javaClasses = annotationsProcessor.postBuildTypeInfo(javaClasses);
            annotationsProcessor.processJavaClasses(javaClasses);
            Map<String, TypeInfo> typeInfosForPackage = annotationsProcessor.getTypeInfosForPackage(packageName);
            jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    TypeInfo typeInfo = typeInfosForPackage.get(javaType.getName());
                    if (javaType == null) continue;
                    this.processJavaType(javaType, typeInfo, nsInfo);
                }
            }
            pkgToClassMap.remove(packageName);
        }
        for (ArrayList<JavaClass> jClassList : pkgToClassMap.values()) {
            JavaClass[] jClassArray = jClassList.toArray(new JavaClass[jClassList.size()]);
            annotationsProcessor.buildNewTypeInfo(jClassArray);
            annotationsProcessor.processJavaClasses(jClassArray);
        }
        Map typeInfos = (Map)this.aProcessor.getTypeInfo().clone();
        for (String key : typeInfos.keySet()) {
            TypeInfo tInfo = (TypeInfo)typeInfos.get(key);
            for (Property prop : tInfo.getPropertyList()) {
                if (!prop.isSetXmlJavaTypeAdapter()) continue;
                JavaClass[] jClassArray = new JavaClass[]{prop.getActualType()};
                this.aProcessor.buildNewTypeInfo(jClassArray);
            }
        }
        this.aProcessor.finalizeProperties();
    }

    private void processJavaType(JavaType javaType, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (null != javaType.getJavaAttributes()) {
            for (JAXBElement<? extends JavaAttribute> jaxbElement : javaType.getJavaAttributes().getJavaAttribute()) {
                JavaAttribute javaAttribute = (JavaAttribute)jaxbElement.getValue();
                Property oldProperty = typeInfo.getProperties().get(javaAttribute.getJavaAttribute());
                if (oldProperty == null) {
                    this.getLogger().logWarning(JAXBMetadataLogger.NO_PROPERTY_FOR_JAVA_ATTRIBUTE, new Object[]{javaAttribute.getJavaAttribute(), javaType.getName()});
                    continue;
                }
                Property newProperty = this.processJavaAttribute(typeInfo, javaAttribute, oldProperty, nsInfo, javaType);
                typeInfo.getProperties().put(javaAttribute.getJavaAttribute(), newProperty);
            }
        }
    }

    private Property processJavaAttribute(TypeInfo typeInfo, JavaAttribute javaAttribute, Property oldProperty, NamespaceInfo nsInfo, JavaType javaType) {
        if (javaAttribute instanceof XmlAnyAttribute) {
            return this.processXmlAnyAttribute((XmlAnyAttribute)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlAnyElement) {
            return this.processXmlAnyElement((XmlAnyElement)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAttribute) {
            return this.processXmlAttribute((XmlAttribute)javaAttribute, oldProperty, typeInfo, nsInfo);
        }
        if (javaAttribute instanceof XmlElement) {
            return this.processXmlElement((XmlElement)javaAttribute, oldProperty, typeInfo, nsInfo);
        }
        if (javaAttribute instanceof XmlElements) {
            return this.processXmlElements((XmlElements)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElementRef) {
            return this.processXmlElementRef((XmlElementRef)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElementRefs) {
            return this.processXmlElementRefs((XmlElementRefs)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlTransient) {
            return this.processXmlTransient((XmlTransient)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlValue) {
            return this.processXmlValue((XmlValue)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlJavaTypeAdapter) {
            return this.processXmlJavaTypeAdapter((XmlJavaTypeAdapter)javaAttribute, oldProperty);
        }
        this.getLogger().logWarning("jaxb_metadata_warning_invalid_java_attribute", new Object[]{javaAttribute.getClass()});
        return null;
    }

    private Property processXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlAdapter, Property oldProperty) {
        oldProperty.setXmlJavaTypeAdapter(xmlAdapter);
        return oldProperty;
    }

    private Property processXmlAnyAttribute(XmlAnyAttribute xmlAnyAttribute, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlAnyElement(XmlAnyElement xmlAnyElement, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        if (oldProperty.isAny()) {
            AnyProperty anyProp = (AnyProperty)oldProperty;
            anyProp.setDomHandlerClassName(xmlAnyElement.getDomHandler());
            anyProp.setLax(xmlAnyElement.isLax());
            tInfo.setMixed(xmlAnyElement.isXmlMixed());
            anyProp.setMixedContent(xmlAnyElement.isXmlMixed());
            if (xmlAnyElement.getXmlJavaTypeAdapter() != null) {
                anyProp.setXmlJavaTypeAdapter(xmlAnyElement.getXmlJavaTypeAdapter());
            } else if (oldProperty.isSetXmlJavaTypeAdapter()) {
                anyProp.setXmlJavaTypeAdapter(null);
            }
            return anyProp;
        }
        if (tInfo.isSetAnyElementPropertyName()) {
            throw JAXBException.xmlAnyElementAlreadySet(oldProperty.getPropertyName(), tInfo.getAnyElementPropertyName(), javaType.getName());
        }
        AnyProperty anyProp = new AnyProperty(this.aProcessor.getHelper());
        anyProp.setPropertyName(oldProperty.getPropertyName());
        anyProp.setElement(oldProperty.getElement());
        anyProp.setType(oldProperty.getType());
        anyProp.setSchemaName(oldProperty.getSchemaName());
        anyProp.setDomHandlerClassName(xmlAnyElement.getDomHandler());
        anyProp.setLax(xmlAnyElement.isLax());
        tInfo.setMixed(xmlAnyElement.isXmlMixed());
        anyProp.setMixedContent(xmlAnyElement.isXmlMixed());
        if (xmlAnyElement.getXmlJavaTypeAdapter() != null) {
            anyProp.setXmlJavaTypeAdapter(xmlAnyElement.getXmlJavaTypeAdapter());
        }
        return anyProp;
    }

    private Property processXmlAttribute(XmlAttribute xmlAttribute, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (xmlAttribute.isXmlId()) {
            typeInfo.setIDProperty(oldProperty);
        } else if (oldProperty.isXmlId() && typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlId(xmlAttribute.isXmlId());
        oldProperty.setIsXmlIdRef(xmlAttribute.isXmlIdref());
        oldProperty.setIsAttribute(true);
        oldProperty.setIsRequired(xmlAttribute.isRequired());
        String name = xmlAttribute.getName();
        if (name.equals("##default")) {
            name = oldProperty.getPropertyName();
        }
        QName qName = xmlAttribute.getNamespace().equals("##default") ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(xmlAttribute.getNamespace(), name);
        oldProperty.setSchemaName(qName);
        if (xmlAttribute.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlAttribute.getXmlJavaTypeAdapter());
        }
        if (xmlAttribute.getXmlBidirectional() != null) {
            oldProperty.setBackpointerPropertyName(xmlAttribute.getXmlBidirectional().getTargetAttribute());
        }
        return oldProperty;
    }

    private Property processXmlElement(XmlElement xmlElement, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (xmlElement.isXmlId()) {
            typeInfo.setIDProperty(oldProperty);
        } else if (oldProperty.isXmlId() && typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlId(xmlElement.isXmlId());
        oldProperty.setIsXmlIdRef(xmlElement.isXmlIdref());
        oldProperty.setIsRequired(xmlElement.isRequired());
        oldProperty.setNillable(xmlElement.isNillable());
        if (xmlElement.getDefaultValue().equals("\u0000")) {
            oldProperty.setDefaultValue(null);
        } else {
            oldProperty.setDefaultValue(xmlElement.getDefaultValue());
        }
        String name = xmlElement.getName();
        if (name.equals("##default")) {
            name = oldProperty.getPropertyName();
        }
        QName qName = xmlElement.getNamespace().equals("##default") ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(xmlElement.getNamespace(), name);
        oldProperty.setSchemaName(qName);
        if (xmlElement.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
            if (oldProperty.isXmlElementType()) {
                oldProperty.setType(oldProperty.getOriginalType());
            }
        } else {
            oldProperty.setType(this.jModelInput.getJavaModel().getClass(xmlElement.getType()));
        }
        if (xmlElement.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlElement.getXmlJavaTypeAdapter());
        }
        if (xmlElement.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElement.getXmlElementWrapper());
        }
        if (!oldProperty.isRequired()) {
            JavaClass ptype = oldProperty.getActualType();
            oldProperty.setIsRequired(ptype.isPrimitive() || ptype.isArray() && ptype.getComponentType().isPrimitive());
        }
        if (xmlElement.isSetXmlList()) {
            if (!this.aProcessor.isCollectionType(oldProperty) && !oldProperty.getType().isArray()) {
                throw JAXBException.invalidList(oldProperty.getPropertyName());
            }
            oldProperty.setIsXmlList(xmlElement.isXmlList());
        }
        if (xmlElement.getXmlBidirectional() != null) {
            oldProperty.setBackpointerPropertyName(xmlElement.getXmlBidirectional().getTargetAttribute());
        }
        return oldProperty;
    }

    private Property processXmlElements(XmlElements xmlElements, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElementRef(XmlElementRef xmlElementRef, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElementRefs(XmlElementRefs xmlElementRefs, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlTransient(XmlTransient xmlTransient, Property oldProperty) {
        oldProperty.setTransient(true);
        return oldProperty;
    }

    private Property processXmlValue(XmlValue xmlValue, Property oldProperty, TypeInfo info, JavaType javaType) {
        if (info.getXmlValueProperty() != null && info.getXmlValueProperty() != oldProperty) {
            throw JAXBException.xmlValueAlreadySet(oldProperty.getPropertyName(), info.getXmlValueProperty().getPropertyName(), javaType.getName());
        }
        info.setXmlValueProperty(oldProperty);
        return oldProperty;
    }

    private NamespaceInfo processXmlSchema(XmlBindings xmlBindings, String packageName) {
        XmlSchema schema = xmlBindings.getXmlSchema();
        if (schema == null) {
            return null;
        }
        NamespaceInfo nsInfo = new NamespaceInfo();
        XmlNsForm form = schema.getAttributeFormDefault();
        nsInfo.setAttributeFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        form = schema.getElementFormDefault();
        nsInfo.setElementFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        nsInfo.setLocation(schema.getLocation() == null ? "##generate" : schema.getLocation());
        nsInfo.setNamespace(schema.getNamespace() == null ? "" : schema.getNamespace());
        NamespaceResolver nsr = new NamespaceResolver();
        for (XmlSchema.XmlNs xmlns : schema.getXmlNs()) {
            nsr.put(xmlns.getPrefix(), xmlns.getNamespaceUri());
        }
        nsInfo.setNamespaceResolver(nsr);
        return nsInfo;
    }

    private Map<String, ArrayList<JavaClass>> buildPackageToJavaClassMap() {
        HashMap<String, ArrayList<JavaClass>> theMap = new HashMap<String, ArrayList<JavaClass>>();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    classes.add(this.jModelInput.getJavaModel().getClass(javaType.getName()));
                }
            }
            theMap.put(packageName, classes);
        }
        for (JavaClass jClass : this.jModelInput.getJavaClasses()) {
            String pkg = jClass.getPackageName();
            ArrayList existingClasses = (ArrayList)theMap.get(pkg);
            if (existingClasses != null) {
                if (this.classExistsInArray(jClass, existingClasses)) continue;
                existingClasses.add(jClass);
                continue;
            }
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            classes.add(jClass);
            theMap.put(pkg, classes);
        }
        return theMap;
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    public boolean classExistsInArray(JavaClass theClass, ArrayList<JavaClass> existingClasses) {
        for (JavaClass jClass : existingClasses) {
            if (!this.areClassesEqual(jClass, theClass)) continue;
            return true;
        }
        return false;
    }

    private boolean areClassesEqual(JavaClass classA, JavaClass classB) {
        if (classA == classB) {
            return true;
        }
        if (!classA.getQualifiedName().equals(classB.getQualifiedName())) {
            return false;
        }
        if (classA.getActualTypeArguments() != null) {
            if (classB.getActualTypeArguments() == null) {
                return false;
            }
            if (classA.getActualTypeArguments().size() != classB.getActualTypeArguments().size()) {
                return false;
            }
            for (int i = 0; i < classA.getActualTypeArguments().size(); ++i) {
                JavaClass nestedClassB;
                JavaClass nestedClassA = (JavaClass)classA.getActualTypeArguments().toArray()[i];
                if (this.areClassesEqual(nestedClassA, nestedClassB = (JavaClass)classB.getActualTypeArguments().toArray()[i])) continue;
                return false;
            }
            return true;
        }
        return classB.getActualTypeArguments() == null;
    }
}

