/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextFactory {
    public static final String ECLIPSELINK_OXM_XML_KEY = "eclipselink-oxm-xml";
    private static final String METADATA_MODEL_PACKAGE = "org.eclipse.persistence.jaxb.xmlmodel";
    private static JAXBContext jaxbContext = null;

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0 && null == (loader = classesToBeBound[0].getClassLoader())) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        for (String key : xmlBindings.keySet()) {
            classesToBeBound = JAXBContextFactory.getXmlBindingsClasses(xmlBindings.get(key), classLoader, classesToBeBound);
        }
        JaxbClassLoader loader = new JaxbClassLoader(classLoader, classesToBeBound);
        classesToBeBound = JAXBContextFactory.updateClassesWithObjectFactory(classesToBeBound, loader);
        try {
            Generator generator = new Generator(new JavaModelInputImpl(classesToBeBound, (JavaModel)new JavaModelImpl(loader)), xmlBindings, classLoader);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, classesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContextFactory.createContext(contextPath, classLoader, null);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        Throwable sessionLoadingException = null;
        try {
            XMLContext xmlContext = new XMLContext(contextPath, classLoader);
            return new JAXBContext(xmlContext);
        }
        catch (ValidationException vex) {
            if (vex.getErrorCode() != 7095) {
                sessionLoadingException = vex;
            }
        }
        catch (SessionLoaderException ex) {
            sessionLoadingException = ex;
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        Map<String, XmlBindings> xmlBindingMap = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        classes = JAXBContextFactory.getXmlBindingsClassesFromMap(xmlBindingMap, classLoader, classes);
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreElements()) {
            InputStream jaxbIndex;
            String path = tokenizer.nextToken();
            try {
                Class<?> objectFactory = classLoader.loadClass(path + ".ObjectFactory");
                if (JAXBContextFactory.isJAXB2ObjectFactory(objectFactory)) {
                    classes.add(objectFactory);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                classLoader.loadClass(path + ".package-info");
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((jaxbIndex = classLoader.getResourceAsStream(path.replace('.', '/') + "/jaxb.index")) == null) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(jaxbIndex));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String className = path + "." + line.trim();
                    try {
                        classes.add(classLoader.loadClass(className));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception ex) {
            }
        }
        if (classes.size() == 0) {
            org.eclipse.persistence.exceptions.JAXBException jaxbException = org.eclipse.persistence.exceptions.JAXBException.noObjectFactoryOrJaxbIndexInPath((String)contextPath);
            if (sessionLoadingException != null) {
                jaxbException.setInternalException(sessionLoadingException);
            }
            throw new JAXBException((Throwable)jaxbException);
        }
        Class[] classArray = new Class[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            classArray[i] = classes.get(i);
        }
        return JAXBContextFactory.createContext(classArray, properties, classLoader, xmlBindingMap);
    }

    public static javax.xml.bind.JAXBContext createContext(Type[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        for (String key : xmlBindings.keySet()) {
            typesToBeBound = JAXBContextFactory.getXmlBindingsClasses(xmlBindings.get(key), classLoader, typesToBeBound);
        }
        JaxbClassLoader loader = new JaxbClassLoader(classLoader, typesToBeBound);
        typesToBeBound = JAXBContextFactory.updateTypesWithObjectFactory(typesToBeBound, loader);
        JavaModelInputImpl inputImpl = new JavaModelInputImpl(typesToBeBound, (JavaModel)new JavaModelImpl(loader));
        try {
            Generator generator = new Generator(inputImpl, inputImpl.getJavaClassToType(), xmlBindings, classLoader);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, typesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader, Map<String, XmlBindings> xmlBindings) throws JAXBException {
        JaxbClassLoader loader = new JaxbClassLoader(classLoader, classesToBeBound);
        try {
            Generator generator = new Generator(new JavaModelInputImpl(classesToBeBound, (JavaModel)new JavaModelImpl(loader)), xmlBindings, loader);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, classesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static javax.xml.bind.JAXBContext createContext(Generator generator, Map properties, ClassLoader classLoader, JaxbClassLoader loader, Type[] typesToBeBound) throws Exception {
        JAXBContext jaxbContext = null;
        XMLContext xmlContext = null;
        Project proj = generator.generateProject();
        ConversionManager conversionManager = null;
        if (classLoader != null) {
            conversionManager = new ConversionManager();
            conversionManager.setLoader((ClassLoader)loader);
        } else {
            conversionManager = ConversionManager.getDefaultManager();
        }
        proj.convertClassNamesToClasses(conversionManager.getLoader());
        for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
            if (descriptor.getJavaClass() != null) continue;
            descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
        }
        org.eclipse.persistence.internal.jaxb.SessionEventListener eventListener = new org.eclipse.persistence.internal.jaxb.SessionEventListener();
        eventListener.setShouldValidateInstantiationPolicy(false);
        SAXPlatform platform = new SAXPlatform();
        platform.getConversionManager().setLoader((ClassLoader)loader);
        xmlContext = new XMLContext(proj, (ClassLoader)loader, (SessionEventListener)eventListener);
        if (generator.getAnnotationsProcessor().getPackageToNamespaceMappings().size() > 1) {
            ((XMLLogin)xmlContext.getSession(0).getDatasourceLogin()).setEqualNamespaceResolvers(false);
        }
        jaxbContext = new JAXBContext(xmlContext, generator, typesToBeBound);
        return jaxbContext;
    }

    private static boolean isJAXB2ObjectFactory(Class objectFactoryClass) {
        try {
            Class xmlRegistry = PrivilegedAccessHelper.getClassForName((String)"javax.xml.bind.annotation.XmlRegistry");
            return objectFactoryClass.isAnnotationPresent(xmlRegistry);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static Map<String, XmlBindings> getXmlBindingsFromProperties(Map properties, ClassLoader classLoader) {
        HashMap<String, XmlBindings> bindings = new HashMap<String, XmlBindings>();
        if (properties != null) {
            Map metadataFiles = null;
            try {
                metadataFiles = (Map)properties.get(ECLIPSELINK_OXM_XML_KEY);
            }
            catch (ClassCastException x) {
                throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
            }
            if (metadataFiles != null) {
                Iterator keyIt = metadataFiles.keySet().iterator();
                while (keyIt.hasNext()) {
                    String key = null;
                    try {
                        key = (String)keyIt.next();
                    }
                    catch (ClassCastException cce) {
                        throw org.eclipse.persistence.exceptions.JAXBException.incorrectKeyParameterType();
                    }
                    if (key == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMapKey();
                    }
                    Source metadataSource = null;
                    try {
                        metadataSource = (Source)metadataFiles.get(key);
                    }
                    catch (ClassCastException cce) {
                        throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterType();
                    }
                    if (metadataSource == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource((String)key);
                    }
                    XmlBindings binding = JAXBContextFactory.getXmlBindings(metadataSource, classLoader);
                    if (binding == null) continue;
                    bindings.put(key, binding);
                }
            }
        }
        return bindings;
    }

    private static XmlBindings getXmlBindings(Source metadataSource, ClassLoader classLoader) {
        XmlBindings xmlBindings = null;
        if (jaxbContext == null) {
            try {
                jaxbContext = (JAXBContext)JAXBContextFactory.createContext(METADATA_MODEL_PACKAGE, classLoader);
            }
            catch (JAXBException e) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotCreateContextForXmlModel((Exception)((Object)e));
            }
            if (jaxbContext == null) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotCreateContextForXmlModel();
            }
        }
        try {
            JAXBUnmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            xmlBindings = (XmlBindings)unmarshaller.unmarshal(metadataSource);
        }
        catch (JAXBException jaxbEx) {
            throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)jaxbEx));
        }
        return xmlBindings;
    }

    private static Type[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, Type[] existingTypes) {
        Type[] additionalTypes = existingTypes;
        ArrayList<Class> javaTypeClasses = new ArrayList<Class>();
        XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
        if (jTypes != null) {
            for (JavaType javaType : jTypes.getJavaType()) {
                try {
                    javaTypeClasses.add(classLoader.loadClass(javaType.getName()));
                }
                catch (ClassNotFoundException e) {
                    throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                }
            }
        }
        if (javaTypeClasses.size() > 0) {
            for (Type type : existingTypes) {
                Class cls;
                if (!(type instanceof Class) || javaTypeClasses.contains(cls = (Class)type)) continue;
                javaTypeClasses.add(cls);
            }
            additionalTypes = javaTypeClasses.toArray(new Type[javaTypeClasses.size()]);
        }
        return additionalTypes;
    }

    private static Class[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, Class[] existingClasses) {
        Class[] additionalClasses = existingClasses;
        ArrayList<Class> javaTypeClasses = new ArrayList<Class>();
        XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
        if (jTypes != null) {
            for (JavaType javaType : jTypes.getJavaType()) {
                try {
                    javaTypeClasses.add(classLoader.loadClass(javaType.getName()));
                }
                catch (ClassNotFoundException e) {
                    throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                }
            }
        }
        if (javaTypeClasses.size() > 0) {
            for (Class cls : existingClasses) {
                if (javaTypeClasses.contains(cls)) continue;
                javaTypeClasses.add(cls);
            }
            additionalClasses = javaTypeClasses.toArray(new Class[javaTypeClasses.size()]);
        }
        return additionalClasses;
    }

    private static ArrayList<Class> getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, ArrayList<Class> existingClasses) {
        ArrayList<Class> additionalClasses = existingClasses;
        XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
        if (jTypes != null) {
            for (JavaType javaType : jTypes.getJavaType()) {
                try {
                    Class<?> jClass = classLoader.loadClass(javaType.getName());
                    if (additionalClasses.contains(jClass)) continue;
                    additionalClasses.add(jClass);
                }
                catch (ClassNotFoundException e) {
                    throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                }
            }
        }
        return additionalClasses;
    }

    private static ArrayList<Class> getXmlBindingsClassesFromMap(Map<String, XmlBindings> xmlBindingMap, ClassLoader classLoader, ArrayList<Class> existingClasses) {
        ArrayList<Class> additionalClasses = existingClasses;
        for (String packageName : xmlBindingMap.keySet()) {
            additionalClasses = JAXBContextFactory.getXmlBindingsClasses(xmlBindingMap.get(packageName), classLoader, additionalClasses);
        }
        return additionalClasses;
    }

    private static Class[] updateClassesWithObjectFactory(Class[] classes, ClassLoader loader) {
        ArrayList updatedClasses = new ArrayList();
        for (Class next : classes) {
            if (!updatedClasses.contains(next)) {
                updatedClasses.add(next);
            }
            if (next.getPackage() == null) continue;
            String packageName = next.getPackage().getName();
            try {
                Class<?> objectFactoryClass = loader.loadClass(packageName + ".ObjectFactory");
                if (updatedClasses.contains(objectFactoryClass)) continue;
                updatedClasses.add(objectFactoryClass);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return updatedClasses.toArray(new Class[updatedClasses.size()]);
    }

    private static Type[] updateTypesWithObjectFactory(Type[] types, ClassLoader loader) {
        ArrayList<Type> updatedTypes = new ArrayList<Type>();
        for (Type next : types) {
            if (!updatedTypes.contains(next)) {
                updatedTypes.add(next);
            }
            if (!(next instanceof Class) || ((Class)next).getPackage() == null) continue;
            String packageName = ((Class)next).getPackage().getName();
            try {
                Class<?> objectFactoryClass = loader.loadClass(packageName + ".ObjectFactory");
                if (updatedTypes.contains(objectFactoryClass)) continue;
                updatedTypes.add(objectFactoryClass);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return updatedTypes.toArray(new Type[updatedTypes.size()]);
    }
}

