/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceListener;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.mappings.BidirectionalPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLObjectReferenceMapping
extends AggregateMapping
implements XMLMapping {
    protected HashMap sourceToTargetKeyFieldAssociations = new HashMap();
    protected Vector sourceToTargetKeys = new Vector();
    private boolean isWriteOnly;
    private BidirectionalPolicy bidirectionalPolicy = new BidirectionalPolicy();

    public void addSourceToTargetKeyFieldAssociation(String srcXPath, String tgtXPath) {
        XMLField srcFld = new XMLField(srcXPath);
        this.sourceToTargetKeys.add(srcFld);
        this.sourceToTargetKeyFieldAssociations.put(srcFld, new XMLField(tgtXPath));
    }

    public Object buildFieldValue(Object targetObject, XMLField xmlFld, AbstractSession session) {
        if (targetObject == null || this.getReferenceClass() == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Vector pks = objectBuilder.extractPrimaryKeyFromObject(targetObject, session);
        int idx = descriptor.getPrimaryKeyFields().indexOf(this.getSourceToTargetKeyFieldAssociations().get(xmlFld));
        if (idx == -1) {
            return null;
        }
        return pks.get(idx);
    }

    public void buildReference(UnmarshalRecord record, XMLField xmlField, Object object, AbstractSession session) {
        ReferenceResolver resolver = ReferenceResolver.getInstance(session);
        if (resolver == null) {
            return;
        }
        Object srcObject = record.getCurrentObject();
        ClassDescriptor clsDescriptor = session.getClassDescriptor(this.getReferenceClass());
        Vector<String> pkFieldNames = clsDescriptor.getPrimaryKeyFieldNames();
        Reference reference = resolver.getReference(this, srcObject);
        if (reference == null) {
            Vector pks = new Vector();
            pks.setSize(pkFieldNames.size());
            reference = new Reference((XMLMapping)this, srcObject, this.getReferenceClass(), pks);
            resolver.addReference(reference);
            record.reference(reference);
        }
        XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlField);
        int idx = pkFieldNames.indexOf(tgtFld.getXPath());
        Vector primaryKeys = reference.getPrimaryKeys();
        Object value = session.getDatasourcePlatform().getConversionManager().convertObject(object, clsDescriptor.getTypedField(tgtFld).getType());
        if (value != null) {
            primaryKeys.setElementAt(value, idx);
        }
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemove(objectReferenced, uow, visitedObjects);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(objectReferenced, uow, visitedObjects);
        }
    }

    public Vector getFields() {
        return this.sourceToTargetKeys;
    }

    protected QName getSchemaType(XMLField xmlField, Object value, AbstractSession session) {
        QName schemaType = null;
        if (xmlField.isTypedTextField()) {
            schemaType = xmlField.getXMLType(value.getClass());
        } else {
            if (xmlField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xmlField, value, session);
            }
            if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        return schemaType;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xmlField, Object value, AbstractSession session) {
        ArrayList schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        for (int i = 0; i < schemaTypes.size(); ++i) {
            QName nextQName = (QName)xmlField.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                Class javaClass = xmlField.getJavaClass(nextQName);
                value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return schemaType;
    }

    public HashMap getSourceToTargetKeyFieldAssociations() {
        return this.sourceToTargetKeyFieldAssociations;
    }

    protected String getValueToWrite(QName schemaType, Object value, AbstractSession session) {
        return (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        super.initialize(session);
        ReferenceListener listener = new ReferenceListener();
        if (!session.getEventManager().getListeners().contains(listener)) {
            session.getEventManager().addListener(listener);
        }
        XMLDescriptor descriptor = (XMLDescriptor)this.getDescriptor();
        XMLDescriptor targetDescriptor = (XMLDescriptor)this.getReferenceDescriptor();
        for (int index = 0; index < this.sourceToTargetKeys.size(); ++index) {
            XMLField sourceField = (XMLField)this.sourceToTargetKeys.get(index);
            XMLField targetField = (XMLField)this.sourceToTargetKeyFieldAssociations.remove(sourceField);
            sourceField = (XMLField)descriptor.buildField(sourceField);
            this.sourceToTargetKeys.set(index, sourceField);
            targetField = (XMLField)targetDescriptor.buildField(targetField);
            this.sourceToTargetKeyFieldAssociations.put(sourceField, targetField);
        }
        if (null != this.getBidirectionalTargetAccessor()) {
            this.getBidirectionalTargetAccessor().initializeAttributes(this.referenceClass);
        }
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public boolean isXMLMapping() {
        return true;
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ClassDescriptor descriptor = sourceQuery.getSession().getClassDescriptor(this.getReferenceClass());
        Vector<String> pkFieldNames = descriptor.getPrimaryKeyFieldNames();
        Vector<Object> primaryKeys = new Vector<Object>();
        primaryKeys.setSize(pkFieldNames.size());
        for (XMLField keyFld : this.sourceToTargetKeys) {
            Object value;
            XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(keyFld);
            int idx = pkFieldNames.indexOf(tgtFld.getXPath());
            if (idx == -1 || (value = executionSession.getDatasourcePlatform().getConversionManager().convertObject(databaseRow.get(keyFld), descriptor.getTypedField(tgtFld).getType())) == null) continue;
            primaryKeys.setElementAt(value, idx);
        }
        ReferenceResolver resolver = ReferenceResolver.getInstance(sourceQuery.getSession());
        if (resolver != null) {
            resolver.addReference(new Reference((XMLMapping)this, targetObject, this.referenceClass, primaryKeys));
        }
        return null;
    }

    public void setField(DatabaseField field) {
    }

    public void setSourceToTargetKeyFieldAssociations(HashMap sourceToTargetKeyFieldAssociations) {
        this.sourceToTargetKeyFieldAssociations = sourceToTargetKeyFieldAssociations;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        Object targetObject = this.getAttributeValueFromObject(object);
        this.writeSingleValue(targetObject, object, (XMLRecord)row, session);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        for (XMLField xmlField : this.getFields()) {
            Object fieldValue = this.buildFieldValue(value, xmlField, session);
            if (fieldValue == null) continue;
            QName schemaType = this.getSchemaType(xmlField, fieldValue, session);
            String stringValue = this.getValueToWrite(schemaType, fieldValue, session);
            row.put(xmlField, (Object)stringValue);
        }
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public AttributeAccessor getBidirectionalTargetAccessor() {
        return this.bidirectionalPolicy.getBidirectionalTargetAccessor();
    }

    public void setBidirectionalTargetAccessor(AttributeAccessor anAttributeAccessor) {
        this.bidirectionalPolicy.setBidirectionalTargetAccessor(anAttributeAccessor);
    }

    public void setBidirectionalTargetAttributeName(String attributeName) {
        this.bidirectionalPolicy.setBidirectionalTargetAttributeName(attributeName);
    }

    public String getBidirectionalTargetAttributeName() {
        return this.bidirectionalPolicy.getBidirectionalTargetAttributeName();
    }

    public void setBidirectionalTargetGetMethodName(String methodName) {
        this.bidirectionalPolicy.setBidirectionalTargetGetMethodName(methodName);
    }

    public void setBidirectionalTargetSetMethodName(String methodName) {
        this.bidirectionalPolicy.setBidirectionalTargetSetMethodName(methodName);
    }

    public String getBidirectionalTargetGetMethodName() {
        return this.bidirectionalPolicy.getBidirectionalTargetGetMethodName();
    }

    public String getBidirectionalTargetSetMethodName() {
        return this.bidirectionalPolicy.getBidirectionalTargetSetMethodName();
    }

    public ContainerPolicy getBidirectionalTargetContainerPolicy() {
        return this.bidirectionalPolicy.getBidirectionalTargetContainerPolicy();
    }

    public void setBidirectionalTargetContainerPolicy(ContainerPolicy cp) {
        this.bidirectionalPolicy.setBidirectionalTargetContainerPolicy(cp);
    }

    public void setBidirectionalTargetContainerClass(Class cls) {
        this.bidirectionalPolicy.setBidirectionalTargetContainerClass(cls);
    }

    public BidirectionalPolicy getBidirectionalPolicy() {
        return this.bidirectionalPolicy;
    }

    public void setBirdirectionalPolicy(BidirectionalPolicy policy) {
        this.bidirectionalPolicy = policy;
    }
}

