/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapContainerPolicy
extends InterfaceContainerPolicy {
    protected String keyName;
    protected String elementClassName;
    protected Class elementClass;
    protected transient Field keyField;
    protected transient Method keyMethod;

    public MapContainerPolicy() {
    }

    public MapContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public MapContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    @Override
    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (this.getElementClass() == null && query.getDescriptor() != null) {
            this.setElementClass(query.getDescriptor().getJavaClass());
        }
        super.prepare(query, session);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord dbRow, ObjectBuildingQuery query) {
        return this.addInto(null, element, container, session);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session) {
        if (element instanceof Map.Entry) {
            return this.addInto(((Map.Entry)element).getKey(), ((Map.Entry)element).getValue(), container, session);
        }
        return super.addInto(element, container, session);
    }

    @Override
    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object wrapped = element;
        if (this.hasElementDescriptor()) {
            wrapped = this.getElementDescriptor().getObjectBuilder().wrapObject(element, session);
        }
        try {
            if (key != null) {
                return ((Map)container).put(key, wrapped) != null;
            }
            if (this.isKeyAvailableFromElement()) {
                Object keyFromElement = this.keyFrom(element, session);
                try {
                    Object result = ((Map)container).put(keyFromElement, wrapped);
                    return null != result;
                }
                catch (NullPointerException e) {
                    if (keyFromElement == null) {
                        throw QueryException.mapKeyIsNull(element, container);
                    }
                    throw e;
                }
            }
            throw QueryException.cannotAddElementWithoutKeyToMap(element);
        }
        catch (ClassCastException ex1) {
            throw QueryException.mapKeyNotComparable(key, container);
        }
    }

    @Override
    public void addNextValueFromIteratorInto(Object valuesIterator, Object parent, Object toCollection, CollectionMapping mapping, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Map.Entry entry = ((MapContainerPolicyIterator)valuesIterator).next();
        Object clonedKey = this.buildCloneForKey(entry.getKey(), parent, unitOfWork, isExisting);
        Object clonedValue = this.buildCloneForValue(entry.getValue(), parent, mapping, unitOfWork, isExisting);
        if (mapping.isCandidateForPrivateOwnedRemoval() && unitOfWork.shouldDiscoverNewObjects() && clonedValue != null && unitOfWork.isObjectNew(clonedValue)) {
            unitOfWork.addPrivateOwnedObject(mapping, clonedValue);
        }
        this.addInto(clonedKey, clonedValue, toCollection, unitOfWork);
    }

    @Override
    public Object buildCollectionEntry(Object objectAdded, ObjectChangeSet changeSet) {
        return new Association(changeSet.getNewKey(), objectAdded);
    }

    @Override
    public void buildChangeSetForNewObjectInCollection(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(((Map.Entry)object).getValue(), uowChangeSet, session);
        Object key = ((Map.Entry)object).getKey();
        changeSet.setNewKey(key);
    }

    protected Object buildCloneForValue(Object value, Object parent, CollectionMapping mapping, UnitOfWorkImpl uow, boolean isExisting) {
        return mapping.buildElementClone(value, parent, uow, isExisting);
    }

    @Override
    public void clear(Object container) {
        try {
            ((Map)container).clear();
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    @Override
    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        if (((UnitOfWorkImpl)session).isClassReadOnly(sourceValue.getClass())) {
            return true;
        }
        Object backUpVersion = ((UnitOfWorkImpl)session).getBackupClone(sourceValue, this.getElementDescriptor());
        return this.keyFrom(backUpVersion, session).equals(this.keyFrom(sourceValue, session));
    }

    @Override
    protected boolean contains(Object element, Object container) {
        return ((Map)container).containsValue(element);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.elementClassName == null) {
            return;
        }
        try {
            Class elementClass = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    elementClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.elementClassName, true, classLoader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, exception.getException());
                }
            } else {
                elementClass = PrivilegedAccessHelper.getClassForName(this.elementClassName, true, classLoader);
            }
            this.setElementClass(elementClass);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, exc);
        }
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        return null;
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey(CollectionMapping baseMapping) {
        if (baseMapping == null) {
            return null;
        }
        ClassDescriptor descriptor = baseMapping.getReferenceDescriptor();
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(Helper.getAttributeNameFromMethodName(this.keyName));
        return mapping.getFields();
    }

    @Override
    public DatabaseField getDirectKeyField(CollectionMapping baseMapping) {
        if (baseMapping == null) {
            return null;
        }
        ClassDescriptor descriptor = baseMapping.getReferenceDescriptor();
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(Helper.getAttributeNameFromMethodName(this.keyName));
        if (mapping.isAbstractDirectMapping()) {
            return ((AbstractDirectMapping)mapping).getField();
        }
        return null;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    @Override
    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public Object getKeyType() {
        this.initializeKey();
        if (this.keyField != null) {
            return this.keyField.getType();
        }
        if (this.keyMethod != null) {
            return this.keyMethod.getReturnType();
        }
        return null;
    }

    @Override
    public boolean isMapPolicy() {
        return true;
    }

    protected boolean isKeyAvailableFromElement() {
        return true;
    }

    @Override
    public boolean isMapKeyAttribute() {
        DatabaseMapping mapping;
        if (this.elementDescriptor != null && (mapping = this.elementDescriptor.getMappingForAttributeName(Helper.getAttributeNameFromMethodName(this.keyName))) != null) {
            return mapping.isDirectToFieldMapping();
        }
        this.initializeKey();
        return this.keyField != null ? this.keyField.getClass().isPrimitive() : this.keyMethod != null && this.keyMethod.getClass().isPrimitive();
    }

    @Override
    public boolean hasNext(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).hasNext();
    }

    protected void initializeKey() {
        if (this.keyName != null && this.keyMethod == null && this.keyField == null) {
            try {
                this.keyMethod = Helper.getDeclaredMethod(this.elementClass, this.keyName, null);
            }
            catch (NoSuchMethodException ex) {
                try {
                    this.keyField = Helper.getField(this.elementClass, this.keyName);
                }
                catch (NoSuchFieldException e) {
                    throw ValidationException.mapKeyNotDeclaredInItemClass(this.keyName, this.elementClass);
                }
            }
        }
    }

    @Override
    public Object iteratorFor(Object container) {
        return new MapContainerPolicyIterator((Map)container);
    }

    @Override
    public Object keyFrom(Object element, AbstractSession session) {
        this.initializeKey();
        Object keyElement = element;
        if (this.hasElementDescriptor()) {
            keyElement = this.getElementDescriptor().getObjectBuilder().unwrapObject(element, session);
        }
        if (this.keyMethod != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.keyMethod, keyElement, null));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw QueryException.cannotAccessMethodOnObject(this.keyMethod, keyElement);
                        }
                        throw QueryException.calledMethodThrewException(this.keyMethod, keyElement, throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(this.keyMethod, keyElement, null);
            }
            catch (IllegalAccessException e) {
                throw QueryException.cannotAccessMethodOnObject(this.keyMethod, keyElement);
            }
            catch (InvocationTargetException exception) {
                throw QueryException.calledMethodThrewException(this.keyMethod, keyElement, exception);
            }
        }
        if (this.keyField != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.keyField, keyElement));
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.cannotAccessFieldOnObject(this.keyField, keyElement);
                    }
                }
                return PrivilegedAccessHelper.getValueFromField(this.keyField, keyElement);
            }
            catch (IllegalAccessException e) {
                throw QueryException.cannotAccessFieldOnObject(this.keyField, keyElement);
            }
        }
        return this.getElementDescriptor().getCMPPolicy().createPrimaryKeyInstance(keyElement, session);
    }

    @Override
    public Object keyFromEntry(Object entry) {
        if (entry instanceof Map.Entry) {
            return ((Map.Entry)entry).getKey();
        }
        return null;
    }

    @Override
    public Object keyFromIterator(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).getCurrentKey();
    }

    @Override
    protected Object next(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).next().getValue();
    }

    @Override
    public Object nextEntry(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).next();
    }

    @Override
    public Object nextEntry(Object iterator, AbstractSession session) {
        Map.Entry next = (Map.Entry)this.nextEntry(iterator);
        Object object = next.getValue();
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().unwrapObject(object, session);
        }
        Object key = next.getKey();
        key = this.unwrapKey(key, session);
        next = new Association(next.getKey(), object);
        return next;
    }

    @Override
    public Object unwrapElement(Object object) {
        if (object instanceof Association) {
            return ((Association)object).getValue();
        }
        return object;
    }

    @Override
    public Object unwrapIteratorResult(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getValue();
        }
        return object;
    }

    public Object unwrapKey(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, CollectionChangeRecord collectionChangeRecord) {
        Object key = null;
        if (event.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
            key = ((MapChangeEvent)event).getKey();
        }
        if (event.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(changeSet, collectionChangeRecord);
            changeSet.setNewKey(key);
        } else if (event.getChangeType() == MapChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(changeSet, collectionChangeRecord);
            changeSet.setOldKey(key);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
        }
    }

    @Override
    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        try {
            Object returnValue = null;
            if (key != null) {
                returnValue = ((Map)container).remove(key);
            } else if (element != null) {
                returnValue = ((Map)container).remove(this.keyFrom(element, session));
            }
            return returnValue != null;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object element, Object container, AbstractSession session) {
        boolean found = false;
        Vector knownKeys = new Vector(1);
        try {
            for (Object key : ((Map)container).keySet()) {
                if (((Map)container).get(key) != element) continue;
                knownKeys.addElement(key);
                found = true;
            }
            if (found) {
                for (int index = 0; index < knownKeys.size(); ++index) {
                    ((Map)container).remove(knownKeys.elementAt(index));
                }
            }
            return found;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public void setElementClass(Class elementClass) {
        if (elementClass != null) {
            this.elementClassName = elementClass.getName();
        }
        this.elementClass = elementClass;
    }

    @Override
    public boolean isValidContainer(Object container) {
        return container instanceof Map;
    }

    @Override
    public void setKeyName(String keyName, String elementClassName) {
        this.keyName = keyName;
        this.elementClassName = elementClassName;
    }

    @Override
    public void setKeyName(String keyName, Class elementClass) {
        this.keyName = keyName;
        this.elementClass = elementClass;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setKeyMethod(String keyMethodName, Class elementClass) {
        this.setKeyName(keyMethodName, elementClass);
    }

    public void setKeyMethod(String keyMethodName, String elementClassName) {
        this.setKeyName(keyMethodName, elementClassName);
    }

    public void setKeyMethodName(String keyMethodName) {
        this.setKeyName(keyMethodName);
    }

    @Override
    public int sizeFor(Object container) {
        return ((Map)container).size();
    }

    @Override
    public void validateElementAndRehashIfRequired(Object sourceValue, Object targetMap, AbstractSession session, Object targetVersionOfSource) {
        Object backupValue;
        if (session.isUnitOfWork() && !this.keyFrom(backupValue = ((UnitOfWorkImpl)session).getBackupClone(sourceValue, this.getElementDescriptor()), session).equals(this.keyFrom(sourceValue, session))) {
            this.removeFrom(backupValue, targetMap, session);
            this.addInto(targetVersionOfSource, targetMap, session);
        }
    }

    public Object valueFromIterator(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).getCurrentValue();
    }

    public static class MapContainerPolicyIterator
    implements Iterator {
        private Iterator iterator;
        private Map.Entry currentEntry;

        public MapContainerPolicyIterator(Map container) {
            this.iterator = container.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Map.Entry next() {
            this.currentEntry = (Map.Entry)this.iterator.next();
            return this.currentEntry;
        }

        public Object getCurrentKey() {
            if (this.currentEntry != null) {
                return this.currentEntry.getKey();
            }
            return null;
        }

        public Object getCurrentValue() {
            if (this.currentEntry != null) {
                return this.currentEntry.getValue();
            }
            return null;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

