/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jaxb.DefaultElementConverter;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementRootConverter;
import org.eclipse.persistence.internal.jaxb.JAXBSetMethodAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.MultiArgInstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.jaxb.many.JAXBObjectArrayAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.many.JAXBPrimitiveArrayAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.jaxb.many.MapValueAttributeAccessor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.SignatureAttribute;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLListConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private static final String ATT = "@";
    private static final String TXT = "/text()";
    private static String WRAPPER_CLASS = "org.eclipse.persistence.jaxb.generated";
    private static String OBJECT_CLASS_NAME = "java.lang.Object";
    public static final QName RESERVED_QNAME = new QName("urn:ECLIPSELINK_RESERVEDURI", "RESERVEDNAME");
    private static int wrapperCounter = 0;
    String outputDir = ".";
    private HashMap userDefinedSchemaTypes;
    private org.eclipse.persistence.jaxb.javamodel.Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<QName, Class> qNamesToGeneratedClasses;
    private HashMap<String, Class> classToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;
    private HashMap<QName, ElementDeclaration> globalElements;
    private Map<MapEntryGeneratedKey, Class> generatedMapEntryClasses;
    private Project project;
    private NamespaceResolver globalNamespaceResolver;

    public MappingsGenerator(org.eclipse.persistence.jaxb.javamodel.Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.qNamesToGeneratedClasses = new HashMap();
        this.qNamesToDeclaredClasses = new HashMap();
        this.classToGeneratedClasses = new HashMap();
        this.globalNamespaceResolver = new NamespaceResolver();
    }

    public Project generateProject(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap userDefinedSchemaTypes, HashMap<String, NamespaceInfo> packageToNamespaceMappings, HashMap<QName, ElementDeclaration> globalElements) throws Exception {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToNamespaceMappings = packageToNamespaceMappings;
        this.globalElements = globalElements;
        this.project = new Project();
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.generateDescriptor(next, this.project);
        }
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.setupInheritance(next);
        }
        this.generateMappings();
        Set<Map.Entry<String, TypeInfo>> entrySet = this.typeInfo.entrySet();
        for (Map.Entry<String, TypeInfo> entry : entrySet) {
            TypeInfo tInfo = entry.getValue();
            if (tInfo.getXmlCustomizer() == null) continue;
            String customizerClassName = tInfo.getXmlCustomizer();
            try {
                Class customizerClass = PrivilegedAccessHelper.getClassForName(customizerClassName);
                DescriptorCustomizer descriptorCustomizer = (DescriptorCustomizer)PrivilegedAccessHelper.newInstanceFromClass(customizerClass);
                descriptorCustomizer.customize(tInfo.getDescriptor());
            }
            catch (IllegalAccessException iae) {
                throw JAXBException.couldNotCreateCustomizerInstance(iae, customizerClassName);
            }
            catch (InstantiationException ie) {
                throw JAXBException.couldNotCreateCustomizerInstance(ie, customizerClassName);
            }
            catch (ClassCastException cce) {
                throw JAXBException.invalidCustomizerClass(cce, customizerClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw JAXBException.couldNotCreateCustomizerInstance(cnfe, customizerClassName);
            }
        }
        this.processGlobalElements(this.project);
        wrapperCounter = 0;
        return this.project;
    }

    public void generateDescriptor(JavaClass javaClass, Project project) {
        String namespace;
        String elementName;
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        if (info.isTransient()) {
            return;
        }
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
        String packageNamespace = namespaceInfo.getNamespace();
        if (javaClass.getSuperclass() != null && javaClass.getSuperclass().getName().equals("javax.xml.bind.JAXBElement")) {
            this.generateDescriptorForJAXBElementSubclass(javaClass, project, namespaceInfo.getNamespaceResolver());
            return;
        }
        XMLDescriptor descriptor = new XMLDescriptor();
        XmlRootElement rootElem = info.getXmlRootElement();
        if (rootElem == null) {
            elementName = Introspector.decapitalize(javaClass.getRawName().substring(jClassName.lastIndexOf(".") + 1));
            namespace = packageNamespace;
            descriptor.setResultAlwaysXMLRoot(true);
        } else {
            elementName = rootElem.getName();
            if (elementName.equals("##default")) {
                elementName = Introspector.decapitalize(javaClass.getRawName().substring(jClassName.lastIndexOf(".") + 1));
            }
            namespace = rootElem.getNamespace();
            descriptor.setResultAlwaysXMLRoot(false);
        }
        descriptor.setJavaClassName(jClassName);
        if (info.getFactoryMethodName() != null) {
            descriptor.getInstantiationPolicy().useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        }
        if (namespace.equals("##default")) {
            namespace = namespaceInfo.getNamespace();
        }
        if (rootElem == null) {
            descriptor.setDefaultRootElement("");
        } else if (namespace.length() == 0) {
            descriptor.setDefaultRootElement(elementName);
        } else {
            descriptor.setDefaultRootElement(this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver(), null) + ":" + elementName);
        }
        descriptor.setNamespaceResolver(namespaceInfo.getNamespaceResolver());
        this.setPKField(descriptor, info);
        this.setSchemaContext(descriptor, info);
        project.addDescriptor(descriptor);
        info.setDescriptor(descriptor);
    }

    public void generateDescriptorForJAXBElementSubclass(JavaClass javaClass, Project project, NamespaceResolver nsr) {
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        XMLDescriptor xmlDescriptor = new XMLDescriptor();
        xmlDescriptor.setJavaClassName(jClassName);
        String[] factoryMethodParamTypes = info.getFactoryMethodParamTypes();
        MultiArgInstantiationPolicy policy = new MultiArgInstantiationPolicy();
        policy.useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        policy.setParameterTypeNames(factoryMethodParamTypes);
        policy.setDefaultValues(new String[]{null});
        xmlDescriptor.setInstantiationPolicy(policy);
        JavaClass paramClass = this.helper.getJavaClass(factoryMethodParamTypes[0]);
        if (this.helper.isBuiltInJavaType(paramClass)) {
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath("text()");
            Class attributeClassification = Helper.getClassFromClasseName(factoryMethodParamTypes[0], this.getClass().getClassLoader());
            mapping.setAttributeClassification(attributeClassification);
            xmlDescriptor.addMapping(mapping);
        } else {
            XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath(".");
            mapping.setReferenceClassName(factoryMethodParamTypes[0]);
            xmlDescriptor.addMapping(mapping);
        }
        xmlDescriptor.setNamespaceResolver(nsr);
        this.setPKField(xmlDescriptor, info);
        this.setSchemaContext(xmlDescriptor, info);
        project.addDescriptor(xmlDescriptor);
        info.setDescriptor(xmlDescriptor);
    }

    private void setSchemaContext(XMLDescriptor desc, TypeInfo info) {
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        if (info.getClassNamespace() == null || info.getClassNamespace().equals("")) {
            schemaRef.setSchemaContext("/" + info.getSchemaTypeName());
        } else {
            String prefix = desc.getNonNullNamespaceResolver().resolveNamespaceURI(info.getClassNamespace());
            if (prefix != null && !prefix.equals("")) {
                schemaRef.setSchemaContext("/" + prefix + ":" + info.getSchemaTypeName());
            } else {
                String generatedPrefix = this.getPrefixForNamespace(info.getClassNamespace(), desc.getNonNullNamespaceResolver(), null);
                schemaRef.setSchemaContext("/" + generatedPrefix + ":" + info.getSchemaTypeName());
            }
            schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        }
        if (info.isEnumerationType() || info.getPropertyNames().size() == 1 && this.helper.isAnnotationPresent(info.getProperties().get(info.getPropertyNames().get(0)).getElement(), XmlValue.class)) {
            schemaRef.setType(2);
        }
        desc.setSchemaReference(schemaRef);
    }

    private void setPKField(XMLDescriptor desc, TypeInfo info) {
        if (info.isIDSet()) {
            String uri = info.getIDProperty().getSchemaName().getNamespaceURI();
            String local = info.getIDProperty().getSchemaName().getLocalPart();
            String prefix = null;
            if (uri != null && uri.length() != 0 && (prefix = desc.getNamespaceResolver().resolveNamespaceURI(uri)) == null) {
                prefix = this.getPrefixForNamespace(uri, desc.getNamespaceResolver(), null, true);
            }
            prefix = prefix == null ? "" : prefix + ":";
            String pkFieldName = info.getIDProperty().isAttribute() ? ATT + prefix + local : prefix + local + TXT;
            desc.addPrimaryKeyFieldName(pkFieldName);
        }
    }

    public void generateMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        if (property.isSetXmlJavaTypeAdapter()) {
            XmlJavaTypeAdapter xja = property.getXmlJavaTypeAdapter();
            JavaClass adapterClass = this.helper.getJavaClass(xja.getValue());
            JavaClass valueType = property.getActualType();
            if (this.typeInfo.containsKey(valueType.getQualifiedName())) {
                if (this.isCollectionType(property)) {
                    this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName()).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName()).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (this.isCollectionType(property)) {
                this.generateDirectCollectionMapping(property, descriptor, namespaceInfo).setValueConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, descriptor, namespaceInfo).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else {
                this.generateDirectMapping(property, descriptor, namespaceInfo).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            return;
        }
        if (property.isChoice()) {
            if (this.isCollectionType(property)) {
                this.generateChoiceCollectionMapping(property, descriptor, namespaceInfo);
            } else {
                this.generateChoiceMapping(property, descriptor, namespaceInfo);
            }
        } else if (property.isAny()) {
            if (this.isCollectionType(property)) {
                this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, property.isMixedContent());
            } else {
                this.generateAnyObjectMapping(property, descriptor, namespaceInfo);
            }
        } else if (property.isReference()) {
            this.generateMappingForReferenceProperty((ReferenceProperty)property, descriptor, namespaceInfo);
        } else if (this.isMapType(property)) {
            if (property.isAnyAttribute()) {
                this.generateAnyAttributeMapping(property, descriptor, namespaceInfo);
            } else {
                this.generateMapMapping(property, descriptor, namespaceInfo);
            }
        } else if (this.isCollectionType(property)) {
            this.generateCollectionMapping(property, descriptor, namespaceInfo);
        } else {
            JavaClass referenceClass = property.getType();
            String referenceClassName = referenceClass.getRawName();
            if (referenceClass.isArray() && !referenceClassName.equals("byte[]") && !referenceClassName.equals("java.lang.Byte[]")) {
                JavaClass componentType = referenceClass.getComponentType();
                TypeInfo reference = this.typeInfo.get(componentType.getQualifiedName());
                if (reference != null) {
                    this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, componentType.getQualifiedName());
                } else {
                    this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
                }
            } else {
                TypeInfo reference = this.typeInfo.get(referenceClass.getQualifiedName());
                if (reference != null) {
                    if (property.isXmlIdRef()) {
                        this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, referenceClass);
                    } else if (reference.isEnumerationType()) {
                        this.generateDirectEnumerationMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
                    } else {
                        this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass.getQualifiedName());
                    }
                } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                    this.generateBinaryMapping(property, descriptor, namespaceInfo);
                } else if (referenceClass.getQualifiedName().equals(OBJECT_CLASS_NAME)) {
                    XMLCompositeObjectMapping coMapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, null);
                    coMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                } else {
                    this.generateDirectMapping(property, descriptor, namespaceInfo);
                }
            }
        }
    }

    public XMLChoiceObjectMapping generateChoiceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        ChoiceProperty prop = (ChoiceProperty)property;
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        Iterator<Property> choiceProperties = prop.getChoiceProperties().iterator();
        while (choiceProperties.hasNext()) {
            Property next;
            JavaClass type = (next = choiceProperties.next()).getType();
            XMLField xpath = this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName(), false);
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLChoiceCollectionMapping generateChoiceCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        JavaClass collectionType;
        ChoiceProperty prop = (ChoiceProperty)property;
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        mapping.setReuseContainer(true);
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (this.areEquals(collectionType = property.getType(), Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        Iterator<Property> choiceProperties = prop.getChoiceProperties().iterator();
        while (choiceProperties.hasNext()) {
            Property next;
            JavaClass type = (next = choiceProperties.next()).getType();
            XMLField xpath = this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName());
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLMapping generateMappingForReferenceProperty(ReferenceProperty property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        DatabaseMapping mapping;
        boolean isCollection;
        if (property.isMixedContent()) {
            XMLAnyCollectionMapping mapping2 = this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
            return mapping2;
        }
        boolean bl = isCollection = this.isCollectionType(property) || property.getType().isArray();
        if (isCollection) {
            mapping = new XMLChoiceCollectionMapping();
            ((XMLChoiceCollectionMapping)mapping).setReuseContainer(true);
            ((XMLChoiceCollectionMapping)mapping).setConverter(new JAXBElementRootConverter(Object.class));
        } else {
            mapping = new XMLChoiceObjectMapping();
            ((XMLChoiceObjectMapping)mapping).setConverter(new JAXBElementRootConverter(Object.class));
        }
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                ((XMLMapping)((Object)mapping)).setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        List<ElementDeclaration> referencedElements = property.getReferencedElements();
        if (property.getType().isArray()) {
            JAXBObjectArrayAttributeAccessor accessor = new JAXBObjectArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
            accessor.setComponentClassName(property.getType().getComponentType().getRawName());
            mapping.setAttributeAccessor(accessor);
        }
        for (ElementDeclaration element : referencedElements) {
            Converter originalConverter;
            DatabaseMapping nestedMapping;
            QName elementName = element.getElementName();
            boolean isText = !this.typeInfo.containsKey(element.getJavaTypeName()) && !element.getJavaTypeName().equals(OBJECT_CLASS_NAME);
            XMLField xmlField = this.getXPathForElement("", elementName, namespaceInfo, isText);
            if (this.helper.getXMLToJavaTypeMap().get(element.getJavaType().getRawName()) == XMLConstants.BASE_64_BINARY_QNAME) {
                xmlField.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (isCollection) {
                XMLChoiceCollectionMapping xmlChoiceCollectionMapping = (XMLChoiceCollectionMapping)mapping;
                xmlChoiceCollectionMapping.addChoiceElement(xmlField, element.getJavaTypeName());
                nestedMapping = (DatabaseMapping)((Object)xmlChoiceCollectionMapping.getChoiceElementMappings().get(xmlField));
                if (nestedMapping.isAbstractCompositeCollectionMapping()) {
                    ((XMLCompositeCollectionMapping)nestedMapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                }
                if (nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    ((XMLCompositeDirectCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByEmptyNode(false);
                }
                if (element.isList() && nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    XMLListConverter listConverter = new XMLListConverter();
                    listConverter.setObjectClassName(element.getJavaType().getQualifiedName());
                    ((XMLCompositeDirectCollectionMapping)nestedMapping).setValueConverter(listConverter);
                }
            } else {
                XMLChoiceObjectMapping xmlChoiceObjectMapping = (XMLChoiceObjectMapping)mapping;
                xmlChoiceObjectMapping.addChoiceElement(xmlField, element.getJavaTypeName());
                nestedMapping = (DatabaseMapping)((Object)xmlChoiceObjectMapping.getChoiceElementMappings().get(xmlField));
                if (nestedMapping.isAbstractCompositeObjectMapping()) {
                    ((XMLCompositeObjectMapping)nestedMapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                }
            }
            if (element.isXmlRootElement()) continue;
            Class<JAXBElement.GlobalScope> scopeClass = element.getScopeClass();
            if (scopeClass == XmlElementDecl.GLOBAL.class) {
                scopeClass = JAXBElement.GlobalScope.class;
            }
            Class declaredType = this.helper.getClassForJavaClass(element.getJavaType());
            JAXBElementConverter converter = new JAXBElementConverter(xmlField, declaredType, scopeClass);
            if (isCollection) {
                XMLChoiceCollectionMapping xmlChoiceCollectionMapping = (XMLChoiceCollectionMapping)mapping;
                originalConverter = xmlChoiceCollectionMapping.getConverter(xmlField);
                converter.setNestedConverter(originalConverter);
                xmlChoiceCollectionMapping.addConverter(xmlField, converter);
                continue;
            }
            XMLChoiceObjectMapping xmlChoiceObjectMapping = (XMLChoiceObjectMapping)mapping;
            originalConverter = xmlChoiceObjectMapping.getConverter(xmlField);
            converter.setNestedConverter(originalConverter);
            xmlChoiceObjectMapping.addConverter(xmlField, converter);
        }
        descriptor.addMapping(mapping);
        return (XMLMapping)((Object)mapping);
    }

    public XMLAnyCollectionMapping generateAnyCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, boolean isMixed) {
        boolean isLax = false;
        String domHandlerClassName = null;
        if (property.isAny()) {
            isLax = property.isLax();
            domHandlerClassName = property.getDomHandlerClassName();
        }
        XMLAnyCollectionMapping mapping = new XMLAnyCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (!isMixed) {
            mapping.setUseXMLRoot(true);
        }
        Class declaredType = this.helper.getClassForJavaClass(property.getActualType());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter(jaxbElementRootConverter);
        if (isLax) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (domHandlerClassName != null) {
            jaxbElementRootConverter.setNestedConverter(new DomHandlerConverter(domHandlerClassName));
        }
        descriptor.addMapping(mapping);
        mapping.setMixedContent(isMixed);
        if (isMixed) {
            mapping.setPreserveWhitespaceForMixedContent(true);
        }
        return mapping;
    }

    public XMLCompositeObjectMapping generateCompositeObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        mapping.setXPath(this.getXPathForField(property, namespaceInfo, false).getXPath());
        if (referenceClassName == null) {
            ((XMLField)mapping.getField()).setIsTypedTextField(true);
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            String defaultValue = property.getDefaultValue();
            if (null != defaultValue) {
                mapping.setConverter(new DefaultElementConverter(defaultValue));
            }
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.getBidirectionalPropertyName() != null) {
            mapping.setContainerAttributeName(property.getBidirectionalPropertyName());
            JavaClass backPointerPropertyType = null;
            JavaClass referenceClass = property.getActualType();
            if (property.getBidirectionalPropertyGetMethodName() != null && property.getBidirectionalPropertySetMethodName() != null && !property.getBidirectionalPropertyGetMethodName().equals("") && !property.getBidirectionalPropertySetMethodName().equals("")) {
                mapping.setContainerGetMethodName(property.getBidirectionalPropertySetMethodName());
                mapping.setContainerSetMethodName(property.getBidirectionalPropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getContainerGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getBidirectionalPropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getBidirectionalPolicy().setBidirectionalTargetContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLDirectMapping generateDirectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        mapping.setField(this.getXPathForField(property, namespaceInfo, true));
        mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
        if (property.getType().getRawName().equals("java.lang.String")) {
            mapping.setNullValue("");
        }
        if (!mapping.getXPath().equals("text()")) {
            ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.isXmlElementType()) {
            Class theClass = this.helper.getClassForJavaClass(property.getType());
            mapping.setAttributeClassification(theClass);
        }
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (property.getDefaultValue() != null) {
            mapping.setNullValue(property.getDefaultValue());
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLBinaryDataMapping generateBinaryMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField(this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class)) {
            mapping.setShouldInlineBinaryData(true);
        }
        mapping.setMimeTypePolicy(new FixedMimeTypePolicy(property.getMimeType()));
        descriptor.addMapping(mapping);
        return mapping;
    }

    public void generateDirectEnumerationMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setConverter(this.buildJAXBEnumTypeConverter(mapping, enumInfo));
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField(this.getXPathForField(property, namespaceInfo, true));
        descriptor.addMapping(mapping);
    }

    private JAXBEnumTypeConverter buildJAXBEnumTypeConverter(DatabaseMapping mapping, EnumTypeInfo enumInfo) {
        JAXBEnumTypeConverter converter = new JAXBEnumTypeConverter(mapping, enumInfo.getClassName(), false);
        List<Object> objects = enumInfo.getObjectValues();
        List<String> fieldValues = enumInfo.getFieldValues();
        for (int i = 0; i < objects.size(); ++i) {
            converter.addConversionValue(fieldValues.get(i), objects.get(i));
        }
        return converter;
    }

    public void generateCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass = property.getActualType();
        if (property.isMixedContent()) {
            this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
            return;
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            TypeInfo referenceInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (referenceInfo.isEnumerationType()) {
                this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)referenceInfo);
            } else if (property.isXmlIdRef()) {
                this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, javaClass);
            } else {
                this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, javaClass.getQualifiedName());
            }
        } else if (!property.isAttribute() && javaClass != null && javaClass.getQualifiedName().equals(OBJECT_CLASS_NAME)) {
            XMLCompositeCollectionMapping ccMapping = this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, null);
            ccMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        }
    }

    public void generateEnumCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo info) {
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setValueConverter(this.buildJAXBEnumTypeConverter(mapping, info));
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        mapping.setField(this.getXPathForField(property, namespaceInfo, true));
        if (property.isXmlList()) {
            mapping.setUsesSingleNode(true);
        }
        descriptor.addMapping(mapping);
    }

    public void generateAnyAttributeMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping mapping = new XMLAnyAttributeMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setSchemaInstanceIncluded(false);
        mapping.setNamespaceDeclarationIncluded(false);
        descriptor.addMapping(mapping);
    }

    public void generateAnyObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyObjectMapping mapping = new XMLAnyObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setMixedContent(false);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.getType().getQualifiedName().equals("org.w3c.dom.Element")) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        }
        mapping.setUseXMLRoot(true);
        Class declaredType = this.helper.getClassForJavaClass(property.getActualType());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter(jaxbElementRootConverter);
        descriptor.addMapping(mapping);
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public XMLCompositeCollectionMapping generateMapMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        XMLField field = this.getXPathForField(property, namespaceInfo, false);
        JavaClass descriptorClass = this.helper.getJavaClass(descriptor.getJavaClassName());
        JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
        if (mapValueClass.isAssignableFrom(descriptorClass)) {
            mapping.setXPath("entry");
        } else {
            mapping.setXPath(field.getXPath() + "/entry");
        }
        Class generatedClass = this.generateMapEntryClassAndDescriptor(property.getType(), descriptor.getNonNullNamespaceResolver());
        mapping.setReferenceClass(generatedClass);
        String mapClassName = property.getType().getRawName();
        mapping.useCollectionClass(ArrayList.class);
        mapping.setAttributeAccessor(new MapValueAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), generatedClass, mapClassName));
        descriptor.addMapping(mapping);
        return mapping;
    }

    private Class generateMapEntryClassAndDescriptor(JavaClass type, NamespaceResolver nr) {
        Object[] types = type.getActualTypeArguments().toArray();
        if (types.length < 2) {
            return null;
        }
        JavaClass keyType = (JavaClass)types[0];
        JavaClass valueType = (JavaClass)types[1];
        String mapEntryClassName = WRAPPER_CLASS + wrapperCounter++;
        MapEntryGeneratedKey mapKey = new MapEntryGeneratedKey(keyType.getRawName(), valueType.getRawName());
        Class generatedClass = this.getGeneratedMapEntryClasses().get(mapKey);
        if (generatedClass == null) {
            generatedClass = this.generateMapEntryClass(mapEntryClassName, keyType.getRawName(), valueType.getRawName());
            this.getGeneratedMapEntryClasses().put(mapKey, generatedClass);
            XMLDescriptor desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            desc.addMapping(this.generateMappingForType(keyType, "key"));
            desc.addMapping(this.generateMappingForType(valueType, "value"));
            NamespaceResolver newNr = new NamespaceResolver();
            String prefix = this.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema-instance", nr, "xsi", false);
            newNr.put(prefix, "http://www.w3.org/2001/XMLSchema-instance");
            desc.setNamespaceResolver(newNr);
            this.project.addDescriptor(desc);
        }
        return generatedClass;
    }

    private Class generateMapEntryClass(String className, String keyType, String valueType) {
        ClassWriter cw = new ClassWriter(false);
        String qualifiedInternalClassName = className.replace('.', '/');
        String qualifiedInternalKeyClassName = keyType.replace('.', '/');
        String qualifiedInternalValueClassName = valueType.replace('.', '/');
        cw.visit(50, 33, qualifiedInternalClassName, "java/lang/Object", new String[]{"org/eclipse/persistence/internal/jaxb/many/MapEntry"}, className.substring(className.lastIndexOf(".")));
        cw.visitField(2, "key", "L" + qualifiedInternalKeyClassName + ";", null, null);
        cw.visitField(2, "value", "L" + qualifiedInternalValueClassName + ";", null, null);
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "getKey", "()L" + qualifiedInternalKeyClassName + ";", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "getValue", "()L" + qualifiedInternalValueClassName + ";", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "value", "L" + qualifiedInternalValueClassName + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "setValue", "(L" + qualifiedInternalValueClassName + ";)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "value", "L" + qualifiedInternalValueClassName + ";");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        if (!qualifiedInternalValueClassName.equals("java/lang/Object")) {
            cv = cw.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "getValue", "()L" + qualifiedInternalValueClassName + ";");
            cv.visitInsn(176);
            cv.visitMaxs(1, 1);
            cv = cw.visitMethod(4161, "setValue", "(Ljava/lang/Object;)V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitTypeInsn(192, qualifiedInternalValueClassName);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "setValue", "(L" + qualifiedInternalValueClassName + ";)V");
            cv.visitInsn(177);
            cv.visitMaxs(2, 2);
        }
        if (!qualifiedInternalKeyClassName.equals("java/lang/Object")) {
            cv = cw.visitMethod(4161, "getKey", "()Ljava/lang/Object;", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "getKey", "()L" + qualifiedInternalKeyClassName + ";");
            cv.visitInsn(176);
            cv.visitMaxs(1, 1);
            cv = cw.visitMethod(4161, "setKey", "(Ljava/lang/Object;)V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitTypeInsn(192, qualifiedInternalKeyClassName);
            cv.visitMethodInsn(182, qualifiedInternalClassName, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V");
            cv.visitInsn(177);
            cv.visitMaxs(2, 2);
        }
        SignatureAttribute attr = new SignatureAttribute("Ljava/lang/Object;Lorg/eclipse/persistence/internal/jaxb/many/MapEntry<L" + qualifiedInternalKeyClassName + ";L" + qualifiedInternalValueClassName + ";>;");
        cw.visitAttribute(attr);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    private DatabaseMapping generateMappingForType(JavaClass theType, String attributeName) {
        DatabaseMapping mapping;
        boolean typeIsObject = theType.getRawName().equals(OBJECT_CLASS_NAME);
        if (this.typeInfo.containsKey(theType.getQualifiedName()) || typeIsObject) {
            mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName(attributeName);
            ((XMLCompositeObjectMapping)mapping).setXPath(attributeName);
            if (typeIsObject) {
                ((XMLCompositeObjectMapping)mapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                ((XMLField)((XMLCompositeObjectMapping)mapping).getField()).setIsTypedTextField(true);
                ((XMLField)((XMLCompositeObjectMapping)mapping).getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            } else {
                ((XMLCompositeObjectMapping)mapping).setReferenceClassName(theType.getQualifiedName());
            }
        } else {
            mapping = new XMLDirectMapping();
            mapping.setAttributeName(attributeName);
            ((XMLDirectMapping)mapping).setXPath(attributeName + TXT);
            QName schemaType = (QName)this.userDefinedSchemaTypes.get(theType);
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(theType);
            }
            ((XMLField)((XMLDirectMapping)mapping).getField()).setSchemaType(schemaType);
        }
        return mapping;
    }

    public XMLCompositeCollectionMapping generateCompositeCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        JavaClass collectionType;
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBObjectArrayAttributeAccessor accessor = new JAXBObjectArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
            accessor.setComponentClassName(collectionType.getComponentType().getRawName());
            mapping.setAttributeAccessor(accessor);
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, false);
        mapping.setXPath(xmlField.getXPath());
        if (referenceClassName == null) {
            ((XMLField)mapping.getField()).setIsTypedTextField(true);
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.getBidirectionalPropertyName() != null) {
            mapping.setContainerAttributeName(property.getBidirectionalPropertyName());
            JavaClass backPointerPropertyType = null;
            JavaClass referenceClass = property.getActualType();
            if (property.getBidirectionalPropertyGetMethodName() != null && property.getBidirectionalPropertySetMethodName() != null && !property.getBidirectionalPropertyGetMethodName().equals("") && !property.getBidirectionalPropertySetMethodName().equals("")) {
                mapping.setContainerGetMethodName(property.getBidirectionalPropertySetMethodName());
                mapping.setContainerSetMethodName(property.getBidirectionalPropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getContainerGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getBidirectionalPropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getBidirectionalPolicy().setBidirectionalTargetContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLCompositeDirectCollectionMapping generateDirectCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass collectionType;
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if ((collectionType = property.getType()).isArray()) {
            String componentClassName;
            AttributeAccessor accessor;
            if (collectionType.getComponentType().isPrimitive()) {
                accessor = new JAXBPrimitiveArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
                componentClassName = collectionType.getComponentType().getRawName();
                Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(componentClassName);
                ((JAXBPrimitiveArrayAttributeAccessor)accessor).setComponentClass(primitiveClass);
                mapping.setAttributeAccessor(accessor);
                XMLConversionManager.getDefaultManager();
                Class declaredClass = ConversionManager.getObjectClass(primitiveClass);
                mapping.setAttributeElementClass(declaredClass);
            } else {
                accessor = new JAXBObjectArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy());
                componentClassName = collectionType.getComponentType().getRawName();
                ((JAXBObjectArrayAttributeAccessor)accessor).setComponentClassName(componentClassName);
                mapping.setAttributeAccessor(accessor);
                JavaClass componentType = collectionType.getComponentType();
                try {
                    Class declaredClass = PrivilegedAccessHelper.getClassForName(componentType.getRawName(), false, this.helper.getClassLoader());
                    mapping.setAttributeElementClass(declaredClass);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            collectionType = this.jotArrayList;
        } else if (collectionType != null && this.isCollectionType(collectionType) && collectionType.hasActualTypeArguments()) {
            JavaClass itemType = (JavaClass)collectionType.getActualTypeArguments().toArray()[0];
            try {
                Class declaredClass = PrivilegedAccessHelper.getClassForName(itemType.getRawName(), false, this.helper.getClassLoader());
                mapping.setAttributeElementClass(declaredClass);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, true);
        mapping.setField(xmlField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMixed.class)) {
            xmlField.setXPath("text()");
        }
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (property.getActualType() == null || property.getActualType().getRawName().equals("java.lang.String")) {
            mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.isXmlElementType() && property.getGenericType() != null) {
            Class theClass = this.helper.getClassForJavaClass(property.getGenericType());
            mapping.setAttributeElementClass(theClass);
        }
        if (xmlField.getXPathFragment().isAttribute()) {
            mapping.setUsesSingleNode(true);
        }
        if (property.isXmlList()) {
            mapping.setUsesSingleNode(true);
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver, String suggestedPrefix) {
        return this.getPrefixForNamespace(URI2, namespaceResolver, suggestedPrefix, true);
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver, String suggestedPrefix, boolean addPrefixToNR) {
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        String prefix = null;
        prefix = suggestedPrefix != null ? this.globalNamespaceResolver.generatePrefix(suggestedPrefix) : this.globalNamespaceResolver.generatePrefix();
        while (null != namespaceResolver.resolveNamespacePrefix(prefix)) {
            prefix = this.globalNamespaceResolver.generatePrefix();
        }
        if (addPrefixToNR) {
            namespaceResolver.put(prefix, URI2);
        }
        return prefix;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.isCollectionType(type);
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    private void setupInheritance(JavaClass jClass) {
        XMLDescriptor descriptor = this.typeInfo.get(jClass.getName()).getDescriptor();
        if (descriptor == null) {
            return;
        }
        JavaClass superClass = this.helper.getNextMappedSuperClass(jClass);
        if (superClass == null) {
            return;
        }
        TypeInfo superTypeInfo = this.typeInfo.get(superClass.getName());
        if (superTypeInfo == null) {
            return;
        }
        XMLDescriptor superDescriptor = superTypeInfo.getDescriptor();
        if (superDescriptor != null) {
            XMLSchemaReference rootSRef;
            String sCtx;
            XMLSchemaReference sRef = descriptor.getSchemaReference();
            if (sRef == null || sRef.getSchemaContext() == null) {
                return;
            }
            JavaClass rootMappedSuperClass = this.getRootMappedSuperClass(superClass);
            TypeInfo rootTypeInfo = this.typeInfo.get(rootMappedSuperClass.getName());
            XMLDescriptor rootDescriptor = rootTypeInfo.getDescriptor();
            if (rootDescriptor.getNamespaceResolver() == null) {
                rootDescriptor.setNamespaceResolver(new NamespaceResolver());
            }
            if (rootDescriptor.getInheritancePolicy().getClassIndicatorField() == null) {
                String prefix = this.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema-instance", rootDescriptor.getNamespaceResolver(), "xsi");
                XMLField classIndicatorField = new XMLField(ATT + prefix + ":type");
                rootDescriptor.getInheritancePolicy().setClassIndicatorField(classIndicatorField);
            }
            if ((sCtx = sRef.getSchemaContext()).length() > 1 && sCtx.startsWith("/")) {
                sCtx = sCtx.substring(1);
            }
            descriptor.getInheritancePolicy().setParentClassName(superClass.getName());
            rootDescriptor.getInheritancePolicy().addClassNameIndicator(jClass.getName(), sCtx);
            Object value = rootDescriptor.getInheritancePolicy().getClassNameIndicatorMapping().get(rootDescriptor.getJavaClassName());
            if (value == null && (rootSRef = rootDescriptor.getSchemaReference()) != null && rootSRef.getSchemaContext() != null) {
                String rootSCtx = rootSRef.getSchemaContext();
                if (rootSCtx.length() > 1 && rootSCtx.startsWith("/")) {
                    rootSCtx = rootSCtx.substring(1);
                }
                rootDescriptor.getInheritancePolicy().addClassNameIndicator(rootDescriptor.getJavaClassName(), rootSCtx);
            }
            rootDescriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        }
    }

    private JavaClass getRootMappedSuperClass(JavaClass javaClass) {
        JavaClass rootMappedSuperClass;
        JavaClass nextMappedSuperClass = rootMappedSuperClass = javaClass;
        while (nextMappedSuperClass != null) {
            if ((nextMappedSuperClass = this.helper.getNextMappedSuperClass(nextMappedSuperClass)) == null) {
                return rootMappedSuperClass;
            }
            rootMappedSuperClass = nextMappedSuperClass;
        }
        return rootMappedSuperClass;
    }

    public void generateMappings() {
        for (String next : this.typeInfo.keySet()) {
            XMLDescriptor descriptor;
            JavaClass javaClass = this.helper.getJavaClass(next);
            TypeInfo info = this.typeInfo.get(next);
            NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
            if (info.isEnumerationType() || (descriptor = info.getDescriptor()) == null) continue;
            this.generateMappings(info, descriptor, namespaceInfo);
        }
    }

    public void generateMappings(TypeInfo info, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        List<Property> propertiesInOrder = info.getNonTransientPropertiesInPropOrder();
        for (int i = 0; i < propertiesInOrder.size(); ++i) {
            Property next = propertiesInOrder.get(i);
            if (next == null) continue;
            this.generateMapping(next, descriptor, namespaceInfo);
        }
    }

    public void generateXMLCollectionReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLField srcXPath = this.getXPathForField(property, namespaceInfo, true);
        XMLCollectionReferenceMapping mapping = new XMLCollectionReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReuseContainer(true);
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
        if (referenceType.isIDSet()) {
            Property prop;
            XMLField tgtXPath = this.getXPathForField(prop, namespaceInfo, !this.helper.isAnnotationPresent((prop = referenceType.getIDProperty()).getElement(), XmlAttribute.class));
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath.getXPath());
        }
        if (property.getBidirectionalPropertyName() != null) {
            mapping.setBidirectionalTargetAttributeName(property.getBidirectionalPropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getBidirectionalPropertyGetMethodName() != null && property.getBidirectionalPropertySetMethodName() != null && !property.getBidirectionalPropertyGetMethodName().equals("") && !property.getBidirectionalPropertySetMethodName().equals("")) {
                mapping.setBidirectionalTargetGetMethodName(property.getBidirectionalPropertySetMethodName());
                mapping.setBidirectionalTargetSetMethodName(property.getBidirectionalPropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getBidirectionalTargetGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getBidirectionalPropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.setBidirectionalTargetContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        descriptor.addMapping(mapping);
    }

    public void generateXMLObjectReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLField srcXPath = this.getXPathForField(property, namespaceInfo, true);
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor(new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
        if (referenceType.isIDSet()) {
            Property prop;
            XMLField tgtXPath = this.getXPathForField(prop, namespaceInfo, !this.helper.isAnnotationPresent((prop = referenceType.getIDProperty()).getElement(), XmlAttribute.class));
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath.getXPath());
        }
        if (property.getBidirectionalPropertyName() != null) {
            mapping.setBidirectionalTargetAttributeName(property.getBidirectionalPropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getBidirectionalPropertyGetMethodName() != null && property.getBidirectionalPropertySetMethodName() != null && !property.getBidirectionalPropertyGetMethodName().equals("") && !property.getBidirectionalPropertySetMethodName().equals("")) {
                mapping.setBidirectionalTargetGetMethodName(property.getBidirectionalPropertySetMethodName());
                mapping.setBidirectionalTargetSetMethodName(property.getBidirectionalPropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getBidirectionalTargetGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getBidirectionalPropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.setBidirectionalTargetContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        descriptor.addMapping(mapping);
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean isTextMapping) {
        QName schemaType;
        String namespace;
        String xPath = "";
        XMLField xmlField = null;
        if (property.isSetXmlElementWrapper()) {
            XmlElementWrapper wrapper = property.getXmlElementWrapper();
            namespace = wrapper.getNamespace();
            if (namespace.equals("##default")) {
                namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            xPath = namespace.equals("") ? xPath + wrapper.getName() + "/" : xPath + this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver(), null) + ":" + wrapper.getName() + "/";
        }
        if (property.isAttribute()) {
            QName name = property.getSchemaName();
            namespace = "";
            if (namespaceInfo.isAttributeFormQualified()) {
                namespace = namespaceInfo.getNamespace();
            }
            if (!name.getNamespaceURI().equals("")) {
                namespace = name.getNamespaceURI();
            }
            if (namespace.equals("")) {
                xPath = xPath + ATT + name.getLocalPart();
            } else {
                String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver(), null);
                xPath = xPath + ATT + prefix + ":" + name.getLocalPart();
            }
            QName schemaType2 = (QName)this.userDefinedSchemaTypes.get(property.getClass());
            if (property.getSchemaType() != null) {
                schemaType2 = property.getSchemaType();
            }
            if (schemaType2 == null) {
                schemaType2 = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType().getRawName());
            }
            XMLField field = new XMLField(xPath);
            field.setSchemaType(schemaType2);
            return field;
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            xPath = "text()";
            XMLField field = new XMLField(xPath);
            schemaType = (QName)this.userDefinedSchemaTypes.get(property.getType());
            if (property.getSchemaType() != null) {
                schemaType = property.getSchemaType();
            }
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
            }
            field.setSchemaType(schemaType);
            return field;
        }
        QName elementName = property.getSchemaName();
        xmlField = this.getXPathForElement(xPath, elementName, namespaceInfo, isTextMapping);
        schemaType = (QName)this.userDefinedSchemaTypes.get(property.getType());
        if (property.getSchemaType() != null) {
            schemaType = property.getSchemaType();
        }
        if (schemaType == null) {
            JavaClass propertyType = property.getActualType();
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(propertyType.getRawName());
        }
        xmlField.setSchemaType(schemaType);
        return xmlField;
    }

    public XMLField getXPathForElement(String path, QName elementName, NamespaceInfo namespaceInfo, boolean isText) {
        String namespace = "";
        if (!elementName.getNamespaceURI().equals("")) {
            namespace = elementName.getNamespaceURI();
        }
        if (namespace.equals("")) {
            path = path + elementName.getLocalPart();
            if (isText) {
                path = path + TXT;
            }
        } else {
            String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver(), null);
            path = path + prefix + ":" + elementName.getLocalPart();
            if (isText) {
                path = path + TXT;
            }
        }
        XMLField xmlField = new XMLField(path);
        return xmlField;
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || prop.isAnyAttribute()) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public void processSchemaType(XmlSchemaType type) {
        String schemaTypeName = type.name();
        Class javaType = type.type();
        if (javaType == null) {
            return;
        }
        QName typeQName = new QName(type.namespace(), schemaTypeName);
        this.userDefinedSchemaTypes.put(javaType, typeQName);
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public boolean isMapType(Property property) {
        JavaClass mapCls = this.helper.getJavaClass(Map.class);
        return mapCls.isAssignableFrom(property.getType());
    }

    public void processGlobalElements(Project project) {
        if (this.globalElements == null) {
            return;
        }
        for (QName next : this.globalElements.keySet()) {
            ElementDeclaration nextElement = this.globalElements.get(next);
            String nextClassName = nextElement.getJavaTypeName();
            TypeInfo type = this.typeInfo.get(nextClassName);
            if (this.helper.isBuiltInJavaType(nextElement.getJavaType()) || type != null && type.isEnumerationType()) {
                String attributeTypeName = nextClassName;
                if (nextElement.getAdaptedJavaTypeName() != null) {
                    attributeTypeName = nextElement.getAdaptedJavaTypeName();
                }
                if (next == null && (this.areEquals(nextElement.getJavaType(), ClassConstants.ABYTE) || this.areEquals(nextElement.getJavaType(), ClassConstants.APBYTE) || this.areEquals(nextElement.getJavaType(), "javax.activation.DataHandler"))) {
                    this.addByteArrayWrapperAndDescriptor(type, nextElement.getJavaType().getRawName(), nextElement, nextClassName, attributeTypeName);
                    return;
                }
                Class generatedClass = this.generateWrapperClassAndDescriptor(type, next, nextElement, nextClassName, attributeTypeName);
                this.qNamesToGeneratedClasses.put(next, generatedClass);
                try {
                    Class declaredClass = PrivilegedAccessHelper.getClassForName(nextClassName, false, this.helper.getClassLoader());
                    this.qNamesToDeclaredClasses.put(next, declaredClass);
                }
                catch (Exception e) {}
                continue;
            }
            if (type == null || type.isTransient()) continue;
            if (next.getNamespaceURI() == null || next.getNamespaceURI().equals("")) {
                type.getDescriptor().addRootElement(next.getLocalPart());
                continue;
            }
            XMLDescriptor descriptor = type.getDescriptor();
            String uri = next.getNamespaceURI();
            String prefix = this.getPrefixForNamespace(uri, descriptor.getNamespaceResolver(), null);
            descriptor.addRootElement(prefix + ":" + next.getLocalPart());
        }
    }

    private Class addByteArrayWrapperAndDescriptor(TypeInfo type, String javaClassName, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class generatedClass = this.classToGeneratedClasses.get(javaClassName);
        if (generatedClass == null) {
            generatedClass = this.generateWrapperClassAndDescriptor(type, null, nextElement, nextClassName, attributeTypeName);
            this.classToGeneratedClasses.put(javaClassName, generatedClass);
        }
        return generatedClass;
    }

    private Class generateWrapperClassAndDescriptor(TypeInfo type, QName next, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class attributeClassification;
        DatabaseMapping mapping;
        String namespaceUri = null;
        if (next != null && ((namespaceUri = next.getNamespaceURI()) == null || namespaceUri.equals("##default"))) {
            namespaceUri = "";
        }
        Class generatedClass = this.generateWrapperClass(WRAPPER_CLASS + wrapperCounter++, attributeTypeName, nextElement.isList(), next);
        this.qNamesToGeneratedClasses.put(next, generatedClass);
        try {
            Class declaredClass = PrivilegedAccessHelper.getClassForName(nextClassName, false, this.helper.getClassLoader());
            this.qNamesToDeclaredClasses.put(next, declaredClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        XMLDescriptor desc = new XMLDescriptor();
        desc.setJavaClass(generatedClass);
        if (nextElement.isList()) {
            mapping = new XMLCompositeDirectCollectionMapping();
            mapping.setAttributeName("value");
            ((XMLCompositeDirectCollectionMapping)mapping).setXPath("text()");
            ((AbstractCompositeDirectCollectionMapping)mapping).setUsesSingleNode(true);
            ((XMLCompositeDirectCollectionMapping)mapping).setReuseContainer(true);
            if (type != null && type.isEnumerationType()) {
                ((AbstractCompositeDirectCollectionMapping)mapping).setValueConverter(this.buildJAXBEnumTypeConverter(mapping, (EnumTypeInfo)type));
            } else {
                try {
                    Class fieldElementClass = PrivilegedAccessHelper.getClassForName(nextClassName, false, this.helper.getClassLoader());
                    ((AbstractCompositeDirectCollectionMapping)mapping).setFieldElementClass(fieldElementClass);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                ((XMLField)((AbstractCompositeDirectCollectionMapping)mapping).getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                ((XMLField)((AbstractCompositeDirectCollectionMapping)mapping).getField()).setSchemaType(XMLConstants.QNAME_QNAME);
            }
            desc.addMapping(mapping);
        } else if (nextElement.getJavaTypeName().equals(OBJECT_CLASS_NAME)) {
            mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName("value");
            mapping.setSetMethodName("setValue");
            mapping.setGetMethodName("getValue");
            ((XMLCompositeObjectMapping)mapping).getNullPolicy().setNullRepresentedByXsiNil(true);
            ((XMLCompositeObjectMapping)mapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            ((XMLCompositeObjectMapping)mapping).setXPath(".");
            ((XMLField)((AbstractCompositeObjectMapping)mapping).getField()).setIsTypedTextField(true);
            ((XMLField)((AbstractCompositeObjectMapping)mapping).getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            desc.addMapping(mapping);
        } else if (this.areEquals(nextElement.getJavaType(), ClassConstants.ABYTE) || this.areEquals(nextElement.getJavaType(), ClassConstants.APBYTE) || this.areEquals(nextElement.getJavaType(), "javax.activation.DataHandler")) {
            mapping = new XMLBinaryDataMapping();
            mapping.setAttributeName("value");
            ((XMLBinaryDataMapping)mapping).setXPath(".");
            ((XMLField)((AbstractDirectMapping)mapping).getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            mapping.setSetMethodName("setValue");
            mapping.setGetMethodName("getValue");
            attributeClassification = Helper.getClassFromClasseName(attributeTypeName, this.getClass().getClassLoader());
            ((AbstractDirectMapping)mapping).setAttributeClassification(attributeClassification);
            if (this.areEquals(nextElement.getJavaType(), ClassConstants.ABYTE)) {
                ((XMLBinaryDataMapping)mapping).setShouldInlineBinaryData(true);
            } else if (this.areEquals(nextElement.getJavaType(), ClassConstants.APBYTE)) {
                ((XMLBinaryDataMapping)mapping).setShouldInlineBinaryData(true);
            } else {
                ((XMLBinaryDataMapping)mapping).setShouldInlineBinaryData(false);
            }
            desc.addMapping(mapping);
        } else {
            mapping = new XMLDirectMapping();
            mapping.setAttributeName("value");
            ((XMLDirectMapping)mapping).setXPath("text()");
            mapping.setSetMethodName("setValue");
            mapping.setGetMethodName("getValue");
            if (nextElement.getDefaultValue() != null) {
                ((AbstractDirectMapping)mapping).setNullValue(nextElement.getDefaultValue());
            }
            if (this.helper.isBuiltInJavaType(nextElement.getJavaType())) {
                attributeClassification = Helper.getClassFromClasseName(attributeTypeName, this.getClass().getClassLoader());
                ((AbstractDirectMapping)mapping).setAttributeClassification(attributeClassification);
            }
            IsSetNullPolicy nullPolicy = new IsSetNullPolicy("isSetValue", false, true, XMLNullRepresentationType.ABSENT_NODE);
            ((XMLDirectMapping)mapping).setNullPolicy(nullPolicy);
            if (type != null && type.isEnumerationType()) {
                ((AbstractDirectMapping)mapping).setConverter(this.buildJAXBEnumTypeConverter(mapping, (EnumTypeInfo)type));
            }
            if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                ((XMLField)((AbstractDirectMapping)mapping).getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                ((XMLField)((AbstractDirectMapping)mapping).getField()).setSchemaType(XMLConstants.QNAME_QNAME);
            }
            if (nextElement.getJavaTypeAdapterClass() != null) {
                ((AbstractDirectMapping)mapping).setConverter(new XMLJavaTypeConverter(nextElement.getJavaTypeAdapterClass()));
            }
            desc.addMapping(mapping);
        }
        if (next != null) {
            NamespaceResolver resolver;
            NamespaceInfo info = this.getNamespaceInfoForURI(namespaceUri);
            if (info != null) {
                resolver = info.getNamespaceResolver();
                String prefix = resolver.resolveNamespaceURI(namespaceUri);
                desc.setNamespaceResolver(resolver);
                desc.setDefaultRootElement("");
                desc.addRootElement(prefix + ":" + next.getLocalPart());
            } else if (namespaceUri.equals("")) {
                desc.setDefaultRootElement(next.getLocalPart());
            } else {
                resolver = new NamespaceResolver();
                String prefix = this.getPrefixForNamespace(namespaceUri, resolver, null);
                desc.setNamespaceResolver(resolver);
                desc.setDefaultRootElement("");
                desc.addRootElement(prefix + ":" + next.getLocalPart());
            }
        }
        this.project.addDescriptor(desc);
        return generatedClass;
    }

    private NamespaceInfo getNamespaceInfoForURI(String namespaceUri) {
        for (NamespaceInfo next : this.packageToNamespaceMappings.values()) {
            if (!next.getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    private String getPackageNameForURI(String namespaceUri) {
        for (String next : this.packageToNamespaceMappings.keySet()) {
            if (!this.packageToNamespaceMappings.get(next).getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    public Class generateWrapperClass(String className, String attributeType, boolean isList, QName theQName) {
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 1, className.replace(".", "/"), Type.getType(WrappedValue.class).getInternalName(), new String[0], null);
        String fieldType = null;
        if (isList) {
            fieldType = "Ljava/util/List;";
        } else {
            fieldType = attributeType.replace(".", "/");
            if (!fieldType.startsWith("[")) {
                fieldType = "L" + fieldType + ";";
            }
        }
        if (theQName == null) {
            theQName = RESERVED_QNAME;
        }
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "javax/xml/namespace/QName");
        cv.visitInsn(89);
        cv.visitLdcInsn(theQName.getNamespaceURI());
        cv.visitLdcInsn(theQName.getLocalPart());
        cv.visitMethodInsn(183, "javax/xml/namespace/QName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        cv.visitLdcInsn(Type.getType(fieldType));
        cv.visitInsn(1);
        cv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/WrappedValue", "<init>", "(Ljavax/xml/namespace/QName;Ljava/lang/Class;Ljava/lang/Object;)V");
        cv.visitInsn(177);
        cv.visitMaxs(5, 1);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    public HashMap<QName, Class> getQNamesToGeneratedClasses() {
        return this.qNamesToGeneratedClasses;
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.classToGeneratedClasses;
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    private Map<MapEntryGeneratedKey, Class> getGeneratedMapEntryClasses() {
        if (this.generatedMapEntryClasses == null) {
            this.generatedMapEntryClasses = new HashMap<MapEntryGeneratedKey, Class>();
        }
        return this.generatedMapEntryClasses;
    }

    private class MapEntryGeneratedKey {
        String keyClassName;
        String valueClassName;

        public MapEntryGeneratedKey(String keyClass, String valueClass) {
            this.keyClassName = keyClass;
            this.valueClassName = valueClass;
        }
    }
}

