/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWDescriptorLockingPolicy
extends MWModel
implements MWLockingPolicy {
    private volatile String lockingType;
    private volatile String optimisticVersionLockingType;
    public static final String OPTIMISTIC_VERSION_LOCKING_TYPE_PROPERTY = "optimisticVersionLockingType";
    public static final String OPTIMISTIC_VERSION_VERSION = "Version Locking";
    public static final String OPTIMISTIC_VERSION_TIMESTAMP = "Timestamp Locking";
    public static final String DEFAULT_OPTIMISTIC_VERSION_LOCKING_TYPE = "Version Locking";
    private volatile boolean storeInCache;
    private volatile boolean waitForLock;
    public static final String WAIT_FOR_LOCK_PROPERTY = "waitForLock";
    private volatile String retrieveTimeFrom;
    public static final String RETRIEVE_TIME_FROM_PROPERTY = "retrieveTimeFrom";
    public static final String SERVER_TIME = "Server";
    public static final String LOCAL_TIME = "Local";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.getInheritancePolicy();
        descriptor.setJavaClass(MWDescriptorLockingPolicy.class);
        ObjectTypeConverter lockingTypeConverter = new ObjectTypeConverter();
        lockingTypeConverter.addConversionValue((Object)"None", (Object)"None");
        lockingTypeConverter.addConversionValue((Object)"Optimistic Locking", (Object)"Optimistic Locking");
        lockingTypeConverter.addConversionValue((Object)"Pessimistic Locking", (Object)"Pessimistic Locking");
        XMLDirectMapping lockingTypeMapping = new XMLDirectMapping();
        lockingTypeMapping.setAttributeName("lockingType");
        lockingTypeMapping.setXPath("locking-type/text()");
        lockingTypeMapping.setNullValue((Object)"None");
        lockingTypeMapping.setConverter((Converter)lockingTypeConverter);
        descriptor.addMapping((DatabaseMapping)lockingTypeMapping);
        ObjectTypeConverter versionLockingTypeConverter = new ObjectTypeConverter();
        versionLockingTypeConverter.addConversionValue((Object)"Version Locking", (Object)"Version Locking");
        versionLockingTypeConverter.addConversionValue((Object)OPTIMISTIC_VERSION_TIMESTAMP, (Object)OPTIMISTIC_VERSION_TIMESTAMP);
        XMLDirectMapping versionLockingTypeMapping = new XMLDirectMapping();
        versionLockingTypeMapping.setAttributeName(OPTIMISTIC_VERSION_LOCKING_TYPE_PROPERTY);
        versionLockingTypeMapping.setXPath("version-locking-type/text()");
        versionLockingTypeMapping.setConverter((Converter)versionLockingTypeConverter);
        descriptor.addMapping((DatabaseMapping)versionLockingTypeMapping);
        ObjectTypeConverter retrieveTimeFromTypeConverter = new ObjectTypeConverter();
        retrieveTimeFromTypeConverter.addConversionValue((Object)SERVER_TIME, (Object)SERVER_TIME);
        retrieveTimeFromTypeConverter.addConversionValue((Object)LOCAL_TIME, (Object)LOCAL_TIME);
        XMLDirectMapping retrieveTimeFromMapping = new XMLDirectMapping();
        retrieveTimeFromMapping.setAttributeName(RETRIEVE_TIME_FROM_PROPERTY);
        retrieveTimeFromMapping.setXPath("retrieve-time-from/text()");
        retrieveTimeFromMapping.setConverter((Converter)retrieveTimeFromTypeConverter);
        retrieveTimeFromMapping.setNullValue((Object)SERVER_TIME);
        descriptor.addMapping((DatabaseMapping)retrieveTimeFromMapping);
        ((XMLDirectMapping)descriptor.addDirectMapping("storeInCache", "store-in-cache/text()")).setNullValue((Object)Boolean.TRUE);
        ((XMLDirectMapping)descriptor.addDirectMapping(WAIT_FOR_LOCK_PROPERTY, "wait-for-lock/text()")).setNullValue((Object)Boolean.TRUE);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWTableDescriptorLockingPolicy.class, (Object)"relational");
        ip.addClassIndicator(MWEisDescriptorLockingPolicy.class, (Object)"eis");
        ip.addClassIndicator(MWOXDescriptorLockingPolicy.class, (Object)"ox");
        return descriptor;
    }

    protected MWDescriptorLockingPolicy() {
    }

    public MWDescriptorLockingPolicy(MWTransactionalPolicy descriptor) {
        super(descriptor);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.lockingType = "None";
        this.storeInCache = true;
        this.waitForLock = true;
        this.retrieveTimeFrom = SERVER_TIME;
    }

    public String getLockingType() {
        return this.lockingType;
    }

    public void setLockingType(String newLockingType) {
        String oldLockingType = this.lockingType;
        this.lockingType = newLockingType;
        this.firePropertyChanged("lockingType", oldLockingType, newLockingType);
        if (this.attributeValueHasChanged(oldLockingType, this.lockingType)) {
            if (newLockingType != "Optimistic Locking") {
                this.setOptimisticVersionLockingType(null);
            } else {
                this.setOptimisticVersionLockingType("Version Locking");
            }
        }
    }

    public boolean shouldStoreVersionInCache() {
        return this.storeInCache;
    }

    public void setStoreInCache(boolean newStoreInCache) {
        boolean oldStoreInCache = this.storeInCache;
        this.storeInCache = newStoreInCache;
        this.firePropertyChanged("storeInCache", oldStoreInCache, newStoreInCache);
    }

    public boolean shouldWaitForLock() {
        return this.waitForLock;
    }

    public void setWaitForLock(boolean newValue) {
        boolean oldWaitForLock = this.waitForLock;
        this.waitForLock = newValue;
        this.firePropertyChanged(WAIT_FOR_LOCK_PROPERTY, oldWaitForLock, this.waitForLock);
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getLockingType());
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        if (this.getLockingType() == "Pessimistic Locking") {
            if (runtimeDescriptor.getCMPPolicy() == null) {
                runtimeDescriptor.setCMPPolicy(new CMPPolicy());
            }
            runtimeDescriptor.getCMPPolicy().setPessimisticLockingPolicy(new PessimisticLockingPolicy());
            if (this.shouldWaitForLock()) {
                runtimeDescriptor.getCMPPolicy().getPessimisticLockingPolicy().setLockingMode((short)1);
            } else {
                runtimeDescriptor.getCMPPolicy().getPessimisticLockingPolicy().setLockingMode((short)2);
            }
        }
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkLockFieldSpecifiedForLockingPolicy(problems);
        this.checkWriteLockFieldWritable(problems);
    }

    protected abstract void checkLockFieldSpecifiedForLockingPolicy(List var1);

    protected void checkWriteLockFieldWritable(List newProblems) {
        if (this.getLockingType() != "Optimistic Locking") {
            return;
        }
        if (this.shouldStoreVersionInCache()) {
            return;
        }
        ArrayList writtenFields = new ArrayList();
        Iterator mappings = this.getOwningDescriptor().mappingsIncludingInherited();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            if (mapping.isReadOnly()) continue;
            mapping.addWrittenFieldsTo(writtenFields);
            Iterator fields = writtenFields.iterator();
            while (fields.hasNext()) {
                if (fields.next() != this.getVersionLockField()) continue;
                return;
            }
            writtenFields.clear();
        }
        newProblems.add(this.buildProblem("0305"));
    }

    public String getOptimisticVersionLockingType() {
        return this.optimisticVersionLockingType;
    }

    public void setOptimisticVersionLockingType(String versionType) {
        String oldValue = this.optimisticVersionLockingType;
        this.optimisticVersionLockingType = versionType;
        this.firePropertyChanged(OPTIMISTIC_VERSION_LOCKING_TYPE_PROPERTY, oldValue, this.optimisticVersionLockingType);
    }

    public String getRetrieveTimeFrom() {
        return this.retrieveTimeFrom;
    }

    public boolean usesServerTime() {
        return this.retrieveTimeFrom == SERVER_TIME;
    }

    public boolean usesLocalTime() {
        return this.retrieveTimeFrom == LOCAL_TIME;
    }

    public void setRetrieveTimeFrom(String newValue) {
        String oldValue = this.retrieveTimeFrom;
        this.retrieveTimeFrom = newValue;
        this.firePropertyChanged(RETRIEVE_TIME_FROM_PROPERTY, oldValue, this.retrieveTimeFrom);
    }
}

