/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClass;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class InnerClassesAttribute
extends Attribute {
    private short count;
    private InnerClass[] innerClasses;

    InnerClassesAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        InnerClass[] classes = this.innerClasses = new InnerClass[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            classes[i] = new InnerClass(stream, this);
        }
    }

    void displayInfoStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        InnerClass[] classes = this.innerClasses;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            classes[i].displayStringOn(writer);
        }
    }

    public String nestedClassName(short index) {
        return this.innerClasses[index].innerClassInfoName();
    }

    public InnerClass innerClassNamed(String className) {
        short cnt = this.count;
        InnerClass[] classes = this.innerClasses;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            InnerClass innerClass = classes[i];
            if (!innerClass.isNamed(className)) continue;
            return innerClass;
        }
        return null;
    }

    private InnerClass innerClassNamed(short classNameIndex) {
        short cnt = this.count;
        InnerClass[] classes = this.innerClasses;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            InnerClass innerClass = classes[i];
            if (!innerClass.isNamed(classNameIndex)) continue;
            return innerClass;
        }
        return null;
    }

    private InnerClass thisInnerClassAttribute() {
        return this.innerClassNamed(this.classFile().getDeclaration().getThisClassIndex());
    }

    public boolean isTopLevelClass() {
        return !this.isNestedClass();
    }

    public boolean isNestedClass() {
        return this.thisInnerClassAttribute() != null;
    }

    public boolean isMemberClass() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass != null && innerClass.getOuterClassInfoIndex() != 0;
    }

    public boolean isLocalClass() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass != null && innerClass.getOuterClassInfoIndex() == 0 && innerClass.getInnerClassNameIndex() != 0;
    }

    public boolean isAnonymousClass() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass != null && innerClass.getOuterClassInfoIndex() == 0 && innerClass.getInnerClassNameIndex() == 0;
    }

    public String declaringClassName() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass == null ? null : innerClass.declaringClassName();
    }

    public String nestedClassName() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass == null ? null : innerClass.innerClassName();
    }

    public short nestedClassAccessFlags() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass == null ? (short)0 : innerClass.getInnerClassAccessFlags();
    }

    public String[] nestedClassNames() {
        short cnt = this.count;
        if (cnt == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] nestedClassNames = new String[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            nestedClassNames[i] = this.nestedClassName(i);
        }
        return nestedClassNames;
    }

    public String[] declaredMemberClassNames() {
        short cnt = this.count;
        if (cnt == 0) {
            return EMPTY_STRING_ARRAY;
        }
        InnerClass[] classes = this.innerClasses;
        ArrayList declaredMemberClassNames = new ArrayList(cnt);
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            classes[i].addDeclaredMemberClassTo(declaredMemberClassNames);
        }
        return declaredMemberClassNames.size() == 0 ? EMPTY_STRING_ARRAY : declaredMemberClassNames.toArray(new String[declaredMemberClassNames.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        InnerClass[] classes = this.innerClasses;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            classes[i].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    public InnerClass getInnerClass(short index) {
        return this.innerClasses[index];
    }

    void toString(StringBuffer sb) {
        sb.append(this.count);
        sb.append(" inner class(es)");
    }
}

