/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.util.Comparator;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public interface PartialStringMatcher {
    public StringHolderScore match(String var1, StringHolder[] var2);

    public static class SimpleStringHolderScore
    implements StringHolderScore {
        private final StringHolder stringHolder;
        private final double score;

        public SimpleStringHolderScore(StringHolder stringHolder, double score) {
            this.stringHolder = stringHolder;
            this.score = score;
        }

        public StringHolder getStringHolder() {
            return this.stringHolder;
        }

        public double getScore() {
            return this.score;
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String toString() {
            return StringTools.buildToStringFor(this, "\"" + this.stringHolder.getString() + "\" : " + this.score);
        }
    }

    public static interface StringHolderScore
    extends Comparable {
        public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                double score2;
                double score1 = ((StringHolderScore)o1).getScore();
                return score1 < (score2 = ((StringHolderScore)o2).getScore()) ? -1 : (score1 == score2 ? 0 : 1);
            }
        };

        public StringHolder getStringHolder();

        public double getScore();
    }
}

