/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.tools.workbench.uitools.ComponentVisibilityEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;

public final class ExpandablePane
extends JPanel {
    private Icon buttonCollapsedDisabledImage;
    private Icon buttonCollapsedFocusImage;
    private Icon buttonCollapsedImage;
    private Icon buttonCollapsedPressedImage;
    private String buttonCollapsedText;
    private Icon buttonExpandedDisabledImage;
    private Icon buttonExpandedFocusImage;
    private Icon buttonExpandedImage;
    private Icon buttonExpandedPressedImage;
    private String buttonExpandedText;
    private ChangeSupport changeSupport;
    private JToggleButton expandButton;
    private PropertyValueModel expandedHolder;
    String FAKE_FOCUS = "fakeFocus";

    public ExpandablePane(String buttonExpandedText, String buttonCollapsedText, Icon buttonExpandedImage, Icon buttonCollapsedImage, Icon buttonExpandedDisabledImage, Icon buttonCollapsedDisabledImage, Icon buttonExpandedFocusImage, Icon buttonCollapsedFocusImage, Icon buttonExpandedPressedImage, Icon buttonCollapsedPressedImage, JComponent internalPane, boolean expanded) {
        super(new GridBagLayout());
        this.initialize(buttonExpandedText, buttonCollapsedText, buttonExpandedImage, buttonCollapsedImage, buttonExpandedDisabledImage, buttonCollapsedDisabledImage, buttonExpandedFocusImage, buttonCollapsedFocusImage, buttonExpandedPressedImage, buttonCollapsedPressedImage, internalPane, expanded);
    }

    public ExpandablePane(String buttonExpandedText, String buttonCollapsedText, Icon buttonExpandedImage, Icon buttonCollapsedImage, JComponent internalPane, boolean expanded) {
        this(buttonExpandedText, buttonCollapsedText, buttonExpandedImage, buttonCollapsedImage, null, null, null, null, null, null, internalPane, true);
    }

    public ExpandablePane(String buttonExpandedText, String buttonCollapsedText, JComponent internalPane) {
        this(buttonExpandedText, buttonCollapsedText, null, null, null, null, null, null, null, null, internalPane, true);
    }

    public ExpandablePane(String buttonExpandedText, String buttonCollapsedText, JComponent internalPane, boolean expanded) {
        this(buttonExpandedText, buttonCollapsedText, null, null, internalPane, expanded);
    }

    public void addExpansionPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener("value", listener);
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpandablePane.this.expandedHolder.setValue((Boolean)ExpandablePane.this.expandedHolder.getValue() == false);
                ExpandablePane.this.updateExpandButtonText();
                ExpandablePane.this.updatePressedIcon();
                ExpandablePane.this.changeSupport.firePropertyChanged("value", (Boolean)ExpandablePane.this.expandedHolder.getValue() == false, ((Boolean)ExpandablePane.this.expandedHolder.getValue()).booleanValue());
            }
        };
    }

    private void initialize(String buttonExpandedText, String buttonCollapsedText, Icon buttonExpandedImage, Icon buttonCollapsedImage, Icon buttonExpandedDisabledImage, Icon buttonCollapsedDisabledImage, Icon buttonExpandedFocusImage, Icon buttonCollapsedFocusImage, Icon buttonExpandedPressedImage, Icon buttonCollapsedPressedImage, JComponent internalPane, boolean expanded) {
        if (internalPane == null) {
            throw new IllegalStateException("The internal panel cannot be null");
        }
        this.buttonExpandedText = buttonExpandedText;
        this.buttonCollapsedText = buttonCollapsedText;
        this.buttonExpandedImage = buttonExpandedImage;
        this.buttonCollapsedImage = buttonCollapsedImage;
        this.buttonExpandedDisabledImage = buttonExpandedDisabledImage;
        this.buttonCollapsedDisabledImage = buttonCollapsedDisabledImage;
        this.buttonExpandedFocusImage = buttonExpandedFocusImage;
        this.buttonCollapsedFocusImage = buttonCollapsedFocusImage;
        this.buttonExpandedPressedImage = buttonExpandedPressedImage;
        this.buttonCollapsedPressedImage = buttonCollapsedPressedImage;
        this.changeSupport = new ChangeSupport((Object)this);
        this.expandedHolder = new SimplePropertyValueModel(expanded);
        this.initializeLayout(internalPane);
        new ComponentVisibilityEnabler((ValueModel)this.expandedHolder, internalPane);
        this.setExpanded(expanded);
        this.setOpaque(false);
    }

    private void initializeLayout(JComponent internalPane) {
        GridBagConstraints constraints = new GridBagConstraints();
        boolean expanded = this.isExpanded();
        this.expandButton = new ToggleButton();
        this.expandButton.setBorderPainted(false);
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setCursor(Cursor.getPredefinedCursor(12));
        this.expandButton.setSelected(expanded);
        this.expandButton.addActionListener(this.buildActionListener());
        this.expandButton.putClientProperty(this.FAKE_FOCUS, false);
        Insets margin = this.expandButton.getInsets();
        margin.right = 4;
        margin.left = 4;
        this.expandButton.setMargin(margin);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.expandButton, constraints);
        this.updateExpandButtonIcon();
        this.updateExpandButtonText();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)internalPane, constraints);
    }

    public boolean isExpanded() {
        return (Boolean)this.expandedHolder.getValue();
    }

    public void removeExpansionPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener("value", listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.expandButton.setEnabled(enabled);
    }

    public void setExpanded(boolean expanded) {
        this.expandButton.setSelected(expanded);
    }

    private void updateExpandButtonIcon() {
        this.expandButton.setIcon(this.buttonExpandedImage);
        this.expandButton.setSelectedIcon(this.buttonCollapsedImage);
        this.expandButton.setPressedIcon(this.buttonExpandedPressedImage);
        this.expandButton.setDisabledIcon(this.buttonExpandedDisabledImage);
        this.expandButton.setDisabledSelectedIcon(this.buttonCollapsedDisabledImage);
        this.expandButton.setRolloverIcon(this.buttonExpandedFocusImage);
        this.expandButton.setRolloverSelectedIcon(this.buttonCollapsedFocusImage);
    }

    private void updateExpandButtonText() {
        this.expandButton.setText(this.isExpanded() ? this.buttonCollapsedText : this.buttonExpandedText);
    }

    private void updatePressedIcon() {
        if (this.expandButton.isSelected()) {
            this.expandButton.setPressedIcon(this.buttonCollapsedPressedImage);
        } else {
            this.expandButton.setPressedIcon(this.buttonExpandedPressedImage);
        }
    }

    private static class ToggleButton
    extends JToggleButton {
        private final Rectangle iconRect;
        private final Rectangle textRect;
        private final Rectangle viewRect = new Rectangle();

        ToggleButton() {
            this.textRect = new Rectangle();
            this.iconRect = new Rectangle();
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.isEnabled()) {
                this.paintUnderline(g);
            }
        }

        private void paintUnderline(Graphics graphics) {
            Insets insets = this.getInsets();
            this.viewRect.x = insets.left;
            this.viewRect.y = insets.top;
            this.viewRect.width = this.getWidth() - (insets.right + this.viewRect.x);
            this.viewRect.height = this.getHeight() - (insets.bottom + this.viewRect.y);
            this.textRect.height = 0;
            this.textRect.width = 0;
            this.textRect.y = 0;
            this.textRect.x = 0;
            this.iconRect.height = 0;
            this.iconRect.width = 0;
            this.iconRect.y = 0;
            this.iconRect.x = 0;
            SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.getText() == null ? 0 : this.getIconTextGap());
            graphics.setColor(this.getForeground());
            graphics.drawLine(this.textRect.x, this.textRect.y + this.textRect.height - 2, this.textRect.x + this.textRect.width, this.textRect.y + this.textRect.height - 2);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

