/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractRelationalReadQuery
extends MWAbstractReadQuery
implements MWRelationalReadQuery {
    private volatile CacheUsageModel cacheUsage;
    private static TopLinkOptionSet cacheUsageOptions;
    private volatile InMemoryQueryIndirectionPolicyModel inMemoryQueryIndirectionPolicy;
    private static TopLinkOptionSet inMemoryQueryIndirectionPolicyOptions;
    private volatile MWRelationalSpecificQueryOptions relationalOptions;
    private List joinedItems;
    public static final String JOINED_ITEMS_LIST = "joinedItems";

    public static synchronized TopLinkOptionSet cacheUsageOptions() {
        if (cacheUsageOptions == null) {
            ArrayList<CacheUsageModel> list = new ArrayList<CacheUsageModel>();
            list.add(new CacheUsageModel("Undefined", "UNDEFINED_CACHE_USAGE_OPTION", -1));
            list.add(new CacheUsageModel("Do Not Check Cache", "DO_NOT_CHECK_CACHE_OPTION", 0));
            list.add(new CacheUsageModel("Check Cache by Exact Primary Key", "CHECK_CACHE_BY_EXACT_PRIMARY_KEY_OPTION", 1));
            list.add(new CacheUsageModel("Check Cache by Primary Key", "CHECK_CACHE_BY_PRIMARY_KEY_OPTION", 2));
            list.add(new CacheUsageModel("Check Cache Then Database", "CHECK_CACHE_THEN_DATABASE_OPTION", 3));
            list.add(new CacheUsageModel("Check Cache Only", "CHECK_CACHE_ONLY_OPTION", 4));
            list.add(new CacheUsageModel("Conform Results in Unit of Work", "CONFORM_RESULTS_IN_UNIT_OF_WORK_OPTION", 5));
            cacheUsageOptions = new TopLinkOptionSet(list);
        }
        return cacheUsageOptions;
    }

    public static synchronized TopLinkOptionSet inMemoryQueryIndirectionPolicyOptions() {
        if (inMemoryQueryIndirectionPolicyOptions == null) {
            ArrayList<InMemoryQueryIndirectionPolicyModel> list = new ArrayList<InMemoryQueryIndirectionPolicyModel>();
            list.add(new InMemoryQueryIndirectionPolicyModel("Throw Indirection Exception", "THROW_INDIRECTION_EXCEPTION_OPTION", 0));
            list.add(new InMemoryQueryIndirectionPolicyModel("Trigger Indirection", "TRIGGER_INDIRECTION_OPTION", 1));
            list.add(new InMemoryQueryIndirectionPolicyModel("Ignore Exception Return Conformed", "IGNORE_EXCEPTION_RETURN_CONFORMED_OPTION", 2));
            list.add(new InMemoryQueryIndirectionPolicyModel("Ignore Exception Return Not Conformed", "IGNORE_EXCEPTION_RETURN_NOT_CONFORMED_OPTION", 3));
            inMemoryQueryIndirectionPolicyOptions = new TopLinkOptionSet(list);
        }
        return inMemoryQueryIndirectionPolicyOptions;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractRelationalReadQuery.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractReadQuery.class);
        XMLDirectMapping cacheUsage = new XMLDirectMapping();
        cacheUsage.setAttributeName("cacheUsage");
        cacheUsage.setXPath("cache-usage/text()");
        ObjectTypeConverter cacheUsageConverter = new ObjectTypeConverter();
        MWAbstractRelationalReadQuery.cacheUsageOptions().addConversionValuesForTopLinkTo(cacheUsageConverter);
        cacheUsage.setConverter((Converter)cacheUsageConverter);
        cacheUsage.setNullValue((Object)MWAbstractRelationalReadQuery.cacheUsageOptions().topLinkOptionForMWModelOption("Undefined"));
        descriptor.addMapping((DatabaseMapping)cacheUsage);
        XMLDirectMapping inMemoryQueryIndirectionPolicyMapping = new XMLDirectMapping();
        inMemoryQueryIndirectionPolicyMapping.setAttributeName("inMemoryQueryIndirectionPolicy");
        inMemoryQueryIndirectionPolicyMapping.setXPath("in-memory-query-indirection-policy/text()");
        ObjectTypeConverter inMemoryQueryIndirectionPolicyConverter = new ObjectTypeConverter();
        MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().addConversionValuesForTopLinkTo(inMemoryQueryIndirectionPolicyConverter);
        inMemoryQueryIndirectionPolicyMapping.setConverter((Converter)inMemoryQueryIndirectionPolicyConverter);
        inMemoryQueryIndirectionPolicyMapping.setNullValue((Object)MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().topLinkOptionForMWModelOption("Throw Indirection Exception"));
        descriptor.addMapping((DatabaseMapping)inMemoryQueryIndirectionPolicyMapping);
        XMLCompositeObjectMapping relationalOptionsMaping = new XMLCompositeObjectMapping();
        relationalOptionsMaping.setAttributeName("relationalOptions");
        relationalOptionsMaping.setReferenceClass(MWRelationalSpecificQueryOptions.class);
        relationalOptionsMaping.setXPath("relational-options");
        descriptor.addMapping((DatabaseMapping)relationalOptionsMaping);
        XMLCompositeCollectionMapping joinedItemsMapping = new XMLCompositeCollectionMapping();
        joinedItemsMapping.setAttributeName(JOINED_ITEMS_LIST);
        joinedItemsMapping.setReferenceClass(MWOrderingItem.class);
        joinedItemsMapping.setXPath("joins/joined-item");
        descriptor.addMapping((DatabaseMapping)joinedItemsMapping);
        return descriptor;
    }

    MWAbstractRelationalReadQuery() {
    }

    MWAbstractRelationalReadQuery(MWRelationalQueryManager queryManager, String name) {
        super(queryManager, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.inMemoryQueryIndirectionPolicy = (InMemoryQueryIndirectionPolicyModel)MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().topLinkOptionForMWModelOption("Throw Indirection Exception");
        this.joinedItems = new Vector();
        this.cacheUsage = (CacheUsageModel)MWAbstractRelationalReadQuery.cacheUsageOptions().topLinkOptionForMWModelOption("Undefined");
    }

    protected void initialize(String name) {
        super.initialize(name);
        this.relationalOptions = new MWRelationalSpecificQueryOptions(this);
        this.setDefaultQueryFormat();
    }

    private void setDefaultQueryFormat() {
        if (this.isTopLinkReservedFinder()) {
            this.relationalOptions.setQueryFormatToAutoGenerated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.relationalOptions);
        List list = this.joinedItems;
        synchronized (list) {
            children.addAll(this.joinedItems);
        }
    }

    public void initializeFrom(MWRelationalQuery query) {
        super.initializeFrom(query);
        this.getRelationalOptions().initializeFrom(query.getRelationalOptions());
    }

    public void initializeFrom(MWReadQuery query) {
        super.initializeFrom(query);
        this.initializeFrom((MWRelationalQuery)((Object)query));
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this.relationalOptions;
    }

    public CacheUsageModel getCacheUsage() {
        return this.cacheUsage;
    }

    private CacheUsageModel getCacheUsageFromTopLinkModelOption(int topLinkCacheUsage) {
        ListIterator cacheUsageModels = MWAbstractRelationalReadQuery.cacheUsageOptions().toplinkOptions();
        while (cacheUsageModels.hasNext()) {
            CacheUsageModel model = (CacheUsageModel)cacheUsageModels.next();
            if ((Integer)model.getTopLinkModelOption() != topLinkCacheUsage) continue;
            return model;
        }
        return null;
    }

    public void setCacheUsage(CacheUsageModel model) {
        CacheUsageModel oldCacheUsage = this.cacheUsage;
        this.cacheUsage = model;
        this.firePropertyChanged("cacheUsage", oldCacheUsage, this.cacheUsage);
    }

    public void setCacheUsage(String cacheUsage) {
        this.setCacheUsage((CacheUsageModel)MWAbstractRelationalReadQuery.cacheUsageOptions().topLinkOptionForMWModelOption(cacheUsage));
    }

    private void setCacheUsage(ObjectLevelReadQuery runtimeQuery) {
        this.setCacheUsage(this.getCacheUsageFromTopLinkModelOption(runtimeQuery.getCacheUsage()));
    }

    public InMemoryQueryIndirectionPolicyModel getInMemoryQueryIndirectionPolicy() {
        return this.inMemoryQueryIndirectionPolicy;
    }

    public void setInMemoryQueryIndirectionPolicy(InMemoryQueryIndirectionPolicyModel inMemoryQueryIndirectionPolicyModel) {
        InMemoryQueryIndirectionPolicyModel oldQueryPolicy = this.inMemoryQueryIndirectionPolicy;
        this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicyModel;
        this.firePropertyChanged("inMemoryQueryIndirectionPolicy", oldQueryPolicy, this.inMemoryQueryIndirectionPolicy);
    }

    public void setInMemoryQueryIndirectionPolicy(String inMemoryQueryIndirectionPolicyModel) {
        this.setInMemoryQueryIndirectionPolicy((InMemoryQueryIndirectionPolicyModel)MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().topLinkOptionForMWModelOption(inMemoryQueryIndirectionPolicyModel));
    }

    private void setInMemoryQueryIndirectionPolicy(ObjectLevelReadQuery runtimeQuery) {
        int inMemoryQueryIndirectionPolicy = runtimeQuery.getInMemoryQueryIndirectionPolicy().getPolicy();
        ListIterator inMemoryQueryIndirectionPolicyOptions = MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().toplinkOptions();
        while (inMemoryQueryIndirectionPolicyOptions.hasNext()) {
            InMemoryQueryIndirectionPolicyModel model = (InMemoryQueryIndirectionPolicyModel)inMemoryQueryIndirectionPolicyOptions.next();
            if ((Integer)model.getTopLinkModelOption() != inMemoryQueryIndirectionPolicy) continue;
            this.setInMemoryQueryIndirectionPolicy(model);
        }
    }

    public MWJoinedItem addJoinedItem(MWQueryable queryable) {
        if (queryable == null) {
            throw new NullPointerException();
        }
        MWJoinedItem item = new MWJoinedItem(this, queryable);
        this.addJoinedItem(item);
        return item;
    }

    public MWJoinedItem addJoinedItem(Iterator queryables) {
        MWJoinedItem item = new MWJoinedItem(this, queryables);
        this.addJoinedItem(item);
        return item;
    }

    public MWJoinedItem addJoinedItem(Iterator queryables, Iterator allowsNull) {
        MWJoinedItem item = new MWJoinedItem(this, queryables, allowsNull);
        this.addJoinedItem(item);
        return item;
    }

    public MWJoinedItem addJoinedItem(int index, Iterator queryables, Iterator allowsNull) {
        MWJoinedItem item = new MWJoinedItem(this, queryables, allowsNull);
        this.addJoinedItem(index, item);
        return item;
    }

    private void addJoinedItem(MWJoinedItem item) {
        this.addJoinedItem(this.joinedItemsSize(), item);
    }

    private void addJoinedItem(int index, MWJoinedItem item) {
        this.addItemToList(index, item, this.joinedItems, JOINED_ITEMS_LIST);
    }

    public void removeJoinedItem(MWJoinedItem joinedItem) {
        this.removeJoinedItem(this.joinedItems.indexOf(joinedItem));
    }

    public void removeJoinedItem(int index) {
        this.removeItemFromList(index, this.joinedItems, JOINED_ITEMS_LIST);
    }

    public ListIterator joinedItems() {
        return new CloneListIterator(this.joinedItems);
    }

    public int joinedItemsSize() {
        return this.joinedItems.size();
    }

    public int indexOfJoinedItem(MWJoinedItem item) {
        return this.joinedItems.indexOf(item);
    }

    public void moveJoinedItemUp(MWJoinedItem item) {
        int index = this.indexOfJoinedItem(item);
        this.removeJoinedItem(index);
        this.addJoinedItem(index - 1, item);
    }

    public void moveJoinedItemDown(MWJoinedItem item) {
        int index = this.indexOfJoinedItem(item);
        this.removeJoinedItem(index);
        this.addJoinedItem(index + 1, item);
    }

    public String getQueryFormatType() {
        return this.relationalOptions.getQueryFormatType();
    }

    public void setQueryFormatType(String type) {
        this.relationalOptions.setQueryFormatType(type);
    }

    public MWQueryFormat getQueryFormat() {
        return this.relationalOptions.getQueryFormat();
    }

    public TriStateBoolean isCacheStatement() {
        return this.relationalOptions.isCacheStatement();
    }

    public void setCacheStatement(TriStateBoolean cacheStatement) {
        this.relationalOptions.setCacheStatement(cacheStatement);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.relationalOptions.isBindAllParameters();
    }

    public void setBindAllParameters(TriStateBoolean bindAllParameters) {
        this.relationalOptions.setBindAllParameters(bindAllParameters);
    }

    public boolean isPrepare() {
        return this.relationalOptions.isPrepare();
    }

    public void setPrepare(boolean bindAllParameters) {
        this.relationalOptions.setPrepare(bindAllParameters);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.relationalOptions.notifyExpressionsToRecalculateQueryables();
    }

    public DatabaseQuery runtimeQuery() {
        ObjectLevelReadQuery runtimeQuery = (ObjectLevelReadQuery)super.runtimeQuery();
        this.getCacheUsage().setMWOptionOnTopLinkObject(runtimeQuery);
        this.getInMemoryQueryIndirectionPolicy().setMWOptionOnTopLinkObject(runtimeQuery);
        this.getRelationalOptions().adjustRuntimeQuery((DatabaseQuery)runtimeQuery);
        ListIterator i = this.joinedItems();
        while (i.hasNext()) {
            ((MWJoinedItem)i.next()).adjustRuntimeQuery(runtimeQuery);
        }
        return runtimeQuery;
    }

    public void adjustFromRuntime(ObjectLevelReadQuery runtimeQuery) {
        super.adjustFromRuntime(runtimeQuery);
        this.setCacheUsage(runtimeQuery);
        this.setInMemoryQueryIndirectionPolicy(runtimeQuery);
        this.getRelationalOptions().adjustFromRuntime((DatabaseQuery)runtimeQuery);
    }

    public static class InMemoryQueryIndirectionPolicyModel
    extends TopLinkOption {
        public InMemoryQueryIndirectionPolicyModel(String mwModelString, String externalString, int topLinkModelOption) {
            super(mwModelString, externalString, new Integer(topLinkModelOption));
        }

        public void setMWOptionOnTopLinkObject(Object query) {
            ((ObjectLevelReadQuery)query).getInMemoryQueryIndirectionPolicy().setPolicy(((Integer)this.getTopLinkModelOption()).intValue());
        }
    }

    public static class CacheUsageModel
    extends TopLinkOption {
        public CacheUsageModel(String mwModelString, String externalString, int topLinkModelOption) {
            super(mwModelString, externalString, new Integer(topLinkModelOption));
        }

        public void setMWOptionOnTopLinkObject(Object query) {
            ((ObjectLevelReadQuery)query).setCacheUsage(((Integer)this.getTopLinkModelOption()).intValue());
        }
    }
}

