/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdentifiableTypeImpl<X>
extends ManagedTypeImpl<X>
implements IdentifiableType<X> {
    protected IdentifiableType<? super X> superType;
    protected Set<SingularAttribute<? super X, ?>> idAttributes;
    protected SingularAttribute<? super X, ?> versionAttribute;

    protected IdentifiableTypeImpl(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        super(metamodel, descriptor);
    }

    protected void initializeIdAttributes() {
        this.idAttributes = new HashSet();
        for (Attribute attribute : this.getAttributes()) {
            if (((AttributeImpl)attribute).isPlural() || !((SingularAttribute)attribute).isId()) continue;
            this.idAttributes.add((SingularAttribute)attribute);
        }
    }

    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> type) {
        SingularAttribute<X, Y> anId = this.getId(type);
        return (SingularAttribute)this.getDeclaredAttribute(anId.getName(), true);
    }

    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> type) {
        SingularAttribute<X, Y> aVersion = this.getVersion(type);
        return (SingularAttribute)this.getDeclaredAttribute(aVersion.getName(), true);
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        List idClassNamesList = (List)this.getMetamodel().getProject().getMetamodelIdClassMap().get(this.getJavaType().getCanonicalName());
        if (!this.hasSingleIdAttribute() && null != idClassNamesList) {
            return this.idAttributes;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_identifiable_type_has_no_idclass_attribute", (Object[])new Object[]{this}));
    }

    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> type) {
        SingularAttribute<? super X, ?> idAttribute = null;
        if (!this.hasSingleIdAttribute()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_identifiable_id_attribute_is_incorrect_idclass", (Object[])new Object[]{this}));
        }
        for (SingularAttribute<? super X, ?> singularAttribute : this.idAttributes) {
            if (null == type || Object.class == type || type != null && type.getCanonicalName().equals(singularAttribute.getJavaType().getCanonicalName())) {
                idAttribute = singularAttribute;
                continue;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_identifiable_id_attribute_type_incorrect", (Object[])new Object[]{singularAttribute, this, type, singularAttribute.getJavaType()}));
        }
        return idAttribute;
    }

    public Type<?> getIdType() {
        CMPPolicy cmpPolicy = this.getDescriptor().getCMPPolicy();
        if (null == cmpPolicy) {
            List pkMappings = this.getDescriptor().getObjectBuilder().getPrimaryKeyMappings();
            if (pkMappings.isEmpty()) {
                for (DatabaseMapping aMapping : this.getDescriptor().getMappings()) {
                    Attribute anAttribute;
                    if (!aMapping.isJPAId() || (anAttribute = this.getAttribute(aMapping.getAttributeName())) == null) continue;
                    return this.getMetamodel().getType(anAttribute.getJavaType());
                }
            }
            if (pkMappings.size() == 1) {
                Class aClass = ((DatabaseMapping)pkMappings.get(0)).getAttributeClassification();
                return this.metamodel.getType(aClass);
            }
        }
        if (cmpPolicy.isCMP3Policy()) {
            return this.metamodel.getType(((CMP3Policy)cmpPolicy).getPKClass());
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_incompatible_persistence_config_for_getIdType", (Object[])new Object[]{this}));
    }

    public IdentifiableType<? super X> getSupertype() {
        return this.superType;
    }

    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> type) {
        if (null == this.getVersion()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_identifiable_no_version_attribute_present", (Object[])new Object[]{this}));
        }
        if (null == type || Object.class == type || type != null && type.getCanonicalName().equals(this.versionAttribute.getJavaType().getCanonicalName())) {
            return this.versionAttribute;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_identifiable_version_attribute_type_incorrect", (Object[])new Object[]{this.versionAttribute, this, type, this.versionAttribute.getJavaType()}));
    }

    private <Y> SingularAttribute<? super X, ?> getVersion() {
        if (this.hasVersionAttribute()) {
            return this.versionAttribute;
        }
        return null;
    }

    public boolean hasSingleIdAttribute() {
        List pkFields = this.getDescriptor().getPrimaryKeyFields();
        if (pkFields.isEmpty()) {
            return false;
        }
        Class pkClass = null;
        if (this.getDescriptor().hasCMPPolicy()) {
            pkClass = ((CMP3Policy)this.getDescriptor().getCMPPolicy()).getPKClass();
            if (null == pkClass) {
                return false;
            }
        } else {
            return pkFields.size() < 2;
        }
        List idClasses = (List)this.getMetamodel().getProject().getMetamodelIdClassMap().get(this.getJavaType().getCanonicalName());
        if (null != idClasses) {
            for (String idClass : idClasses) {
                if (!idClass.equalsIgnoreCase(pkClass.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasVersionAttribute() {
        if (null != this.versionAttribute) {
            return true;
        }
        for (Attribute attribute : this.getAttributes()) {
            if (((AttributeImpl)attribute).isPlural() || !((SingularAttribute)attribute).isVersion()) continue;
            this.versionAttribute = (SingularAttribute)attribute;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isIdentifiableType() {
        return true;
    }

    protected void setSupertype(IdentifiableType<? super X> superType) {
        this.superType = superType;
    }
}

