/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.MappingsGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private AnnotationsProcessor annotationsProcessor;
    private SchemaGenerator schemaGenerator;
    private MappingsGenerator mappingsGenerator;
    private Helper helper;

    public Generator(JavaModelInput jModelInput) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses());
    }

    public Generator(JavaModelInput jModelInput, Map<String, XmlBindings> xmlBindings, ClassLoader cLoader) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        if (xmlBindings != null && xmlBindings.size() > 0) {
            new XMLProcessor(xmlBindings).processXML(this.annotationsProcessor, jModelInput);
        } else {
            this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses());
        }
    }

    public Generator(JavaModelInput jModelInput, Map<JavaClass, Type> javaClassToType) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper, javaClassToType);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses());
    }

    public Generator(JavaModelInput jModelInput, Map<JavaClass, Type> javaClassToType, Map<String, XmlBindings> xmlBindings, ClassLoader cLoader) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper, javaClassToType);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        if (xmlBindings != null && xmlBindings.size() > 0) {
            new XMLProcessor(xmlBindings).processXML(this.annotationsProcessor, jModelInput);
        } else {
            this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses());
        }
    }

    public boolean hasMarshalCallbacks() {
        return this.getMarshalCallbacks() != null && this.getMarshalCallbacks().size() > 0;
    }

    public boolean hasUnmarshalCallbacks() {
        return this.getUnmarshalCallbacks() != null && this.getUnmarshalCallbacks().size() > 0;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        return this.annotationsProcessor.addClass(javaClass);
    }

    public Project generateProject() throws Exception {
        Project p = this.mappingsGenerator.generateProject(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements(), this.annotationsProcessor.isDefaultNamespaceAllowed());
        this.annotationsProcessor.getArrayClassesToGeneratedClasses().putAll(this.mappingsGenerator.getClassToGeneratedClasses());
        return p;
    }

    public Collection<Schema> generateSchema() {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), null);
        return this.schemaGenerator.getAllSchemas();
    }

    public HashMap<String, SchemaTypeInfo> generateSchemaFiles(String schemaPath, Map<QName, Type> additionalGlobalElements) throws FileNotFoundException {
        this.processAdditionalElements(additionalGlobalElements, this.annotationsProcessor);
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext((Project)proj);
        XMLMarshaller marshaller = context.createMarshaller();
        XMLDescriptor schemaDescriptor = (XMLDescriptor)proj.getDescriptor(Schema.class);
        Collection<Schema> schemas = this.schemaGenerator.getAllSchemas();
        int schemaCount = 0;
        for (Schema schema : schemas) {
            File file = new File(schemaPath + "/" + schema.getName());
            NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
            schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
            schemaDescriptor.setNamespaceResolver(schemaNamespaces);
            marshaller.marshal((Object)schema, (OutputStream)new FileOutputStream(file));
            ++schemaCount;
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    public HashMap<String, SchemaTypeInfo> generateSchemaFiles(SchemaOutputResolver outputResolver, Map<QName, Type> additionalGlobalElements) {
        this.processAdditionalElements(additionalGlobalElements, this.annotationsProcessor);
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext((Project)proj);
        XMLMarshaller marshaller = context.createMarshaller();
        XMLDescriptor schemaDescriptor = (XMLDescriptor)proj.getDescriptor(Schema.class);
        Collection<Schema> schemas = this.schemaGenerator.getAllSchemas();
        int schemaCount = 0;
        for (Schema schema : schemas) {
            try {
                NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
                schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
                schemaDescriptor.setNamespaceResolver(schemaNamespaces);
                Result target = outputResolver.createOutput(schema.getTargetNamespace(), schema.getName());
                marshaller.marshal((Object)schema, target);
                ++schemaCount;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    private void processAdditionalElements(Map<QName, Type> additionalGlobalElements, AnnotationsProcessor annotationsProcessor) {
        if (additionalGlobalElements != null) {
            for (QName key : additionalGlobalElements.keySet()) {
                Class tClass;
                Type type = additionalGlobalElements.get(key);
                JavaClass jClass = type instanceof Class ? ((tClass = (Class)type).isArray() ? this.helper.getJavaClass(annotationsProcessor.getArrayClassesToGeneratedClasses().get(tClass.getCanonicalName())) : this.helper.getJavaClass(tClass)) : this.helper.getJavaClass(annotationsProcessor.getCollectionClassesToGeneratedClasses().get(type));
                if (jClass == null) continue;
                ElementDeclaration declaration = new ElementDeclaration(key, jClass, jClass.getQualifiedName(), false);
                annotationsProcessor.getGlobalElements().put(key, declaration);
            }
        }
    }

    public HashMap getUnmarshalCallbacks() {
        return this.annotationsProcessor.getUnmarshalCallbacks();
    }

    public HashMap getMarshalCallbacks() {
        return this.annotationsProcessor.getMarshalCallbacks();
    }

    public MappingsGenerator getMappingsGenerator() {
        return this.mappingsGenerator;
    }

    public AnnotationsProcessor getAnnotationsProcessor() {
        return this.annotationsProcessor;
    }
}

