/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.xr.IndexInfo;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRDynamicEntity
implements DynamicEntity,
PersistenceEntity,
ChangeTracker,
FetchGroupTracker,
Cloneable {
    protected Map<String, IndexInfo> propertyNames2indexes = null;
    protected Object[] fields;
    protected CacheKey __cacheKey;
    protected Vector __pk;
    protected PropertyChangeListener __changeListener = null;
    protected FetchGroup __fetchGroup;
    protected boolean __refreshFetchGroup = false;
    protected Session __session;

    public XRDynamicEntity(Map<String, IndexInfo> propertyNames2indexes) {
        this.propertyNames2indexes = propertyNames2indexes;
        int maxIdx = -1;
        for (Map.Entry<String, IndexInfo> me : propertyNames2indexes.entrySet()) {
            int currIdx = me.getValue().index;
            if (maxIdx >= currIdx) continue;
            maxIdx = currIdx;
        }
        int size = maxIdx + 1;
        this.fields = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.fields[i] = EmptySlot.EMPTY_SLOT;
        }
    }

    public <T> T get(String propertyName) throws DynamicException {
        IndexInfo indexInfo = this.getIndexInfoFor(propertyName);
        if (indexInfo.index < 0) {
            throw DynamicException.invalidPropertyIndex((DynamicType)null, (int)indexInfo.index);
        }
        Object o = this.get(indexInfo.index);
        if (o == EmptySlot.EMPTY_SLOT) {
            if (indexInfo.derefVH) {
                this.fields[indexInfo.index] = new ValueHolder();
            }
            return null;
        }
        if (indexInfo.derefVH) {
            o = ((ValueHolderInterface)o).getValue();
        }
        return (T)o;
    }

    public boolean isSet(String propertyName) throws DynamicException {
        IndexInfo indexInfo = this.getIndexInfoFor(propertyName);
        Object o = this.fields[indexInfo.index];
        return o != EmptySlot.EMPTY_SLOT;
    }

    public DynamicEntity set(String propertyName, Object value) throws DynamicException {
        IndexInfo indexInfo = this.getIndexInfoFor(propertyName);
        if (indexInfo.index < 0) {
            throw DynamicException.invalidPropertyIndex((DynamicType)null, (int)indexInfo.index);
        }
        Object o = this.get(indexInfo.index);
        if (o == EmptySlot.EMPTY_SLOT) {
            this.fields[indexInfo.index] = indexInfo.derefVH ? new ValueHolder() : value;
        } else if (indexInfo.derefVH) {
            ((ValueHolderInterface)o).setValue(value);
        } else {
            this.fields[indexInfo.index] = value;
        }
        return this;
    }

    protected IndexInfo getIndexInfoFor(String propertyName) {
        IndexInfo indexInfo = this.propertyNames2indexes.get(propertyName);
        if (indexInfo == null) {
            throw DynamicException.invalidPropertyName((DynamicType)null, (String)propertyName);
        }
        return indexInfo;
    }

    public Object get(int i) {
        return this.fields[i];
    }

    public Object set(int i, Object aFieldValue) {
        this.fields[i] = aFieldValue;
        return this;
    }

    public CacheKey _persistence_getCacheKey() {
        return this.__cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this.__cacheKey = cacheKey;
    }

    public Vector _persistence_getPKVector() {
        return this.__pk;
    }

    public void _persistence_setPKVector(Vector pk) {
        this.__pk = pk;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.__changeListener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.__changeListener = listener;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this.__fetchGroup;
    }

    public Session _persistence_getSession() {
        return this.__session;
    }

    public boolean _persistence_isAttributeFetched(String attribute) {
        return this.__fetchGroup == null || this.__fetchGroup.containsAttribute(attribute);
    }

    public void _persistence_resetFetchGroup() {
        throw new UnsupportedOperationException("XRDynamicEntity._persistence_resetFetchGroup:: NOT SUPPORTED");
    }

    public void _persistence_setFetchGroup(FetchGroup group) {
        this.__fetchGroup = group;
    }

    public void _persistence_setSession(Session session) {
        this.__session = session;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean shouldRefreshFetchGroup) {
        this.__refreshFetchGroup = shouldRefreshFetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this.__refreshFetchGroup;
    }

    public Object clone() {
        XRDynamicEntity entity = null;
        try {
            entity = (XRDynamicEntity)super.clone();
        }
        catch (Exception error) {
            throw new Error(error);
        }
        entity.fields = (Object[])entity.fields.clone();
        return entity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append('{');
        sb.append(Helper.getShortClassName(this.getClass()));
        if (this.__pk != null) {
            for (int i = 0; i < this.__pk.size(); ++i) {
                sb.append(' ');
                sb.append(this.__pk.elementAt(i));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static class EmptySlot {
        static EmptySlot EMPTY_SLOT = new EmptySlot();

        EmptySlot() {
        }
    }
}

