/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     tware - initial implementation
 ******************************************************************************/  
package org.eclipse.persistence.testing.models.collections.map;

import java.util.*;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.testing.models.collections.map.AggregateEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;
import org.eclipse.persistence.testing.models.collections.map.DirectEntityMapHolder;

/**
 * TopLink generated Project class.
 * <b>WARNING</b>: This code was generated by an automated tool.
 * Any changes will be lost when the code is re-generated
 */
public class MapCollectionsProject extends org.eclipse.persistence.sessions.Project {

    /**
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    public MapCollectionsProject() {
        applyPROJECT();
        applyLOGIN();
        
        buildAggregateAggregateMapHolderDescriptor();
        buildAggregateDirectMapHolderDescriptor();
        buildAggregateEntityMapHolderDescriptor();
        buildAggregateEntity1MMapHolderDescriptor();
        buildAggregateEntityU1MMapHolderDescriptor();
        buildAggregateMapKeyDescriptor();
        buildAggregateMapValueDescriptor();
        
        buildDirectAggregateMapHolderDescriptor();
        buildDirectEntityMapHolderDescriptor();
        buildDirectEntity1MMapHolderDescriptor();
        buildDirectEntityU1MMapHolderDescriptor();
        buildDirectDirectMapHolderDescriptor();
        
        buildEntityMapValueDescriptor();
        buildEntityEntityMapHolderDescriptor();
        buildEntityEntity1MMapHolderDescriptor();
        buildEntityEntityU1MMapHolderDescriptor();
        buildEntityMapKeyDescriptor();
        buildEntityDirectMapHolderDescriptor();
        buildEntityAggregateMapHolderDescriptor();
        
        buildDEOTMValueDescriptor();
        buildAEOTMValueDescriptor();
        buildEEOTMValueDescriptor();
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void applyLOGIN() {
        org.eclipse.persistence.sessions.DatabaseLogin login = new org.eclipse.persistence.sessions.DatabaseLogin();
        setLogin(login);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void applyPROJECT() {
        setName("Collections");
    }
    
    
    protected void buildAEOTMValueDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AEOTMMapValue.class);
        Vector vector = new Vector();
        vector.addElement("AE_OM_ENT_MAP_VALUE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AE_OM_ENT_MAP_VALUE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AE_OM_ENT_MAP_VALUE.ID");
        descriptor.addMapping(directtofieldmapping);
        
        OneToOneMapping holderMapping = new OneToOneMapping();
        holderMapping.setAttributeName("holder");
        holderMapping.setReferenceClass(AggregateEntity1MMapHolder.class);
        holderMapping.useBasicIndirection();
        holderMapping.setGetMethodName("getHolder");
        holderMapping.setSetMethodName("setHolder");
        holderMapping.addForeignKeyFieldName("AE_OM_ENT_MAP_VALUE.HOLDER_ID", "AGG_ENT_1M_MAP_HOLDER.ID");
        descriptor.addMapping(holderMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildAggregateAggregateMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AggregateAggregateMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("AGG_AGG_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_AGG_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("AGG_AGG_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGG_AGG_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("aggregateToAggregateMap");
        aggregatecollectionmapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        aggregatecollectionmapping.setGetMethodName("getAggregateToAggregateMap");
        aggregatecollectionmapping.setSetMethodName("setAggregateToAggregateMap");
        aggregatecollectionmapping.setReferenceClass(AggregateMapKey.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("AGG_AGG_MAP_REL.HOLDER_ID", "AGG_AGG_MAP_HOLDER.ID");
        aggregatecollectionmapping.addFieldNameTranslation("AGG_AGG_MAP_REL.MAP_VALUE", "key->DIRECT");
        
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        keyMapping.setReferenceClass(AggregateMapKey.class);
        keyMapping.addFieldNameTranslation("AGG_AGG_MAP_REL.MAP_KEY", "key->DIRECT");
        keyMapping.setDescriptor(descriptor);

        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(aggregatecollectionmapping);
        aggregatecollectionmapping.setContainerPolicy(policy);

        descriptor.addMapping(aggregatecollectionmapping);

        addDescriptor(descriptor);
    }
    
    protected void buildAggregateDirectMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AggregateDirectMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("AGG_DIR_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_DIR_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("AGG_DIR_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGG_DIR_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);
        
        DirectMapMapping directMapMapping = new DirectMapMapping();
        directMapMapping.setAttributeName("aggregateToDirectMap");
        directMapMapping.setGetMethodName("getAggregateToDirectMap");
        directMapMapping.setSetMethodName("setAggregateToDirectMap");
        directMapMapping.setReferenceTableName("AGG_DIR_MAP_REL");
        directMapMapping.setDirectFieldName("AGG_DIR_MAP_REL.MAP_VALUE");
        directMapMapping.addReferenceKeyFieldName("AGG_DIR_MAP_REL.HOLDER_ID", "AGG_DIR_MAP_HOLDER.ID");
        directMapMapping.setDirectFieldClassification(Integer.class);
        directMapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());

        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        keyMapping.setReferenceClass(AggregateMapKey.class);
        keyMapping.addFieldNameTranslation("AGG_DIR_MAP_REL.MAP_KEY", "key->DIRECT");
        keyMapping.setDescriptor(descriptor);

        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(directMapMapping);
        directMapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(directMapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildAggregateEntityMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AggregateEntityMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("AGG_ENT_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ENT_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("AGG_ENT_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGG_ENT_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        ManyToManyMapping mapMapping = new ManyToManyMapping();
        mapMapping.setAttributeName("aggregateToEntityMap");
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setReferenceClass(EntityMapValue.class);
        mapMapping.setRelationTableName("AGG_ENT_MAP_REL");
        mapMapping.setGetMethodName("getAggregateToEntityMap");
        mapMapping.setSetMethodName("setAggregateToEntityMap");
        mapMapping.addSourceRelationKeyFieldName("AGG_ENT_MAP_REL.HOLDER_ID", "AGG_ENT_MAP_HOLDER.ID");
        mapMapping.addTargetRelationKeyFieldName("AGG_ENT_MAP_REL.VALUE_ID", "ENT_MAP_VALUE.ID");
        
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        keyMapping.setReferenceClass(AggregateMapKey.class);
        keyMapping.addFieldNameTranslation("AGG_ENT_MAP_REL.MAP_KEY", "key->DIRECT");
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);

        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    
    protected void buildAggregateEntity1MMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AggregateEntity1MMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("AGG_ENT_1M_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ENT_1M_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("AGG_ENT_1M_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGG_ENT_1M_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        OneToManyMapping mapMapping = new OneToManyMapping();
        mapMapping.setAttributeName("aggregateToEntityMap");
        mapMapping.setReferenceClass(AEOTMMapValue.class);
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setGetMethodName("getAggregateToEntityMap");
        mapMapping.setSetMethodName("setAggregateToEntityMap");
        mapMapping.addTargetForeignKeyFieldName("AE_OM_ENT_MAP_VALUE.HOLDER_ID", "AGG_ENT_1M_MAP_HOLDER.ID");
        
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        keyMapping.setReferenceClass(AggregateMapKey.class);
        keyMapping.addFieldNameTranslation("AE_OM_ENT_MAP_VALUE.MAP_KEY", "key->DIRECT");
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);

        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildAggregateEntityU1MMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AggregateEntityU1MMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("AGG_ENT_U1M_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ENT_U1M_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("AGG_ENT_U1M_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGG_ENT_U1M_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        UnidirectionalOneToManyMapping mapMapping = new UnidirectionalOneToManyMapping();
        mapMapping.setAttributeName("aggregateToEntityMap");
        mapMapping.setReferenceClass(EntityMapValue.class);
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setGetMethodName("getAggregateToEntityMap");
        mapMapping.setSetMethodName("setAggregateToEntityMap");
        mapMapping.addTargetForeignKeyFieldName("ENT_MAP_VALUE.HOLDER_ID", "AGG_ENT_U1M_MAP_HOLDER.ID");
        
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        keyMapping.setReferenceClass(AggregateMapKey.class);
        keyMapping.addFieldNameTranslation("ENT_MAP_VALUE.MAP_KEY_1", "key->DIRECT");
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildAggregateMapKeyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregateCollection();
        descriptor.setJavaClass(AggregateMapKey.class);

        // Descriptor Properties.
        descriptor.setAlias("AggregateMapKey");

        // Mappings.
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("key");
        keyMapping.setFieldName("key->DIRECT");
        keyMapping.setAttributeClassification(Integer.class);
        descriptor.addMapping(keyMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildAggregateMapValueDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregateCollection();
        
        descriptor.setJavaClass(AggregateMapValue.class);

        // Descriptor Properties.
        descriptor.setAlias("AggregateMapValue");

        // Mappings.
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        keyMapping.setAttributeName("value");
        keyMapping.setFieldName("value->DIRECT");
        keyMapping.setAttributeClassification(Integer.class);
        descriptor.addMapping(keyMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildDEOTMValueDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DEOTMMapValue.class);
        Vector vector = new Vector();
        vector.addElement("DE_OM_ENT_MAP_VALUE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DE_OM_ENT_MAP_VALUE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("DE_OM_ENT_MAP_VALUE.ID");
        descriptor.addMapping(directtofieldmapping);
        
        OneToOneMapping holderMapping = new OneToOneMapping();
        holderMapping.setAttributeName("holder");
        holderMapping.setReferenceClass(DirectEntity1MMapHolder.class);
        holderMapping.useBasicIndirection();
        holderMapping.setGetMethodName("getHolder");
        holderMapping.setSetMethodName("setHolder");
        holderMapping.addForeignKeyFieldName("DE_OM_ENT_MAP_VALUE.HOLDER_ID", "DIR_ENT_1M_MAP_HOLDER.ID");
        descriptor.addMapping(holderMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildDirectAggregateMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DirectAggregateMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("DIR_AGG_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DIR_AGG_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("DIR_AGG_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("DIR_AGG_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("directToAggregateMap");
        aggregatecollectionmapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        aggregatecollectionmapping.setGetMethodName("getDirectToAggregateMap");
        aggregatecollectionmapping.setSetMethodName("setDirectToAggregateMap");
        aggregatecollectionmapping.setReferenceClass(AggregateMapValue.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("DIR_AGG_MAP_REL.HOLDER_ID", "DIR_AGG_MAP_HOLDER.ID");
        aggregatecollectionmapping.addFieldNameTranslation("DIR_AGG_MAP_REL.MAP_VALUE", "value->DIRECT");
        
        org.eclipse.persistence.mappings.DirectToFieldMapping keyMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        keyMapping.setFieldName("DIR_AGG_MAP_REL.MAP_KEY");
        keyMapping.setAttributeClassification(Integer.class);
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(aggregatecollectionmapping);
        aggregatecollectionmapping.setContainerPolicy(policy);

        descriptor.addMapping(aggregatecollectionmapping);

        addDescriptor(descriptor);
    }
    
    protected void buildDirectDirectMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DirectDirectMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("DIR_DIR_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DIR_DIR_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("DIR_DIR_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("DIR_DIR_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);
        
        DirectMapMapping directMapMapping = new DirectMapMapping();
        directMapMapping.setAttributeName("directToDirectMap");
        directMapMapping.setReferenceTableName("DIR_DIR_MAP_REL");
        directMapMapping.setDirectFieldName("DIR_DIR_MAP_REL.MAP_VALUE");
        directMapMapping.addReferenceKeyFieldName("DIR_DIR_MAP_REL.HOLDER_ID", "DIR_DIR_MAP_HOLDER.ID");
        directMapMapping.setDirectFieldClassification(Integer.class);
        directMapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());

        org.eclipse.persistence.mappings.DirectToFieldMapping keyMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        keyMapping.setFieldName("DIR_DIR_MAP_REL.MAP_KEY");
        keyMapping.setAttributeClassification(Integer.class);
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(directMapMapping);
        directMapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(directMapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildDirectEntityMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DirectEntityMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("DIR_ENT_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DIR_ENT_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("DIR_ENT_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("DIR_ENT_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        ManyToManyMapping mapMapping = new ManyToManyMapping();
        mapMapping.setAttributeName("directToEntityMap");
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setReferenceClass(EntityMapValue.class);
        mapMapping.setRelationTableName("DIR_ENT_MAP_REL");
        mapMapping.setGetMethodName("getDirectToEntityMap");
        mapMapping.setSetMethodName("setDirectToEntityMap");
        mapMapping.addSourceRelationKeyFieldName("DIR_ENT_MAP_REL.HOLDER_ID", "DIR_ENT_MAP_HOLDER.ID");
        mapMapping.addTargetRelationKeyFieldName("DIR_ENT_MAP_REL.VALUE_ID", "ENT_MAP_VALUE.ID");
        
        org.eclipse.persistence.mappings.DirectToFieldMapping keyMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        keyMapping.setFieldName("DIR_ENT_MAP_REL.MAP_KEY");
        keyMapping.setAttributeClassification(Integer.class);
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }

    protected void buildDirectEntity1MMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DirectEntity1MMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("DIR_ENT_1M_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DIR_ENT_1M_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("DIR_ENT_1M_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("DIR_ENT_1M_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        OneToManyMapping mapMapping = new OneToManyMapping();
        mapMapping.setAttributeName("directToEntityMap");
        mapMapping.setReferenceClass(DEOTMMapValue.class);
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setGetMethodName("getDirectToEntityMap");
        mapMapping.setSetMethodName("setDirectToEntityMap");
        mapMapping.addTargetForeignKeyFieldName("DE_OM_ENT_MAP_VALUE.HOLDER_ID", "DIR_ENT_1M_MAP_HOLDER.ID");

        org.eclipse.persistence.mappings.DirectToFieldMapping keyMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        keyMapping.setFieldName("DE_OM_ENT_MAP_VALUE.MAP_KEY");
        keyMapping.setAttributeClassification(Integer.class);
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildDirectEntityU1MMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DirectEntityU1MMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("DIR_ENT_U1M_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DIR_ENT_U1M_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("DIR_ENT_U1M_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("DIR_ENT_U1M_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        UnidirectionalOneToManyMapping mapMapping = new UnidirectionalOneToManyMapping();
        mapMapping.setAttributeName("directToEntityMap");
        mapMapping.setReferenceClass(EntityMapValue.class);
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setGetMethodName("getDirectToEntityMap");
        mapMapping.setSetMethodName("setDirectToEntityMap");
        mapMapping.addTargetForeignKeyFieldName("ENT_MAP_VALUE.HOLDER_ID", "DIR_ENT_U1M_MAP_HOLDER.ID");
        
        org.eclipse.persistence.mappings.DirectToFieldMapping keyMapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        keyMapping.setFieldName("ENT_MAP_VALUE.MAP_KEY");
        keyMapping.setAttributeClassification(Integer.class);
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildEEOTMValueDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EEOTMMapValue.class);
        Vector vector = new Vector();
        vector.addElement("EE_OM_ENT_MAP_VALUE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("EE_OM_ENT_MAP_VALUE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("EE_OM_ENT_MAP_VALUE.ID");
        descriptor.addMapping(directtofieldmapping);
        
        OneToOneMapping holderMapping = new OneToOneMapping();
        holderMapping.setAttributeName("holder");
        holderMapping.setReferenceClass(EntityEntity1MMapHolder.class);
        holderMapping.useBasicIndirection();
        holderMapping.setGetMethodName("getHolder");
        holderMapping.setSetMethodName("setHolder");
        holderMapping.addForeignKeyFieldName("EE_OM_ENT_MAP_VALUE.HOLDER_ID", "ENT_ENT_1M_MAP_HOLDER.ID");
        descriptor.addMapping(holderMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildEntityAggregateMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EntityAggregateMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("ENT_AGG_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_AGG_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("ENT_AGG_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_AGG_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: AGGREGATECOLLECTIONMAPPING
        org.eclipse.persistence.mappings.AggregateCollectionMapping aggregatecollectionmapping = new org.eclipse.persistence.mappings.AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("entityToAggregateMap");
        aggregatecollectionmapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        aggregatecollectionmapping.setGetMethodName("getEntityToAggregateMap");
        aggregatecollectionmapping.setSetMethodName("setEntityToAggregateMap");
        aggregatecollectionmapping.setReferenceClass(AggregateMapValue.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("ENT_AGG_MAP_REL.HOLDER_ID", "ENT_AGG_MAP_HOLDER.ID");
        aggregatecollectionmapping.addFieldNameTranslation("ENT_AGG_MAP_REL.MAP_VALUE", "value->DIRECT");
        
        org.eclipse.persistence.mappings.OneToOneMapping keyMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        keyMapping.setReferenceClass(EntityMapKey.class);
        keyMapping.addForeignKeyFieldName("ENT_AGG_MAP_REL.KEY_ID", "ENT_MAP_KEY.ID");
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor(descriptor);

        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(aggregatecollectionmapping);
        aggregatecollectionmapping.setContainerPolicy(policy);

        descriptor.addMapping(aggregatecollectionmapping);

        addDescriptor(descriptor);
    }
    
    protected void buildEntityDirectMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EntityDirectMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("ENT_DIR_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_DIR_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("ENT_DIR_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_DIR_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        DirectMapMapping directMapMapping = new DirectMapMapping();
        directMapMapping.setAttributeName("entityToDirectMap");
        directMapMapping.setGetMethodName("getEntityToDirectMap");
        directMapMapping.setSetMethodName("setEntityToDirectMap");
        directMapMapping.setReferenceTableName("ENT_DIR_MAP_REL");
        directMapMapping.setDirectFieldName("ENT_DIR_MAP_REL.MAP_VALUE");
        directMapMapping.addReferenceKeyFieldName("ENT_DIR_MAP_REL.HOLDER_ID", "ENT_DIR_MAP_HOLDER.ID");
        directMapMapping.setDirectFieldClassification(Integer.class);
        directMapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        
        org.eclipse.persistence.mappings.OneToOneMapping keyMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        keyMapping.setReferenceClass(EntityMapKey.class);
        keyMapping.addForeignKeyFieldName("ENT_DIR_MAP_REL.KEY_ID", "ENT_MAP_KEY.ID");
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(directMapMapping);
        directMapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(directMapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildEntityEntityMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EntityEntityMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("ENT_ENT_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_ENT_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("ENT_ENT_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_ENT_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);


        ManyToManyMapping mapMapping = new ManyToManyMapping();
        mapMapping.setAttributeName("entityToEntityMap");
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setReferenceClass(EntityMapValue.class);
        mapMapping.setRelationTableName("ENT_ENT_MAP_REL");
        mapMapping.setGetMethodName("getEntityToEntityMap");
        mapMapping.setSetMethodName("setEntityToEntityMap");
        mapMapping.addSourceRelationKeyFieldName("ENT_ENT_MAP_REL.HOLDER_ID", "ENT_ENT_MAP_HOLDER.ID");
        mapMapping.addTargetRelationKeyFieldName("ENT_ENT_MAP_REL.VALUE_ID", "ENT_MAP_VALUE.ID");
        
        org.eclipse.persistence.mappings.OneToOneMapping keyMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        keyMapping.setReferenceClass(EntityMapKey.class);
        keyMapping.addForeignKeyFieldName("ENT_ENT_MAP_REL.KEY_ID", "ENT_MAP_KEY.ID");
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);

        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildEntityEntity1MMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EntityEntity1MMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("ENT_ENT_1M_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_ENT_1M_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("ENT_ENT_1M_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_ENT_1M_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        OneToManyMapping mapMapping = new OneToManyMapping();
        mapMapping.setAttributeName("entityToEntityMap");
        mapMapping.setReferenceClass(EEOTMMapValue.class);
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setGetMethodName("getEntityToEntityMap");
        mapMapping.setSetMethodName("setEntityToEntityMap");
        mapMapping.addTargetForeignKeyFieldName("EE_OM_ENT_MAP_VALUE.HOLDER_ID", "ENT_ENT_1M_MAP_HOLDER.ID");
        
        org.eclipse.persistence.mappings.OneToOneMapping keyMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        keyMapping.setReferenceClass(EntityMapKey.class);
        keyMapping.dontUseIndirection();
        keyMapping.addForeignKeyFieldName("EE_OM_ENT_MAP_VALUE.KEY_ID", "ENT_MAP_KEY.ID");
        keyMapping.setDescriptor(descriptor);
        
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);

        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }

    
    protected void buildEntityEntityU1MMapHolderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EntityEntityU1MMapHolder.class);
        Vector vector = new Vector();
        vector.addElement("ENT_ENT_U1M_MAP_HOLDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_ENT_U1M_MAP_HOLDER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("ENT_ENT_U1M_MAP_HOLDER_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_ENT_U1M_MAP_HOLDER.ID");
        descriptor.addMapping(directtofieldmapping);

        UnidirectionalOneToManyMapping mapMapping = new UnidirectionalOneToManyMapping();
        mapMapping.setAttributeName("entityToEntityMap");
        mapMapping.setReferenceClass(EntityMapValue.class);
        mapMapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        mapMapping.setGetMethodName("getEntityToEntityMap");
        mapMapping.setSetMethodName("setEntityToEntityMap");
        mapMapping.addTargetForeignKeyFieldName("ENT_MAP_VALUE.HOLDER_ID", "ENT_ENT_U1M_MAP_HOLDER.ID");
        
        org.eclipse.persistence.mappings.OneToOneMapping keyMapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        keyMapping.setReferenceClass(EntityMapKey.class);
        keyMapping.addForeignKeyFieldName("ENT_MAP_VALUE.KEY_ID", "ENT_MAP_KEY.ID");
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor(descriptor);

        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(IndirectMap.class);
        policy.setKeyMapping(keyMapping);
        policy.setValueMapping(mapMapping);
        mapMapping.setContainerPolicy(policy);
        
        descriptor.addMapping(mapMapping);

        addDescriptor(descriptor);
    }
    
    protected void buildEntityMapKeyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EntityMapKey.class);
        Vector vector = new Vector();
        vector.addElement("ENT_MAP_KEY");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_MAP_KEY.ID");

        // Descriptor Properties.
        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("ENT_MAP_KEY_ID");
        descriptor.setSequenceNumberFieldName("ID");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_MAP_KEY.ID");
        descriptor.addMapping(directtofieldmapping);
        
        directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("data");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getData");
        directtofieldmapping.setSetMethodName("setData");
        directtofieldmapping.setFieldName("ENT_MAP_KEY.DATA");
        descriptor.addMapping(directtofieldmapping);
   
        addDescriptor(descriptor);
    }
    
    protected void buildEntityMapValueDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EntityMapValue.class);
        Vector vector = new Vector();
        vector.addElement("ENT_MAP_VALUE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ENT_MAP_VALUE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("ENT_MAP_VALUE.ID");
        descriptor.addMapping(directtofieldmapping);

        addDescriptor(descriptor);
    }
}