/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.lob;

import org.eclipse.persistence.tools.schemaframework.*;

/**
 * This class was generated by the TopLink table creator generator.
 * It stores the meta-data (tables) that define the database schema.
 * @see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator
 */
public class LOBImageModelTableCreator extends TableCreator {

    public LOBImageModelTableCreator() {
        setName("lob");

        addTableDefinition(buildCLIPTable());
        addTableDefinition(buildIMAGETable());
    }

    public TableDefinition buildCLIPTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CLIP");

        FieldDefinition fieldAUDIO = new FieldDefinition();
        fieldAUDIO.setName("AUDIO");
        fieldAUDIO.setTypeName("BLOB");
        fieldAUDIO.setSize(0);
        fieldAUDIO.setSubSize(0);
        fieldAUDIO.setIsPrimaryKey(false);
        fieldAUDIO.setIsIdentity(false);
        fieldAUDIO.setUnique(false);
        fieldAUDIO.setShouldAllowNull(true);
        table.addField(fieldAUDIO);

        FieldDefinition fieldCOMMENTARY = new FieldDefinition();
        fieldCOMMENTARY.setName("COMMENTARY");
        fieldCOMMENTARY.setTypeName("CLOB");
        fieldCOMMENTARY.setSize(0);
        fieldCOMMENTARY.setSubSize(0);
        fieldCOMMENTARY.setIsPrimaryKey(false);
        fieldCOMMENTARY.setIsIdentity(false);
        fieldCOMMENTARY.setUnique(false);
        fieldCOMMENTARY.setShouldAllowNull(true);
        table.addField(fieldCOMMENTARY);

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(38);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        return table;
    }

    public TableDefinition buildIMAGETable() {
        TableDefinition table = new TableDefinition();
        table.setName("IMAGE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(20);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldPICTURE = new FieldDefinition();
        fieldPICTURE.setName("PICTURE");
        fieldPICTURE.setTypeName("BLOB");
        fieldPICTURE.setSize(0);
        fieldPICTURE.setSubSize(0);
        fieldPICTURE.setIsPrimaryKey(false);
        fieldPICTURE.setIsIdentity(false);
        fieldPICTURE.setUnique(false);
        fieldPICTURE.setShouldAllowNull(true);
        table.addField(fieldPICTURE);

        FieldDefinition fieldSCRIPT = new FieldDefinition();
        fieldSCRIPT.setName("SCRIPT");
        fieldSCRIPT.setTypeName("CLOB");
        fieldSCRIPT.setSize(0);
        fieldSCRIPT.setSubSize(0);
        fieldSCRIPT.setIsPrimaryKey(false);
        fieldSCRIPT.setIsIdentity(false);
        fieldSCRIPT.setUnique(false);
        fieldSCRIPT.setShouldAllowNull(true);
        table.addField(fieldSCRIPT);

        return table;
    }

}
