/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.uitools.GlobalAWTExceptionHandler;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.ExceptionBroadcaster;
import org.eclipse.persistence.tools.workbench.utility.ExceptionHandlerThreadGroup;
import org.eclipse.persistence.tools.workbench.utility.ExceptionListener;
import org.eclipse.persistence.tools.workbench.utility.SimpleExceptionBroadcaster;
import org.eclipse.persistence.tools.workbench.utility.log.LoggingExceptionListener;

public class Main {
    public static void main(String[] stringArray) {
        new Main().execute(stringArray);
    }

    private Main() {
    }

    private void execute(String[] stringArray) {
        File file = this.projectFile(stringArray);
        boolean bl = this.developmentMode(stringArray);
        Logger logger = this.buildLogger();
        LoggingExceptionListener loggingExceptionListener = new LoggingExceptionListener(logger, Level.SEVERE, "UNEXPECTED_EXCEPTION");
        SimpleExceptionBroadcaster simpleExceptionBroadcaster = new SimpleExceptionBroadcaster();
        simpleExceptionBroadcaster.addExceptionListener((ExceptionListener)loggingExceptionListener);
        ExceptionHandlerThreadGroup exceptionHandlerThreadGroup = new ExceptionHandlerThreadGroup("application", (ExceptionBroadcaster)simpleExceptionBroadcaster);
        GlobalAWTExceptionHandler.register((ExceptionBroadcaster)simpleExceptionBroadcaster);
        Preferences preferences = this.buildPreferences();
        new Thread((ThreadGroup)exceptionHandlerThreadGroup, new ApplicationLauncher(logger, preferences, file, bl), "Main").start();
    }

    private File projectFile(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (!string.toLowerCase().equals("-open") || (n = i + 1) >= stringArray.length) continue;
            return new File(stringArray[n]);
        }
        return null;
    }

    private boolean developmentMode(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.toLowerCase().equals("-dev")) continue;
            return true;
        }
        return false;
    }

    private Logger buildLogger() {
        Logger logger = Logger.getLogger(this.buildLoggerName(), FrameworkApplication.getResourceBundleName());
        return logger;
    }

    private String buildLoggerName() {
        return ClassTools.packageNameFor(this.getClass());
    }

    private Preferences buildPreferences() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        return preferences;
    }

    private static class ApplicationLauncher
    implements Runnable {
        private Logger logger;
        private Preferences preferences;
        private File projectFile;
        private boolean developmentMode;

        ApplicationLauncher(Logger logger, Preferences preferences, File file, boolean bl) {
            this.logger = logger;
            this.preferences = preferences;
            this.projectFile = file;
            this.developmentMode = bl;
        }

        public void run() {
            FrameworkApplication.launch(this.logger, this.preferences, this.projectFile, this.developmentMode);
        }
    }
}

