/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.ant.AntExtensionBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProblemsBundle;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class ProjectRunner {
    protected StringRepository stringRepository;
    protected StringRepository problemsStringRepository;
    private PrintStream log;
    public static String CR = System.getProperty("line.separator");

    public ProjectRunner() {
        this.initialize(System.out);
    }

    public ProjectRunner(PrintStream printStream) {
        this.initialize(printStream);
    }

    protected void initialize(PrintStream printStream) {
        this.log = printStream;
        this.stringRepository = new DefaultStringRepository(AntExtensionBundle.class);
        this.problemsStringRepository = new DefaultStringRepository(ProblemsBundle.class);
    }

    protected StringBuffer problemsReport(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(256);
        for (Problem problem : collection) {
            String string = problem.getSource().displayString();
            String string2 = problem.getMessageKey();
            String string3 = this.problemsStringRepository.getString(string2, problem.getMessageArguments());
            stringBuffer.append('\n').append(string2).append(" - ").append(string).append(" - ").append(string3);
        }
        return stringBuffer;
    }

    protected StringBuffer igoredProblemsReport(int n, Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.stringRepository.getString("ignoringProblems", String.valueOf(n)));
        Iterator iterator = collection.iterator();
        stringBuffer.append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(", ").append((String)iterator.next());
        }
        return stringBuffer.append(")");
    }

    protected Vector getIgnoredProblems(Collection collection, Collection collection2) {
        Vector<Problem> vector = new Vector<Problem>();
        if (collection2.size() == 0) {
            return vector;
        }
        for (Problem problem : collection) {
            String string = problem.getMessageKey();
            if (!collection2.contains(string)) continue;
            vector.add(problem);
        }
        return vector;
    }

    protected StringBuffer problemsSummary(MWProject mWProject, int n) {
        StringBuffer stringBuffer = new StringBuffer(80);
        return stringBuffer.append(this.stringRepository.getString("numberOfProblems", mWProject.displayString(), String.valueOf(n)));
    }

    protected StringBuffer igoredProblemsSummary(Collection collection, Collection collection2) {
        if (collection.size() > 0 && collection2.size() > 0) {
            return this.igoredProblemsReport(collection.size(), collection2);
        }
        return new StringBuffer();
    }

    protected void log(StringBuffer stringBuffer) {
        this.log(stringBuffer.toString());
    }

    protected void log(String string) {
        this.log.print(string.replaceAll("\n", CR));
    }

    protected void buildReportFile(String string, String string2, StringBuffer stringBuffer, String string3) throws FileNotFoundException {
        PrintStream printStream = null;
        printStream = new PrintStream(new FileOutputStream(string));
        if (string2.equals("html")) {
            stringBuffer = this.buildHtmlReport(stringBuffer, string3);
        } else {
            stringBuffer.insert(0, string3 + "\n\n");
        }
        printStream.print(stringBuffer.toString().replaceAll("\n", CR));
        printStream.close();
    }

    protected StringBuffer buildHtmlReport(StringBuffer stringBuffer, String string) {
        String string2 = stringBuffer.toString().replaceAll("\n", "<br>\n");
        StringBuffer stringBuffer2 = new StringBuffer(2048);
        stringBuffer2.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 TRANSITIONAL//EN\">\n").append("<HTML><HEAD><TITLE>").append(string).append("</TITLE>\n").append("<META HTTP-EQUIV=CONTENT-TYPE CONTENT=\"TEXT/HTML; CHARSET=ISO-8859-1\">\n").append("<STYLE>\n").append("BODY { FONT-FAMILY: ARIAL; FONT-SIZE: 10PT; }\n").append("</STYLE></HEAD><BODY><BLOCKQUOTE><DIV>\n");
        stringBuffer2.append("<BIG><B>").append(string).append("</B></BIG><P>\n").append(string2).append("</DIV></BLOCKQUOTE></BODY></HTML>\n");
        return stringBuffer2;
    }
}

