/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.tools.workbench.ant.ProjectRunner;
import org.eclipse.persistence.tools.workbench.ant.ProjectValidatorInterface;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ProjectValidator
extends ProjectRunner
implements ProjectValidatorInterface {
    public ProjectValidator() {
    }

    public ProjectValidator(PrintStream printStream) {
        super(printStream);
    }

    public int execute(String string, String string2, String string3, Vector vector) {
        int n = 0;
        File file = new File(string);
        try {
            MWProject mWProject = new ProjectIOManager().read(file, Preferences.userNodeForPackage(this.getClass()));
            mWProject.validateBranch();
            Collection collection = CollectionTools.collection((Iterator)mWProject.branchProblems());
            Vector vector2 = this.getIgnoredProblems(collection, vector);
            CollectionTools.removeAll((Collection)collection, vector2.iterator());
            this.generateReport(string2, string3, mWProject, collection, vector2, vector);
            n = collection.size();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause() == null ? throwable : throwable.getCause();
            String string4 = throwable2.getMessage() == null ? throwable2.toString() : throwable2.getMessage();
            throw new BuildException(this.stringRepository.getString("errorWhileValidating", string4), throwable);
        }
        return n;
    }

    protected void generateReport(String string, String string2, MWProject mWProject, Collection collection, Collection collection2, Collection collection3) throws FileNotFoundException {
        StringBuffer stringBuffer = this.problemsSummary(mWProject, mWProject.branchProblemsSize());
        stringBuffer.append(this.problemsReport(collection)).append('\n');
        stringBuffer.append(this.igoredProblemsSummary(collection2, collection3));
        stringBuffer.append(this.problemsReport(collection2)).append('\n');
        this.log(stringBuffer);
        if (string.length() > 0) {
            this.log(this.stringRepository.getString("generatingReport", string) + "\n");
            String string3 = mWProject.displayString() + " - " + DateFormat.getDateInstance().format(new Date());
            this.buildReportFile(string, string2, stringBuffer, string3);
        }
    }
}

