/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.eclipse.persistence.tools.workbench.ant.AntExtensionBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;

public abstract class ProjectTask
extends Task {
    private CommandlineJava commandline;
    private AntClassLoader classLoader;
    private String userClasspath;
    protected StringRepository stringRepository;

    protected ProjectTask() {
        this.initialize();
    }

    protected void initialize() {
        this.classLoader = null;
        this.userClasspath = "";
        this.stringRepository = new DefaultStringRepository(AntExtensionBundle.class);
    }

    protected void preExecute() throws BuildException {
    }

    public void execute() throws BuildException {
        this.preExecute();
    }

    protected int execute(Object[] objectArray) throws BuildException {
        try {
            this.log(this.stringRepository.getString("usingSysProperties", System.getProperties().toString()), 3);
            this.createClassLoader();
            if (this.classLoader != null) {
                this.classLoader.setThreadContextLoader();
            }
            TaskRunner taskRunner = new TaskRunner((ClassLoader)this.classLoader);
            int n = taskRunner.execute(objectArray);
            return n;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.log(invocationTargetException.getTargetException().toString(), 0);
            throw new BuildException(invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause() == null ? throwable : throwable.getCause();
            this.log(throwable2.toString(), 0);
            throw new BuildException(throwable2);
        }
        finally {
            if (this.classLoader != null) {
                this.classLoader.resetThreadContextLoader();
            }
        }
    }

    protected abstract String getProjectRunnerClassName();

    protected CommandlineJava getCommandline() {
        if (this.commandline == null) {
            this.commandline = new CommandlineJava();
        }
        return this.commandline;
    }

    public Path createClasspath() {
        return this.getCommandline().createClasspath(this.getProject()).createPath();
    }

    private void createClassLoader() {
        Path path = this.getCommandline().getClasspath();
        if (path != null && this.classLoader == null) {
            Path path2 = (Path)path.clone();
            if (this.userClasspath.length() > 0) {
                Path path3 = new Path(this.getProject(), this.userClasspath);
                path2.append(path3);
            }
            this.classLoader = this.getProject().createClassLoader(path2);
            this.classLoader.setParentFirst(false);
            this.classLoader.addJavaLibraries();
            this.log(this.stringRepository.getString("usingClasspath", this.classLoader.getClasspath()), 3);
        }
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    protected String getUserClasspath() {
        return this.userClasspath;
    }

    protected void setUserClasspath(String string) {
        this.userClasspath = string;
    }

    private class TaskRunner {
        private Object mappingsRunner;
        protected StringRepository stringRepository;

        private TaskRunner(ClassLoader classLoader) {
            this.initialize(classLoader);
        }

        private void initialize(ClassLoader classLoader) {
            this.stringRepository = new DefaultStringRepository(AntExtensionBundle.class);
            this.mappingsRunner = this.loadMappingsRunner(classLoader);
        }

        private Object loadMappingsRunner(ClassLoader classLoader) {
            Class<?> clazz = null;
            Object var3_3 = null;
            try {
                clazz = Class.forName(ProjectTask.this.getProjectRunnerClassName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(this.stringRepository.getString("errorWhileExporting", ProjectTask.this.getProjectRunnerClassName()), classNotFoundException);
            }
            try {
                var3_3 = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(this.stringRepository.getString("instantiationExceptionAtInstantiation", clazz.getName()), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(this.stringRepository.getString("illegalAccessExceptionAtInstantiation", clazz.getName()), illegalAccessException);
            }
            return var3_3;
        }

        private int execute(Object[] objectArray) throws InvocationTargetException {
            Integer n;
            Method method = null;
            try {
                Class[] classArray = new Class[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        throw new IllegalArgumentException(this.stringRepository.getString("executeMethodCannotBeNull"));
                    }
                    classArray[i] = objectArray[i].getClass();
                }
                method = this.mappingsRunner.getClass().getMethod("execute", classArray);
                if (method.getReturnType().isAssignableFrom(Integer.class)) {
                    throw new RuntimeException(this.stringRepository.getString("expectIntegerReturningType", method.getName()));
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(this.stringRepository.getString("executeMethodNotFound", this.mappingsRunner.getClass().getName()), noSuchMethodException);
            }
            try {
                n = (Integer)method.invoke(this.mappingsRunner, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(this.stringRepository.getString("illegalArgumentExceptionAtInvocation", method.getName()), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(this.stringRepository.getString("illegalAccessExceptionAtInvocation", method.getName()), illegalAccessException);
            }
            return n;
        }
    }
}

