/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant.typedefs;

import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;
import org.eclipse.persistence.tools.workbench.ant.typedefs.IgnoreError;
import org.eclipse.persistence.tools.workbench.ant.typedefs.MappingsType;

public class IgnoreErrorSet
extends MappingsType
implements Cloneable {
    private Vector ignoreErrors;
    private static final String CR = System.getProperty("line.separator");

    public IgnoreErrorSet() {
    }

    protected IgnoreErrorSet(IgnoreErrorSet ignoreErrorSet) {
        this.ignoreErrors = ignoreErrorSet.ignoreErrors;
        this.setProject(ignoreErrorSet.getProject());
    }

    protected void initialize() {
        super.initialize();
        this.ignoreErrors = new Vector();
    }

    public void addIgnoreError(IgnoreError ignoreError) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.ignoreErrors.add(ignoreError);
    }

    public boolean contains(IgnoreError ignoreError) {
        String string = ignoreError.getCode();
        for (IgnoreError ignoreError2 : this.ignoreErrors) {
            if (!string.equals(ignoreError2.getCode())) continue;
            return true;
        }
        return false;
    }

    public Vector getIgnoreErrors(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIgnoreErrors(project);
        }
        Vector vector = new Vector(this.ignoreErrors.size());
        vector.addAll(this.ignoreErrors);
        return vector;
    }

    public Vector getIgnoreErrorCodes(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIgnoreErrorCodes(project);
        }
        Vector<String> vector = new Vector<String>();
        for (IgnoreError ignoreError : this.ignoreErrors) {
            vector.add(ignoreError.getCode());
        }
        return vector;
    }

    protected IgnoreErrorSet getRef(Project project) {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<IgnoreErrorSet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        if ((object = this.getRefid().getReferencedObject(project)) instanceof IgnoreErrorSet) {
            return (IgnoreErrorSet)object;
        }
        throw new BuildException(this.stringRepository.getString("notNotAIgnoreErrorSet", this.getRefid().getRefId()));
    }

    public void setRefid(Reference reference) throws BuildException {
        if (this.ignoreErrors.size() != 0) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append(" [").append(CR);
        Iterator iterator = this.ignoreErrors.iterator();
        while (iterator.hasNext()) {
            IgnoreError ignoreError = (IgnoreError)((Object)iterator.next());
            stringBuffer.append("\t\t");
            ignoreError.toString(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",").append(CR);
        }
        stringBuffer.append(" ] ");
    }
}

