/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.action;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.ShellWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;

public abstract class AbstractFrameworkAction
extends AbstractAction
implements FrameworkAction {
    private WorkbenchContext workbenchContext;
    protected static final Icon EMPTY_ICON = new EmptyIcon(16);

    protected AbstractFrameworkAction(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.initialize();
    }

    protected AbstractFrameworkAction(ApplicationContext applicationContext) {
        this(new ShellWorkbenchContext(applicationContext));
    }

    protected void initialize() {
    }

    protected void initializeText(String string) {
        this.setText(this.resourceRepository().getString(string));
    }

    protected void initializeMnemonic(String string) {
        this.setMnemonic(this.resourceRepository().getMnemonic(string));
    }

    protected void initializeTextAndMnemonic(String string) {
        this.initializeText(string);
        this.initializeMnemonic(string);
    }

    protected void initializeAccelerator(String string) {
        this.setAccelerator(this.resourceRepository().getAccelerator(string));
    }

    protected void initializeIcon(String string) {
        this.setIcon(this.resourceRepository().getIcon(string));
    }

    protected void initializeToolTipText(String string) {
        this.setToolTipText(this.resourceRepository().getString(string));
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.currentWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.execute();
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
    }

    protected void execute() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            this.execute(applicationNodeArray[n]);
        }
    }

    protected void execute(ApplicationNode applicationNode) {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return (String)this.getValue("Name");
    }

    public int getMnemonic() {
        Integer n = (Integer)this.getValue("MnemonicKey");
        return n == null ? -1 : n;
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public String getToolTipText() {
        return (String)this.getValue("ShortDescription");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setText(String string) {
        this.putValue("Name", string);
    }

    public void setToolTipText(String string) {
        this.putValue("ShortDescription", string);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public void setMnemonic(int n) {
        this.putValue("MnemonicKey", new Integer(n));
    }

    public ApplicationContext getApplicationContext() {
        return this.getWorkbenchContext().getApplicationContext();
    }

    public WorkbenchContext getWorkbenchContext() {
        return this.workbenchContext;
    }

    public Application application() {
        return this.getApplicationContext().getApplication();
    }

    public Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    public NodeManager nodeManager() {
        return this.getApplicationContext().getNodeManager();
    }

    public HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    public Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    public NavigatorSelectionModel navigatorSelectionModel() {
        return this.getWorkbenchContext().getNavigatorSelectionModel();
    }

    public ApplicationNode[] selectedNodes() {
        return this.navigatorSelectionModel().getSelectedNodes();
    }

    public ApplicationNode[] selectedProjectNodes() {
        return this.navigatorSelectionModel().getSelectedProjectNodes();
    }

    public String getClassification() {
        return this.getClass().getName();
    }

    public static Runnable buildDialogLauncher(final Dialog dialog) {
        return new Runnable(){

            public void run() {
                dialog.show();
            }
        };
    }

    public static void launchLater(Dialog dialog) {
        EventQueue.invokeLater(AbstractFrameworkAction.buildDialogLauncher(dialog));
    }

    public static void launchAndWait(Dialog dialog) {
        try {
            EventQueue.invokeAndWait(AbstractFrameworkAction.buildDialogLauncher(dialog));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

