/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblem;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblemContainer;
import org.eclipse.persistence.tools.workbench.framework.app.CompositeIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.DefaultApplicationProblem;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.SimpleIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContextWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.ShellWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultIconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractApplicationNode
extends AbstractTreeNodeValueModel
implements ApplicationNode {
    private NodeModel value;
    private TreeNodeValueModel parent;
    private Plugin plugin;
    private ApplicationContext context;
    private String displayString;
    private PropertyChangeListener valueDisplayStringListener;
    protected static final String[] DEFAULT_DISPLAY_STRING_PROPERTY_NAMES = new String[0];
    private IconBuilder iconBuilder;
    private Icon icon;
    private PropertyChangeListener valueIconListener;
    protected static final String[] DEFAULT_ICON_PROPERTY_NAMES = new String[]{"hasBranchProblems"};
    private boolean dirty;
    private PropertyChangeListener valueDirtyListener;
    protected static final String[] DEFAULT_DIRTY_PROPERTY_NAMES = new String[]{"dirtyBranch"};
    private List applicationProblems;
    private List branchApplicationProblems;
    private ListChangeListener valueBranchProblemsListener;
    protected static final String[] DEFAULT_BRANCH_PROBLEMS_LIST_NAMES = new String[]{"branchProblems"};
    private String propertiesPageTitleText;
    private PropertyChangeListener valuePropertiesPageTitleTextListener;
    private IconBuilder propertiesPageTitleIconBuilder;
    private Icon propertiesPageTitleIcon;
    private PropertyChangeListener valuePropertiesPageTitleIconListener;
    private static final Icon PROBLEM_ICON = new DefaultIconRepository(new FrameworkIconResourceFileNameMap()).getIcon("problem.small");
    protected static final Icon EMPTY_ICON = new EmptyIcon(16);

    protected AbstractApplicationNode(ApplicationContext applicationContext) {
        this(null, null, null, applicationContext);
    }

    protected AbstractApplicationNode(NodeModel nodeModel, TreeNodeValueModel treeNodeValueModel, Plugin plugin, ApplicationContext applicationContext) {
        this.value = nodeModel;
        this.context = this.expandContext(applicationContext);
        this.plugin = plugin;
        this.parent = treeNodeValueModel;
        this.valueDisplayStringListener = this.buildValueDisplayStringListener();
        this.valueIconListener = this.buildValueIconListener();
        this.valueDirtyListener = this.buildValueDirtyListener();
        this.valueBranchProblemsListener = this.buildValueBranchProblemsListener();
        this.applicationProblems = new ArrayList();
        this.branchApplicationProblems = new ArrayList();
        this.valuePropertiesPageTitleTextListener = this.buildValuePropertiesPageTitleTextListener();
        this.valuePropertiesPageTitleIconListener = this.buildValuePropertiesPageTitleIconListener();
    }

    protected ApplicationContext expandContext(ApplicationContext applicationContext) {
        return applicationContext;
    }

    protected WorkbenchContext buildLocalWorkbenchContext(WorkbenchContext workbenchContext) {
        return new ApplicationContextWorkbenchContext(workbenchContext, this.getApplicationContext());
    }

    protected WorkbenchContext buildShellWorkbenchContext() {
        return new ShellWorkbenchContext(this.getApplicationContext());
    }

    private PropertyChangeListener buildValueDisplayStringListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractApplicationNode.this.displayStringChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"display string listener");
            }
        };
    }

    private PropertyChangeListener buildValueIconListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractApplicationNode.this.iconChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"icon listener");
            }
        };
    }

    private PropertyChangeListener buildValueDirtyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractApplicationNode.this.dirtyChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"dirty listener");
            }
        };
    }

    private ListChangeListener buildValueBranchProblemsListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                AbstractApplicationNode.this.branchProblemsChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"branch problems listener");
            }
        };
    }

    private PropertyChangeListener buildValuePropertiesPageTitleTextListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractApplicationNode.this.propertiesPageTitleTextChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"properties page title text listener");
            }
        };
    }

    private PropertyChangeListener buildValuePropertiesPageTitleIconListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractApplicationNode.this.propertiesPageTitleIconChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"properties page title icon listener");
            }
        };
    }

    protected void engageValue() {
        this.engageValueProperties();
        this.engageValueLists();
    }

    protected void engageValueProperties() {
        if (this.hasNoPropertyChangeListeners("displayString")) {
            this.engageValueDisplayString();
        }
        if (this.hasNoPropertyChangeListeners("icon")) {
            this.engageValueIcon();
        }
        if (this.hasNoPropertyChangeListeners("dirty")) {
            this.engageValueDirty();
        }
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleText")) {
            this.engageValuePropertiesPageTitleText();
        }
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.engageValuePropertiesPageTitleIcon();
        }
    }

    protected void engageValueLists() {
        if (this.hasNoListChangeListeners("applicationProblems") && this.hasNoListChangeListeners("branchApplicationProblems")) {
            this.engageValueBranchProblems();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValueProperties();
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.hasNoStateChangeListeners()) {
            if (this.hasNoPCLs(string, "displayString")) {
                this.engageValueDisplayString();
            }
            if (this.hasNoPCLs(string, "icon")) {
                this.engageValueIcon();
            }
            if (this.hasNoPCLs(string, "dirty")) {
                this.engageValueDirty();
            }
            if (this.hasNoPCLs(string, "propertiesPageTitleText")) {
                this.engageValuePropertiesPageTitleText();
            }
            if (this.hasNoPCLs(string, "propertiesPageTitleIcon")) {
                this.engageValuePropertiesPageTitleIcon();
            }
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected boolean hasNoPCLs(String string, String string2) {
        return string == string2 && this.hasNoPropertyChangeListeners(string2);
    }

    public void addListChangeListener(ListChangeListener listChangeListener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValueLists();
        }
        super.addListChangeListener(listChangeListener);
    }

    public void addListChangeListener(String string, ListChangeListener listChangeListener) {
        if (this.hasNoStateChangeListeners() && this.hasNoProblemListeners(string)) {
            this.engageValueBranchProblems();
        }
        super.addListChangeListener(string, listChangeListener);
    }

    private boolean hasNoProblemListeners(String string) {
        if (string == "applicationProblems" || string == "branchApplicationProblems") {
            return this.hasNoListChangeListeners("applicationProblems") && this.hasNoListChangeListeners("branchApplicationProblems");
        }
        return false;
    }

    protected void engageValue(String[] stringArray, PropertyChangeListener propertyChangeListener) {
        this.engage((Model)this.value, stringArray, propertyChangeListener);
    }

    protected void engage(Model model, String[] stringArray, PropertyChangeListener propertyChangeListener) {
        int n = stringArray.length;
        while (n-- > 0) {
            model.addPropertyChangeListener(stringArray[n], propertyChangeListener);
        }
    }

    protected void engageValueDisplayString() {
        this.engageValue(this.displayStringPropertyNames(), this.valueDisplayStringListener);
        this.rebuildDisplayString();
    }

    protected String[] displayStringPropertyNames() {
        return DEFAULT_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected void engageValueIcon() {
        this.engageValue(this.iconPropertyNames(), this.valueIconListener);
        this.rebuildIconBuilder();
        this.rebuildIcon();
    }

    protected String[] iconPropertyNames() {
        return DEFAULT_ICON_PROPERTY_NAMES;
    }

    protected void engageValueDirty() {
        this.engageValue(this.dirtyPropertyNames(), this.valueDirtyListener);
        this.rebuildDirtyFlag();
    }

    protected String[] dirtyPropertyNames() {
        return DEFAULT_DIRTY_PROPERTY_NAMES;
    }

    protected void engageValuePropertiesPageTitleText() {
        this.engageValue(this.propertiesPageTitleTextPropertyNames(), this.valuePropertiesPageTitleTextListener);
        this.rebuildPropertiesPageTitleText();
    }

    protected String[] propertiesPageTitleTextPropertyNames() {
        return this.displayStringPropertyNames();
    }

    protected void engageValuePropertiesPageTitleIcon() {
        this.engageValue(this.propertiesPageTitleIconPropertyNames(), this.valuePropertiesPageTitleIconListener);
        this.rebuildPropertiesPageTitleIconBuilder();
        this.rebuildPropertiesPageTitleIcon();
    }

    protected String[] propertiesPageTitleIconPropertyNames() {
        return this.iconPropertyNames();
    }

    protected void engageValue(String[] stringArray, ListChangeListener listChangeListener) {
        this.engage((Model)this.value, stringArray, listChangeListener);
    }

    protected void engage(Model model, String[] stringArray, ListChangeListener listChangeListener) {
        int n = stringArray.length;
        while (n-- > 0) {
            model.addListChangeListener(stringArray[n], listChangeListener);
        }
    }

    protected String[] branchProblemsListNames() {
        return DEFAULT_BRANCH_PROBLEMS_LIST_NAMES;
    }

    protected void engageValueBranchProblems() {
        this.engageValue(this.branchProblemsListNames(), this.valueBranchProblemsListener);
        this.rebuildApplicationProblems();
        this.rebuildBranchApplicationProblems();
    }

    protected void disengageValue() {
        this.disengageValueLists();
        this.disengageValueProperties();
    }

    protected void disengageValueLists() {
        if (this.hasNoListChangeListeners("applicationProblems") && this.hasNoListChangeListeners("branchApplicationProblems")) {
            this.disengageValueBranchProblems();
        }
    }

    protected void disengageValueProperties() {
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.disengageValuePropertiesPageTitleIcon();
        }
        if (this.hasNoPropertyChangeListeners("propertiesPageTitleText")) {
            this.disengageValuePropertiesPageTitleText();
        }
        if (this.hasNoPropertyChangeListeners("dirty")) {
            this.disengageValueDirty();
        }
        if (this.hasNoPropertyChangeListeners("icon")) {
            this.disengageValueIcon();
        }
        if (this.hasNoPropertyChangeListeners("displayString")) {
            this.disengageValueDisplayString();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValueProperties();
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (this.hasNoStateChangeListeners()) {
            if (this.hasNoPCLs(string, "propertiesPageTitleIcon")) {
                this.disengageValuePropertiesPageTitleIcon();
            }
            if (this.hasNoPCLs(string, "propertiesPageTitleText")) {
                this.disengageValuePropertiesPageTitleText();
            }
            if (this.hasNoPCLs(string, "dirty")) {
                this.disengageValueDirty();
            }
            if (this.hasNoPCLs(string, "icon")) {
                this.disengageValueIcon();
            }
            if (this.hasNoPCLs(string, "displayString")) {
                this.disengageValueDisplayString();
            }
        }
    }

    public void removeListChangeListener(ListChangeListener listChangeListener) {
        super.removeListChangeListener(listChangeListener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValueLists();
        }
    }

    public void removeListChangeListener(String string, ListChangeListener listChangeListener) {
        super.removeListChangeListener(string, listChangeListener);
        if (this.hasNoStateChangeListeners() && this.hasNoProblemListeners(string)) {
            this.disengageValueBranchProblems();
        }
    }

    protected void disengageValue(String[] stringArray, PropertyChangeListener propertyChangeListener) {
        this.disengage((Model)this.value, stringArray, propertyChangeListener);
    }

    protected void disengage(Model model, String[] stringArray, PropertyChangeListener propertyChangeListener) {
        int n = stringArray.length;
        while (n-- > 0) {
            model.removePropertyChangeListener(stringArray[n], propertyChangeListener);
        }
    }

    protected void disengageValue(String[] stringArray, ListChangeListener listChangeListener) {
        this.disengage((Model)this.value, stringArray, listChangeListener);
    }

    protected void disengage(Model model, String[] stringArray, ListChangeListener listChangeListener) {
        int n = stringArray.length;
        while (n-- > 0) {
            model.removeListChangeListener(stringArray[n], listChangeListener);
        }
    }

    protected void disengageValueBranchProblems() {
        this.disengageValue(this.branchProblemsListNames(), this.valueBranchProblemsListener);
        this.applicationProblems.clear();
        this.branchApplicationProblems.clear();
    }

    protected void disengageValuePropertiesPageTitleIcon() {
        this.disengageValue(this.propertiesPageTitleIconPropertyNames(), this.valuePropertiesPageTitleIconListener);
        this.propertiesPageTitleIconBuilder = null;
        this.propertiesPageTitleIcon = null;
    }

    protected void disengageValuePropertiesPageTitleText() {
        this.disengageValue(this.propertiesPageTitleTextPropertyNames(), this.valuePropertiesPageTitleTextListener);
        this.propertiesPageTitleText = null;
    }

    protected void disengageValueDirty() {
        this.disengageValue(this.dirtyPropertyNames(), this.valueDirtyListener);
        this.dirty = false;
    }

    protected void disengageValueIcon() {
        this.disengageValue(this.iconPropertyNames(), this.valueIconListener);
        this.iconBuilder = null;
        this.icon = null;
    }

    protected void disengageValueDisplayString() {
        this.disengageValue(this.displayStringPropertyNames(), this.valueDisplayStringListener);
        this.displayString = null;
    }

    protected PropertyChangeListener getValueDisplayStringListener() {
        return this.valueDisplayStringListener;
    }

    protected PropertyChangeListener getValueIconListener() {
        return this.valueIconListener;
    }

    protected PropertyChangeListener getValueDirtyListener() {
        return this.valueDirtyListener;
    }

    protected ListChangeListener getValueBranchProblemsListener() {
        return this.valueBranchProblemsListener;
    }

    protected PropertyChangeListener getValuePropertiesPageTitleTextListener() {
        return this.valuePropertiesPageTitleTextListener;
    }

    protected PropertyChangeListener getValuePropertiesPageTitleIconListener() {
        return this.valuePropertiesPageTitleIconListener;
    }

    protected final void rebuildDisplayString() {
        this.displayString = this.buildDisplayString();
    }

    protected String buildDisplayString() {
        return this.value.displayString();
    }

    protected final void rebuildIconBuilder() {
        this.iconBuilder = this.buildIconBuilder();
    }

    protected IconBuilder buildIconBuilder() {
        return new CompositeIconBuilder(this.buildBaseIconBuilder(), this.valueHasBranchProblems(), PROBLEM_ICON, -21, 0, 3, null);
    }

    protected IconBuilder buildBaseIconBuilder() {
        return new SimpleIconBuilder(this.resourceRepository().getIcon(this.buildIconKey()));
    }

    protected String buildIconKey() {
        return null;
    }

    protected final void rebuildIcon() {
        this.icon = this.buildIcon();
    }

    protected final Icon buildIcon() {
        return this.iconBuilder.buildIcon();
    }

    protected final void rebuildDirtyFlag() {
        this.dirty = this.buildDirtyFlag();
    }

    protected boolean buildDirtyFlag() {
        return this.value.isDirtyBranch();
    }

    protected final void rebuildPropertiesPageTitleText() {
        this.propertiesPageTitleText = this.buildPropertiesPageTitleText();
    }

    protected String buildPropertiesPageTitleText() {
        return this.buildDisplayString();
    }

    protected final void rebuildPropertiesPageTitleIconBuilder() {
        this.propertiesPageTitleIconBuilder = this.buildPropertiesPageTitleIconBuilder();
    }

    protected IconBuilder buildPropertiesPageTitleIconBuilder() {
        return this.buildIconBuilder();
    }

    protected final void rebuildPropertiesPageTitleIcon() {
        this.propertiesPageTitleIcon = this.buildPropertiesPageTitleIcon();
    }

    protected final Icon buildPropertiesPageTitleIcon() {
        return this.propertiesPageTitleIconBuilder.buildIcon();
    }

    protected final void rebuildApplicationProblems() {
        this.applicationProblems.clear();
        this.addExclusiveApplicationProblemsTo(this.applicationProblems);
    }

    protected void addExclusiveApplicationProblemsTo(List list) {
        ListIterator listIterator = this.value.branchProblems();
        while (listIterator.hasNext()) {
            Problem problem = (Problem)listIterator.next();
            if (!this.ownsExclusively(problem)) continue;
            list.add(this.buildApplicationProblem(problem));
        }
    }

    private boolean ownsExclusively(Problem problem) {
        return this.value.containsBranchProblem(problem) && !this.childrenContain(problem);
    }

    private boolean childrenContain(Problem problem) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            if (!((ApplicationProblemContainer)iterator.next()).containsBranchApplicationProblemFor(problem)) continue;
            return true;
        }
        return false;
    }

    ApplicationProblem buildApplicationProblem(Problem problem) {
        return new DefaultApplicationProblem(this, problem.getMessageKey(), this.resourceRepository().getString(problem.getMessageKey(), problem.getMessageArguments()));
    }

    protected final void rebuildBranchApplicationProblems() {
        this.branchApplicationProblems.clear();
        this.addBranchApplicationProblemsTo(this.branchApplicationProblems);
    }

    public Iterator children() {
        return (Iterator)this.getChildrenModel().getValue();
    }

    protected boolean valueHasBranchProblems() {
        return this.value.hasBranchProblems();
    }

    public NodeManager nodeManager() {
        return this.getApplicationContext().getNodeManager();
    }

    protected ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    protected Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public void selectDescendantNodeForValue(Node node, NavigatorSelectionModel navigatorSelectionModel) {
        navigatorSelectionModel.setSelectedNode(this.descendantNodeForValue(node));
    }

    protected void displayStringChanged() {
        String string = this.displayString;
        this.rebuildDisplayString();
        this.firePropertyChanged("displayString", string, this.displayString);
        if (this.attributeValueHasChanged(string, this.displayString)) {
            this.fireStateChanged();
        }
    }

    protected void iconChanged() {
        IconBuilder iconBuilder = this.iconBuilder;
        this.rebuildIconBuilder();
        if (!((Object)this.iconBuilder).equals(iconBuilder)) {
            Icon icon = this.icon;
            this.rebuildIcon();
            this.firePropertyChanged("icon", icon, this.icon);
            this.fireStateChanged();
        }
    }

    protected void dirtyChanged() {
        boolean bl = this.dirty;
        this.rebuildDirtyFlag();
        this.firePropertyChanged("dirty", bl, this.dirty);
        if (this.dirty != bl) {
            this.fireStateChanged();
        }
    }

    protected void propertiesPageTitleTextChanged() {
        String string = this.propertiesPageTitleText;
        this.rebuildPropertiesPageTitleText();
        this.firePropertyChanged("propertiesPageTitleText", string, this.propertiesPageTitleText);
        if (this.attributeValueHasChanged(string, this.propertiesPageTitleText)) {
            this.fireStateChanged();
        }
    }

    protected void propertiesPageTitleIconChanged() {
        IconBuilder iconBuilder = this.propertiesPageTitleIconBuilder;
        this.rebuildPropertiesPageTitleIconBuilder();
        if (!((Object)this.propertiesPageTitleIconBuilder).equals(iconBuilder)) {
            Icon icon = this.propertiesPageTitleIcon;
            this.rebuildPropertiesPageTitleIcon();
            this.firePropertyChanged("propertiesPageTitleIcon", icon, this.propertiesPageTitleIcon);
            this.fireStateChanged();
        }
    }

    protected void branchProblemsChanged() {
        this.rebuildApplicationProblems();
        this.fireListChanged("applicationProblems");
        this.rebuildBranchApplicationProblems();
        this.fireListChanged("branchApplicationProblems");
    }

    public Object getValue() {
        return this.value;
    }

    public TreeNodeValueModel getParent() {
        return this.parent;
    }

    public ListValueModel getChildrenModel() {
        return NullListValueModel.instance();
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ApplicationNode getProjectRoot() {
        if (this.getParent() == this.nodeManager().getRootNode()) {
            return this;
        }
        return ((ApplicationNode)this.getParent()).getProjectRoot();
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public String helpTopicID() {
        return "default";
    }

    public boolean save(File file, WorkbenchContext workbenchContext) {
        return this.getProjectRoot().save(file, workbenchContext);
    }

    public boolean saveAs(File file, WorkbenchContext workbenchContext) {
        return this.getProjectRoot().saveAs(file, workbenchContext);
    }

    public File saveFile() {
        return this.getProjectRoot().saveFile();
    }

    public void addValuePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.value.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removeValuePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.value.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final ApplicationNode descendantNodeForValue(Node node) {
        if (this.value == node) {
            return this;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ApplicationNode applicationNode = ((ApplicationNode)iterator.next()).descendantNodeForValue(node);
            if (applicationNode == null) continue;
            return applicationNode;
        }
        return null;
    }

    public final ListIterator applicationProblems() {
        return this.applicationProblems.listIterator();
    }

    public final int applicationProblemsSize() {
        return this.applicationProblems.size();
    }

    public final void addApplicationProblemsTo(List list) {
        list.addAll(this.applicationProblems);
    }

    public final ListIterator branchApplicationProblems() {
        return this.branchApplicationProblems.listIterator();
    }

    public final int branchApplicationProblemsSize() {
        return this.branchApplicationProblems.size();
    }

    public void addBranchApplicationProblemsTo(List list) {
        this.addApplicationProblemsTo(list);
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((ApplicationProblemContainer)iterator.next()).addBranchApplicationProblemsTo(list);
        }
    }

    public boolean containsBranchApplicationProblemFor(Problem problem) {
        return this.value.containsBranchProblem(problem);
    }

    public void printBranchApplicationProblemsOn(IndentingPrintWriter indentingPrintWriter) {
        if (this.branchApplicationProblems.size() == 0) {
            return;
        }
        this.printBranchApplicationProblemsHeaderOn(indentingPrintWriter);
        indentingPrintWriter.println();
        indentingPrintWriter.indent();
        Iterator iterator = this.applicationProblems();
        while (iterator.hasNext()) {
            ((ApplicationProblem)iterator.next()).printOn(indentingPrintWriter);
            indentingPrintWriter.println();
        }
        iterator = this.children();
        while (iterator.hasNext()) {
            ((ApplicationProblemContainer)iterator.next()).printBranchApplicationProblemsOn(indentingPrintWriter);
        }
        indentingPrintWriter.undent();
    }

    protected void printBranchApplicationProblemsHeaderOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print(this.displayString());
    }

    public final String propertiesPageTitleText() {
        return this.propertiesPageTitleText;
    }

    public final Icon propertiesPageTitleIcon() {
        return this.propertiesPageTitleIcon;
    }

    public final String displayString() {
        return this.displayString;
    }

    public final Icon icon() {
        return this.icon;
    }

    public int compareTo(Object object) {
        return DEFAULT_COMPARATOR.compare(this, object);
    }

    public String accessibleName() {
        return this.resourceRepository().getString(this.accessibleNameKey(), this.displayString());
    }

    protected String accessibleNameKey() {
        return "ACCESSIBLE_NODE";
    }
}

