/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.help.InternalHelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultHelpManager
implements InternalHelpManager {
    private ExternalBrowserHandler browser;
    private HashMap<String, String> topicIdtoUrlMap;
    private LocalMouseListener mouseListener;
    private KeyListener keyListener;
    private Map topicIDs;
    private ResourceRepository resourceRepository;
    private boolean localHelpFailed;
    static final String BROWSER_PREFERENCE = "external web browser";
    static final String BROWSER_PREFERENCE_DEFAULT = "";

    private DefaultHelpManager() {
        this.initialize();
    }

    DefaultHelpManager(ResourceRepository resourceRepository, Preferences preferences) {
        this();
        this.resourceRepository = resourceRepository;
        this.localHelpFailed = false;
        this.initialize(preferences);
    }

    protected void initialize() {
        this.keyListener = this.buildKeyListener();
        this.topicIDs = new WeakHashMap();
    }

    private void initialize(Preferences preferences) {
        Icon icon = this.resourceRepository.getIcon("oracle.logo.large");
        this.mouseListener = this.buildMouseListener(this.resourceRepository.getString("CSH_HELP"));
        this.browser = new ExternalBrowserHandler(preferences);
        this.topicIdtoUrlMap = this.initializeTopicMap();
    }

    private KeyListener buildKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 112) {
                    DefaultHelpManager.this.showTopic((Component)keyEvent.getSource());
                    keyEvent.consume();
                }
            }
        };
    }

    private LocalMouseListener buildMouseListener(String string) {
        return new LocalMouseListener(string);
    }

    @Override
    public void setLocalHelpFailed(boolean bl) {
        this.localHelpFailed = bl;
    }

    @Override
    public void launchComplete() {
        if (this.localHelpFailed) {
            this.showTopic("noHelp");
        }
    }

    @Override
    public void showHelp() {
        this.showTopic("default");
    }

    @Override
    public void showTopic(String string) {
        this.showTopicInternal(string);
    }

    public void showUrl(String string) {
        this.browser.handleValue(string);
    }

    @Override
    public void showTopic(Component component) {
        String string = this.getTopicID(component);
        if (string != null) {
            this.showTopicInternal(string, component);
        }
    }

    @Override
    public void addTopicIDs(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.addTopicID((Component)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public void addTopicID(Component component, String string) {
        this.listenTo(component);
        this.topicIDs.put(component, string);
    }

    @Override
    public void removeTopicIDs(Map map) {
        this.removeTopicIDs(map.keySet());
    }

    @Override
    public void removeTopicIDs(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeTopicID((Component)iterator.next());
        }
    }

    @Override
    public void removeTopicID(Component component) {
        this.topicIDs.remove(component);
        this.stopListeningTo(component);
    }

    @Override
    public void addItemsToPopupMenuForComponent(JMenuItem[] jMenuItemArray, Component component) {
        this.mouseListener.addItemsToPopupMenuForComponent(jMenuItemArray, component);
    }

    @Override
    public void shutDown() {
    }

    private String getTopicID(Component component) {
        if (component == null) {
            return null;
        }
        String string = (String)this.topicIDs.get(component);
        if (string == null) {
            return this.getTopicID(component.getParent());
        }
        return string;
    }

    protected void showTopicInternal(String string) {
        String string2 = this.topicIdtoUrlMap.get(string);
        if (string2 == null) {
            string2 = this.topicIdtoUrlMap.get("default");
        }
        this.browser.handleValue(string2);
    }

    protected void showTopicInternal(String string, Component component) {
        String string2 = this.topicIdtoUrlMap.get(string);
        if (string2 == null) {
            string2 = this.topicIdtoUrlMap.get("default");
        }
        this.browser.handleValue(string2, component);
    }

    private void listenTo(Component component) {
        if (CollectionTools.contains((Object[])component.getMouseListeners(), (Object)this.mouseListener)) {
            return;
        }
        component.addMouseListener(this.mouseListener);
        component.addKeyListener(this.keyListener);
        if (component instanceof Container) {
            this.listenTo(((Container)component).getComponents());
        }
    }

    private void listenTo(Component[] componentArray) {
        int n = componentArray.length;
        while (n-- > 0) {
            this.listenTo(componentArray[n]);
        }
    }

    private void stopListeningTo(Component component) {
        if (!CollectionTools.contains((Object[])component.getMouseListeners(), (Object)this.mouseListener)) {
            return;
        }
        component.removeMouseListener(this.mouseListener);
        component.removeKeyListener(this.keyListener);
        if (component instanceof Container) {
            this.stopListeningTo(((Container)component).getComponents());
        }
    }

    private void stopListeningTo(Component[] componentArray) {
        int n = componentArray.length;
        while (n-- > 0) {
            this.stopListeningTo(componentArray[n]);
        }
    }

    private void showNavigatorWindow(Class clazz) {
    }

    private HashMap<String, String> initializeTopicMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("default", "http://wiki.eclipse.org/EclipseLink/UserGuide");
        hashMap.put("eclipselink_home", "http://www.eclipse.org/eclipselink/");
        hashMap.put("eclipslink_userguide", "http://wiki.eclipse.org/EclipseLink/UserGuide");
        hashMap.put("eclipselink_api", "http://www.eclipse.org/eclipselink/api/1.0/index.html");
        hashMap.put("eclipselink_examples", "http://wiki.eclipse.org/EclipseLink/Examples");
        return hashMap;
    }

    private class ExternalBrowserHandler {
        private Preferences preferences;
        public static final String PROTOCOL_NAME = "external";

        public ExternalBrowserHandler(Preferences preferences) {
            this.preferences = preferences;
        }

        public void handleValue(String string, Component component) {
            String string2 = this.preferences.get(DefaultHelpManager.BROWSER_PREFERENCE, DefaultHelpManager.BROWSER_PREFERENCE_DEFAULT);
            try {
                Runtime.getRuntime().exec(string2 + " " + string);
            }
            catch (IOException iOException) {
                this.showBrowserConfigMessages(component);
            }
        }

        public void handleValue(String string) {
            String string2 = this.preferences.get(DefaultHelpManager.BROWSER_PREFERENCE, DefaultHelpManager.BROWSER_PREFERENCE_DEFAULT);
            try {
                Runtime.getRuntime().exec(string2 + " " + string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(DefaultHelpManager.this.resourceRepository.getString("CONFIGURE_EXTERNAL_BROWSER"));
            }
        }

        private void showBrowserConfigMessages(Component component) {
            JOptionPane.showMessageDialog(component, DefaultHelpManager.this.resourceRepository.getString("CONFIGURE_EXTERNAL_BROWSER"), DefaultHelpManager.this.resourceRepository.getString("CONFIGURE_EXTERNAL_BROWSER_TITLE"), 2);
        }
    }

    private class LocalMouseListener
    extends MouseAdapter {
        JPopupMenu popupMenu;
        private Component component;
        private Map popupMenuItems;

        LocalMouseListener(String string) {
            this.initialize(string);
        }

        private void initialize(String string) {
            this.popupMenuItems = new WeakHashMap();
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this.buildMenuItemListener());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(jMenuItem);
        }

        private ActionListener buildMenuItemListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LocalMouseListener.this.showHelp();
                }
            };
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent);
        }

        private void handleMouseEvent(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            if (this.component != null) {
                this.removeMenuItemsFor(this.component);
            }
            this.component = (Component)mouseEvent.getSource();
            this.insertMenuItemsFor(this.component);
            this.popupMenu.show(this.component, mouseEvent.getX(), mouseEvent.getY());
        }

        private synchronized void insertMenuItemsFor(Component component) {
            JMenuItem[] jMenuItemArray = this.menuItemsFor(component);
            if (jMenuItemArray != null) {
                for (int i = 0; i < jMenuItemArray.length; ++i) {
                    this.popupMenu.insert(jMenuItemArray[i], i);
                }
            }
        }

        private synchronized void removeMenuItemsFor(Component component) {
            JMenuItem[] jMenuItemArray = this.menuItemsFor(component);
            if (jMenuItemArray != null) {
                for (int i = 0; i < jMenuItemArray.length; ++i) {
                    this.popupMenu.remove(jMenuItemArray[i]);
                }
            }
        }

        void showHelp() {
            DefaultHelpManager.this.showTopic(this.component);
        }

        void addItemsToPopupMenuForComponent(JMenuItem[] jMenuItemArray, Component component) {
            this.popupMenuItems.put(component, jMenuItemArray);
        }

        private JMenuItem[] menuItemsFor(Component component) {
            return (JMenuItem[])this.popupMenuItems.get(component);
        }
    }
}

