/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

final class AboutDialog
extends JDialog {
    private Action okAction;

    AboutDialog(WorkbenchContext workbenchContext) {
        super((Frame)workbenchContext.getCurrentWindow());
        this.initialize(workbenchContext);
    }

    private void initialize(WorkbenchContext workbenchContext) {
        this.setTitle(workbenchContext.getApplicationContext().getResourceRepository().getString("about", workbenchContext.getApplicationContext().getApplication().getProductName()));
        this.setName("About");
        this.setModal(true);
        this.setResizable(false);
        this.okAction = this.buildOKAction(workbenchContext);
        this.initializeDefaultKeyboardActions();
        this.initializeContentPane(workbenchContext.getApplicationContext());
    }

    protected AbstractFrameworkAction buildOKAction(WorkbenchContext workbenchContext) {
        return new AbstractFrameworkAction(workbenchContext){

            protected void initialize() {
                this.initializeText("DIALOG.OK_BUTTON_TEXT");
            }

            protected void execute() {
                AboutDialog.this.dispose();
            }
        };
    }

    protected void initializeDefaultKeyboardActions() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", this.okAction);
    }

    void initializeContentPane(ApplicationContext applicationContext) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.buildMainPanel(applicationContext), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.getContentPane().add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel = this.buildButtonPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
    }

    private JPanel buildMainPanel(ApplicationContext applicationContext) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(applicationContext.getResourceRepository().getIcon("mw.about"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 30, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(applicationContext.getApplication().getProductName());
        jLabel2.setHorizontalAlignment(0);
        Font font = jLabel2.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize() + 5));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 50);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(applicationContext.getResourceRepository().getString("VERSION", applicationContext.getApplication().getVersionNumber()));
        jLabel3.setHorizontalAlignment(0);
        font = jLabel3.getFont();
        jLabel3.setFont(new Font(font.getName(), 1, font.getSize()));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 50);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel(applicationContext.getResourceRepository().getString("BUILD", applicationContext.getApplication().getBuildNumber()));
        jLabel4.setHorizontalAlignment(0);
        font = jLabel4.getFont();
        jLabel4.setFont(new Font(font.getName(), 1, font.getSize()));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 50);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        LabelArea labelArea = new LabelArea(applicationContext.getResourceRepository().getString("COPYRIGHT"));
        labelArea.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(30, 50, 0, 50);
        jPanel.add((Component)labelArea, gridBagConstraints);
        return jPanel;
    }

    JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(this.okAction);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    public void show() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        super.show();
    }
}

