/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.app.EditorNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

abstract class AbstractEditorView {
    private WorkbenchContext context;
    private ValueModel nodeHolder;
    EditorNode node;
    private PropertyChangeListener nodeListener;
    private Component propertiesPage;
    private JPanel panel;

    AbstractEditorView(ValueModel valueModel, WorkbenchContext workbenchContext) {
        if (valueModel == null) {
            throw new NullPointerException();
        }
        this.nodeHolder = valueModel;
        this.node = (EditorNode)this.nodeHolder.getValue();
        this.nodeListener = this.buildNodeListener();
        valueModel.addPropertyChangeListener("value", this.nodeListener);
        this.context = workbenchContext;
        this.propertiesPage = this.node.propertiesPage(null);
    }

    private PropertyChangeListener buildNodeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractEditorView.this.nodeChanged((EditorNode)propertyChangeEvent.getNewValue());
            }
        };
    }

    Component getComponent() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
            this.installNewPropertiesPage();
        }
        return this.panel;
    }

    ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    Component getPropertiesPage() {
        return this.propertiesPage;
    }

    private JPanel buildPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setMinimumSize(new Dimension(0, 0));
        JLabel jLabel = this.buildLabel();
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jPanel.getBackground().brighter()), BorderFactory.createMatteBorder(0, 0, 1, 0, jPanel.getBackground().darker())), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jLabel.setLabelFor(jPanel);
        jPanel.add((Component)jLabel, "First");
        return jPanel;
    }

    abstract JLabel buildLabel();

    void nodeChanged(EditorNode editorNode) {
        this.node.releasePropertiesPage(this.propertiesPage);
        this.node = editorNode;
        Component component = this.node.propertiesPage(this.context);
        if (component != this.propertiesPage) {
            this.panel.remove(this.propertiesPage);
            this.propertiesPage = component;
            this.installNewPropertiesPage();
        }
    }

    void installNewPropertiesPage() {
        this.panel.add(this.propertiesPage, "Center");
        if (this.panel.isVisible()) {
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    void close() {
        this.nodeHolder.removePropertyChangeListener("value", this.nodeListener);
    }
}

