/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.eclipse.persistence.tools.workbench.framework.AbstractApplication;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.PluginFactory;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpFacade;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManagerConfig;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkConsole;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkLogHandler;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkPreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkResourceBundle;
import org.eclipse.persistence.tools.workbench.framework.internal.GeneralPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesView;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepositoryWrapper;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.Console;
import org.eclipse.persistence.tools.workbench.uitools.RecentFilesManager;
import org.eclipse.persistence.tools.workbench.uitools.SplashScreen;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Command;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedObject;
import org.eclipse.persistence.tools.workbench.utility.io.InvalidInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.TeeOutputStream;
import org.eclipse.persistence.tools.workbench.utility.log.DeathHandler;
import org.eclipse.persistence.tools.workbench.utility.log.FileHandlerCleanup;

public final class FrameworkApplication
extends AbstractApplication {
    private SynchronizedBoolean launchCompleteFlag;
    private boolean developmentMode;
    private Logger logger;
    private Preferences rootPreferences;
    private FrameworkNodeManager nodeManager;
    private ResourceRepository resourceRepository;
    private SynchronizedObject synchronizedHelpManager;
    private ApplicationContext rootApplicationContext;
    private Plugin[] plugins;
    private Set workbenchWindows;
    private PreferencesView preferencesView;
    private boolean firstExecution;
    private Console frameworkConsole;
    private static final String SPLASH_SCREEN_FILE_NAME = "/logo/splash.screen.gif";
    private static final String SPLASH_SCREEN_ICON_FILE_NAME = "/logo/MappingWorkbench.large.gif";
    private static final String PREFERENCES_CURRENT_VERSION_NODE = "1.0";
    static final String GENERAL_PREFERENCES_NODE = "general";
    static final String DISPLAY_SPLASH_SCREEN_PREFERENCE = "display splash screen";
    static final boolean DISPLAY_SPLASH_SCREEN_PREFERENCE_DEFAULT = true;
    static final String LOOK_AND_FEEL_PREFERENCE = "look and feel";
    static final String HTTP_PROXY_HOST_PREFERENCE = "http proxy host";
    static final String HTTP_PROXY_HOST_PREFERENCE_DEFAULT = "";
    static final String HTTP_PROXY_PORT_PREFERENCE = "http proxy port";
    static final String HTTP_PROXY_PORT_PREFERENCE_DEFAULT = "80";
    static final String NETWORK_CONNECT_TIMEOUT_PREFERENCE = "network connect timeout";
    static final String NETWORK_CONNECT_TIMEOUT_PREFERENCE_DEFAULT = "10";
    static final String NETWORK_READ_TIMEOUT_PREFERENCE = "network read timeout";
    static final String NETWORK_READ_TIMEOUT_PREFERENCE_DEFAULT = "10";
    static final String REOPEN_PROJECTS_PREFERENCE = "reopen projects";
    static final boolean REOPEN_PROJECTS_PREFERENCE_DEFAULT = true;
    static final String DYNAMIC_LAYOUT_PREFERENCE = "dynamic layout";
    private static final PluginFactoryStaticMethodSpec[] PLUGIN_FACTORY_STATIC_METHOD_SPECS = new PluginFactoryStaticMethodSpec[]{new PluginFactoryStaticMethodSpec("org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginFactory", "instance"), new PluginFactoryStaticMethodSpec("org.eclipse.persistence.tools.workbench.scplugin.SCPluginFactory", "instance"), new PluginFactoryStaticMethodSpec("org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPluginFactory", "instance")};

    public static void launch(Logger logger, Preferences preferences, File file, boolean bl) {
        boolean bl2 = FrameworkApplication.buildFirstExecution(preferences, logger);
        boolean bl3 = FrameworkApplication.buildDisplaySplashScreen(preferences);
        Handler handler = null;
        SplashScreen splashScreen = null;
        if (bl3) {
            handler = FrameworkApplication.buildDeathHandler();
            logger.addHandler(handler);
            splashScreen = FrameworkApplication.buildSplashScreen();
            splashScreen.start();
        }
        new FrameworkApplication(logger, preferences, bl2, bl).launch(file);
        if (bl3) {
            splashScreen.stop();
            logger.removeHandler(handler);
        }
    }

    private static SplashScreen buildSplashScreen() {
        JFrame jFrame = new JFrame("EclipseLink Workbench");
        Icon icon = FrameworkApplication.getIcon(SPLASH_SCREEN_ICON_FILE_NAME);
        if (icon instanceof ImageIcon) {
            jFrame.setIconImage(((ImageIcon)icon).getImage());
        }
        return new SplashScreen(jFrame, FrameworkApplication.getIcon(SPLASH_SCREEN_FILE_NAME));
    }

    private static Handler buildDeathHandler() {
        DeathHandler deathHandler = new DeathHandler(5000, 1);
        deathHandler.setLevel(Level.SEVERE);
        return deathHandler;
    }

    private static boolean buildFirstExecution(Preferences preferences, Logger logger) {
        try {
            return !CollectionTools.contains((Object[])preferences.childrenNames(), (Object)PREFERENCES_CURRENT_VERSION_NODE);
        }
        catch (BackingStoreException backingStoreException) {
            logger.log(Level.WARNING, HTTP_PROXY_HOST_PREFERENCE_DEFAULT, backingStoreException);
            return true;
        }
    }

    private static boolean buildDisplaySplashScreen(Preferences preferences) {
        return preferences.node(PREFERENCES_CURRENT_VERSION_NODE).node(GENERAL_PREFERENCES_NODE).getBoolean(DISPLAY_SPLASH_SCREEN_PREFERENCE, true);
    }

    public static String getResourceBundleName() {
        return FrameworkResourceBundle.class.getName();
    }

    private static Icon getIcon(String string) {
        return new ImageIcon(FrameworkApplication.getResource(string));
    }

    private static URL getResource(String string) {
        return FrameworkApplication.class.getResource(string);
    }

    private FrameworkApplication(Logger logger, Preferences preferences, boolean bl, boolean bl2) {
        this.firstExecution = bl;
        this.logger = logger;
        this.developmentMode = bl2;
        this.initialize(preferences);
    }

    private void initialize(Preferences preferences) {
        this.launchCompleteFlag = new SynchronizedBoolean(false);
        this.rootPreferences = preferences.node(PREFERENCES_CURRENT_VERSION_NODE);
        this.configureLoggerForLaunch();
        this.initializeLookAndFeel();
        this.initializeNetworkSettings();
        this.nodeManager = this.buildNodeManager();
        this.resourceRepository = this.buildResourceRepository();
        this.startInitializeSynchronizedHelpManager();
        this.rootApplicationContext = new RootApplicationContext();
        this.plugins = this.buildPlugins(PLUGIN_FACTORY_STATIC_METHOD_SPECS);
        this.initializeWorkbenchWindows();
        Toolkit.getDefaultToolkit().setDynamicLayout(this.generalPreferences().getBoolean(DYNAMIC_LAYOUT_PREFERENCE, true));
    }

    private void configureLoggerForLaunch() {
        FileHandler fileHandler;
        try {
            fileHandler = new FileHandler(System.getProperty("user.home") + "/org.eclipse.persistence.tools.workbench.log", 50000, 1, true);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        FileHandlerCleanup.register((FileHandler)fileHandler);
        fileHandler.setFormatter(new SimpleFormatter());
        this.logger.addHandler(fileHandler);
    }

    private void initializeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(this.lookAndFeel());
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception2) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception3) {
                    throw new RuntimeException(exception3);
                }
            }
        }
    }

    private String lookAndFeel() {
        String string = this.generalPreferences().get(LOOK_AND_FEEL_PREFERENCE, this.defaultLookAndFeel());
        return string;
    }

    private String defaultLookAndFeel() {
        return System.getProperty("os.name", HTTP_PROXY_HOST_PREFERENCE_DEFAULT).toLowerCase().indexOf("linux") != -1 ? UIManager.getCrossPlatformLookAndFeelClassName() : UIManager.getSystemLookAndFeelClassName();
    }

    private void initializeNetworkSettings() {
        String string;
        String string2 = this.generalPreferences().get(HTTP_PROXY_HOST_PREFERENCE, null);
        if (string2 != null) {
            System.setProperty("http.proxyHost", string2);
        }
        if ((string = this.generalPreferences().get(HTTP_PROXY_PORT_PREFERENCE, null)) != null) {
            System.setProperty("http.proxyPort", string);
        }
        String string3 = this.generalPreferences().get(NETWORK_CONNECT_TIMEOUT_PREFERENCE, "10");
        string3 = String.valueOf(Integer.parseInt(string3) * 1000);
        System.setProperty("sun.net.client.defaultConnectTimeout", string3);
        String string4 = this.generalPreferences().get(NETWORK_READ_TIMEOUT_PREFERENCE, "10");
        string4 = String.valueOf(Integer.parseInt(string4) * 1000);
        System.setProperty("sun.net.client.defaultReadTimeout", string4);
        this.generalPreferences().addPreferenceChangeListener(this.buildNetworkSettingsListener());
    }

    private PreferenceChangeListener buildNetworkSettingsListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                String string = preferenceChangeEvent.getKey();
                if (string.equals(FrameworkApplication.HTTP_PROXY_HOST_PREFERENCE)) {
                    System.setProperty("http.proxyHost", preferenceChangeEvent.getNewValue());
                } else if (string.equals(FrameworkApplication.HTTP_PROXY_PORT_PREFERENCE)) {
                    System.setProperty("http.proxyPort", preferenceChangeEvent.getNewValue());
                } else if (string.equals(FrameworkApplication.NETWORK_CONNECT_TIMEOUT_PREFERENCE)) {
                    System.setProperty("sun.net.client.defaultConnectTimeout", preferenceChangeEvent.getNewValue());
                } else if (string.equals(FrameworkApplication.NETWORK_READ_TIMEOUT_PREFERENCE)) {
                    System.setProperty("sun.net.client.defaultReadTimeout", preferenceChangeEvent.getNewValue());
                }
            }
        };
    }

    private FrameworkNodeManager buildNodeManager() {
        return new FrameworkNodeManager(this);
    }

    private ResourceRepository buildResourceRepository() {
        DefaultResourceRepository defaultResourceRepository = new DefaultResourceRepository(UIToolsResourceBundle.class, new UIToolsIconResourceFileNameMap());
        return new ResourceRepositoryWrapper(defaultResourceRepository, FrameworkResourceBundle.class, new FrameworkIconResourceFileNameMap());
    }

    private void startInitializeSynchronizedHelpManager() {
        this.synchronizedHelpManager = new SynchronizedObject();
        new Thread(this.buildInitializeSynchronizedHelpManagerRunnable(), "Initialize Help").start();
    }

    private Runnable buildInitializeSynchronizedHelpManagerRunnable() {
        return new Runnable(){

            public void run() {
                FrameworkApplication.this.initializeSynchronizedHelpManager();
            }
        };
    }

    void initializeSynchronizedHelpManager() {
        try {
            this.synchronizedHelpManager.execute(this.buildInitializeHelpManagerCommand());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private Command buildInitializeHelpManagerCommand() {
        return new Command(){

            public void execute() {
                FrameworkApplication.this.initializeHelpManager();
            }
        };
    }

    void initializeHelpManager() {
        HelpManagerConfig helpManagerConfig = new HelpManagerConfig();
        helpManagerConfig.setPreferences(this.generalPreferences());
        helpManagerConfig.setResourceRepository(this.resourceRepository);
        helpManagerConfig.setLogger(this.logger);
        helpManagerConfig.setDevelopmentMode(this.isDevelopmentMode());
        helpManagerConfig.setLaunchCompleteFlag(this.launchCompleteFlag);
        helpManagerConfig.setForceStupidWelcomeScreen(this.isFirstExecution());
        this.synchronizedHelpManager.setValue((Object)HelpFacade.buildHelpManager(helpManagerConfig));
    }

    private Plugin[] buildPlugins(PluginFactoryStaticMethodSpec[] pluginFactoryStaticMethodSpecArray) {
        int n = pluginFactoryStaticMethodSpecArray.length;
        Plugin[] pluginArray = new Plugin[n];
        for (int i = 0; i < n; ++i) {
            pluginArray[i] = this.buildPlugin(pluginFactoryStaticMethodSpecArray[i]);
        }
        return pluginArray;
    }

    private Plugin buildPlugin(PluginFactoryStaticMethodSpec pluginFactoryStaticMethodSpec) {
        Class<?> clazz;
        try {
            clazz = Class.forName(pluginFactoryStaticMethodSpec.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        PluginFactory pluginFactory = (PluginFactory)ClassTools.invokeStaticMethod(clazz, (String)pluginFactoryStaticMethodSpec.getStaticMethodName());
        return pluginFactory.createPlugin(this.rootApplicationContext);
    }

    private void initializeWorkbenchWindows() {
        this.workbenchWindows = new HashSet();
        int n = this.generalPreferences().node("windows").getInt("count", 1);
        for (int i = 0; i < n; ++i) {
            WorkbenchWindow workbenchWindow = new WorkbenchWindow(this);
            workbenchWindow.restoreState(this.generalPreferences().node("windows").node("window" + i));
            this.workbenchWindows.add(workbenchWindow);
        }
    }

    Logger getLogger() {
        return this.logger;
    }

    Preferences getRootPreferences() {
        return this.rootPreferences;
    }

    FrameworkNodeManager getNodeManager() {
        return this.nodeManager;
    }

    PreferencesView getPreferencesView() {
        if (this.preferencesView == null) {
            BufferedPropertyValueModel.Trigger trigger = new BufferedPropertyValueModel.Trigger();
            FrameworkPreferencesContext frameworkPreferencesContext = new FrameworkPreferencesContext(this, trigger);
            this.preferencesView = new PreferencesView(this.buildRootPreferencesNode(frameworkPreferencesContext), trigger);
        }
        return this.preferencesView;
    }

    ResourceRepository getResourceRepository() {
        return this.resourceRepository;
    }

    ApplicationContext getRootApplicationContext() {
        return this.rootApplicationContext;
    }

    Plugin[] getPlugins() {
        return this.plugins;
    }

    RecentFilesManager recentFilesManager() {
        return this.nodeManager.getRecentFilesManager();
    }

    Preferences generalPreferences() {
        return this.rootPreferences.node(GENERAL_PREFERENCES_NODE);
    }

    private void launch(File file) {
        int n = 0;
        WorkbenchWindow workbenchWindow2 = null;
        for (WorkbenchWindow workbenchWindow2 : this.workbenchWindows) {
            workbenchWindow2.setVisible(true);
            ++n;
        }
        if (file != null) {
            this.nodeManager.open(file, workbenchWindow2.getContext());
        } else if (this.generalPreferences().getBoolean(REOPEN_PROJECTS_PREFERENCE, true)) {
            this.nodeManager.restoreProjectsState(workbenchWindow2, this.generalPreferences().node("windows").node("window" + n));
        }
        this.redirectSystemStreams();
        this.configureLoggerForExecution();
        this.launchCompleteFlag.setTrue();
    }

    private void redirectSystemStreams() {
        System.setIn(InvalidInputStream.instance());
        if (this.isDevelopmentMode()) {
            this.frameworkConsole = new Console();
            System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)System.out, this.frameworkConsole.getOutStream())));
            System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)System.err, this.frameworkConsole.getErrStream())));
        } else {
            this.frameworkConsole = new FrameworkConsole(this.getRootApplicationContext());
            System.setOut(new PrintStream(this.frameworkConsole.getOutStream()));
            System.setErr(new PrintStream(this.frameworkConsole.getErrStream()));
        }
    }

    private void configureLoggerForExecution() {
        this.logger.setUseParentHandlers(false);
        if (this.isDevelopmentMode()) {
            this.logger.addHandler(new ConsoleHandler());
        } else {
            this.logger.addHandler(new FrameworkLogHandler(this, Level.SEVERE));
        }
    }

    ApplicationNode open(File file, WorkbenchContext workbenchContext) throws UnsupportedFileException, OpenException {
        for (int i = 0; i < this.plugins.length; ++i) {
            try {
                return this.plugins[i].open(file, workbenchContext);
            }
            catch (UnsupportedFileException unsupportedFileException) {
                continue;
            }
        }
        throw new UnsupportedFileException("could not find plug-in support for file: " + file);
    }

    void openNewWindow(WorkbenchWindow workbenchWindow) {
        WorkbenchWindow workbenchWindow2 = new WorkbenchWindow(this, workbenchWindow);
        this.workbenchWindows.add(workbenchWindow2);
        workbenchWindow2.setVisible(true);
    }

    void openDevelopmentConsole() {
        if (this.frameworkConsole == null) {
            throw new IllegalStateException("This operation is only supported in \"development\" mode.");
        }
        this.frameworkConsole.open();
    }

    private AbstractPreferencesNode buildRootPreferencesNode(PreferencesContext preferencesContext) {
        RootPreferencesNode rootPreferencesNode = new RootPreferencesNode(preferencesContext);
        int n = 0;
        rootPreferencesNode.insert(new GeneralPreferencesNode(preferencesContext), n++);
        for (int i = 0; i < this.plugins.length; ++i) {
            PreferencesNode[] preferencesNodeArray = this.plugins[i].buildPreferencesNodes(preferencesContext);
            for (int j = 0; j < preferencesNodeArray.length; ++j) {
                rootPreferencesNode.insert(preferencesNodeArray[j], n++);
            }
        }
        return rootPreferencesNode;
    }

    void close(WorkbenchWindow workbenchWindow) {
        if (this.workbenchWindows.size() == 1) {
            if (this.workbenchWindows.iterator().next() != workbenchWindow) {
                throw new IllegalStateException("unknown window: " + workbenchWindow);
            }
            this.nodeManager.exit(workbenchWindow.getContext());
        } else {
            if (!this.workbenchWindows.remove(workbenchWindow)) {
                throw new IllegalStateException("unknown window: " + workbenchWindow);
            }
            workbenchWindow.dispose();
        }
    }

    void exit() {
        this.saveWindowsState();
        Iterator iterator = this.workbenchWindows.iterator();
        while (iterator.hasNext()) {
            ((WorkbenchWindow)iterator.next()).dispose();
        }
        this.shutDown();
    }

    private void saveWindowsState() {
        Preferences preferences = this.generalPreferences().node("windows");
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        preferences.putInt("count", this.workbenchWindows.size());
        int n = 0;
        for (WorkbenchWindow workbenchWindow : this.workbenchWindows) {
            workbenchWindow.saveState(preferences.node("window" + n));
            workbenchWindow.dispose();
            ++n;
        }
    }

    protected void saveTreeExpansionStates() {
        Preferences preferences = this.generalPreferences().node("windows");
        int n = 0;
        for (WorkbenchWindow workbenchWindow : this.workbenchWindows) {
            workbenchWindow.saveTreeExpansionState(preferences.node("window" + n));
            ++n;
        }
    }

    private void shutDown() {
        this.getHelpManager().shutDown();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                System.exit(0);
            }

            public String toString() {
                return "runnable shutdown";
            }
        });
    }

    HelpManager getHelpManager() {
        try {
            this.synchronizedHelpManager.waitUntilNotNull();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return (HelpManager)this.synchronizedHelpManager.getValue();
    }

    public boolean isFirstExecution() {
        return this.firstExecution;
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode || super.isDevelopmentMode();
    }

    public String defaultSpecificationTitle() {
        return "EclipseLink Workbench";
    }

    public String defaultSpecificationVendor() {
        return HTTP_PROXY_HOST_PREFERENCE_DEFAULT;
    }

    public String defaultReleaseDesignation() {
        return "Version 1.0.0";
    }

    public String defaultLibraryDesignation() {
        return "Workbench";
    }

    public String defaultSpecificationVersion() {
        return "1.0.0";
    }

    public String defaultImplementationVersion() {
        return this.defaultSpecificationVersion();
    }

    private static final class RootPreferencesNode
    extends AbstractPreferencesNode {
        RootPreferencesNode(PreferencesContext preferencesContext) {
            super(preferencesContext);
        }

        protected Component buildPropertiesPage() {
            return null;
        }

        protected String buildDisplayString() {
            return null;
        }
    }

    private static class PluginFactoryStaticMethodSpec {
        private String className;
        private String staticMethodName;

        PluginFactoryStaticMethodSpec(String string, String string2) {
            this.className = string;
            this.staticMethodName = string2;
        }

        String getClassName() {
            return this.className;
        }

        String getStaticMethodName() {
            return this.staticMethodName;
        }
    }

    private class RootApplicationContext
    extends AbstractApplicationContext {
        private RootApplicationContext() {
        }

        public Application getApplication() {
            return FrameworkApplication.this;
        }

        public HelpManager getHelpManager() {
            return FrameworkApplication.this.getHelpManager();
        }

        public NodeManager getNodeManager() {
            return FrameworkApplication.this.getNodeManager();
        }

        public Preferences getPreferences() {
            return FrameworkApplication.this.getRootPreferences();
        }

        public ResourceRepository getResourceRepository() {
            return FrameworkApplication.this.getResourceRepository();
        }
    }
}

