/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.Console;

public class FrameworkConsole
extends Console {
    private ApplicationContext appContext;

    public FrameworkConsole(ApplicationContext applicationContext) {
        this.initialize(applicationContext);
    }

    protected void initialize() {
        if (this.appContext != null) {
            super.initialize();
        }
    }

    private void initialize(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
        this.initialize();
    }

    protected JPanel buildMainPanel() {
        JPanel jPanel = super.buildMainPanel();
        jPanel.add(this.buildErrorLabel(), "First");
        return jPanel;
    }

    private Component buildErrorLabel() {
        JLabel jLabel = new JLabel(this.resourceRepository().getString("UNEXPECTED_OUTPUT_ERROR_MESSAGE"));
        jLabel.setIcon(this.resourceRepository().getIcon("error.large"));
        return jLabel;
    }

    protected Component buildControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(this.buildHelpButton(), "Before");
        jPanel2.add(this.buildOKButton(), "After");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private Component buildHelpButton() {
        return new JButton(this.buildHelpAction());
    }

    private Action buildHelpAction() {
        AbstractAction abstractAction = new AbstractAction(this.resourceRepository().getString("DIALOG.HELP_BUTTON_TEXT")){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameworkConsole.this.helpManager().showTopic(FrameworkConsole.this.helpTopicId());
            }
        };
        abstractAction.setEnabled(true);
        return abstractAction;
    }

    private Component buildOKButton() {
        return new JButton(this.buildOKAction());
    }

    private Action buildOKAction() {
        AbstractAction abstractAction = new AbstractAction(this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT")){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameworkConsole.this.clear();
                FrameworkConsole.this.hide();
            }
        };
        abstractAction.setEnabled(true);
        return abstractAction;
    }

    private ResourceRepository resourceRepository() {
        return this.appContext.getResourceRepository();
    }

    HelpManager helpManager() {
        return this.appContext.getHelpManager();
    }

    String helpTopicId() {
        return "dialog.unexpected.output";
    }

    protected String title() {
        return this.resourceRepository().getString("UNEXPECTED_OUTPUT_LOG_TITLE");
    }
}

