/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkRootNode;
import org.eclipse.persistence.tools.workbench.framework.internal.RunnableProjectLoader;
import org.eclipse.persistence.tools.workbench.framework.internal.SaveModifiedProjectsDialog;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.PreferencesRecentFilesManager;
import org.eclipse.persistence.tools.workbench.uitools.RecentFilesManager;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.events.AWTChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.PluggableValidator;
import org.eclipse.persistence.tools.workbench.utility.node.RunnableValidation;

final class FrameworkNodeManager
extends AbstractNodeModel
implements NodeManager {
    private FrameworkApplication application;
    private TreeNodeValueModel rootNode;
    private Collection projectNodes;
    public static final String PROJECT_NODES_COLLECTION = "projectNodes";
    private Map validationThreads;
    private Map continueValidationThreadFlags;
    private Collection synchronousProjectNodes;
    private boolean projectNodesAreAddedWithSynchronousValidators;
    private RecentFilesManager recentFilesManager;
    private static final String RECENT_FILES_PREFERENCES_NODE = "recent files";
    static final String RECENT_FILES_MAX_SIZE_PREFERENCE = "recent files max size";
    static final int RECENT_FILES_MAX_SIZE_PREFERENCE_DEFAULT = 4;
    private static final String MOST_RECENT_SAVE_LOCATION_PREFERENCE = "recent save location";
    private static final String MOST_RECENT_SAVE_LOCATION_PREFERENCE_DEFAULT = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();

    FrameworkNodeManager(FrameworkApplication frameworkApplication) {
        super(null);
        this.application = frameworkApplication;
        this.recentFilesManager = this.buildRecentFilesManager();
    }

    protected void initialize() {
        super.initialize();
        this.rootNode = new FrameworkRootNode(this);
        this.projectNodes = new ArrayList();
        this.validationThreads = new HashMap();
        this.continueValidationThreadFlags = new HashMap();
        this.synchronousProjectNodes = new HashBag();
        this.projectNodesAreAddedWithSynchronousValidators = false;
    }

    private RecentFilesManager buildRecentFilesManager() {
        Preferences preferences = this.application.generalPreferences();
        Preferences preferences2 = preferences.node(RECENT_FILES_PREFERENCES_NODE);
        return new PreferencesRecentFilesManager(preferences2, preferences, RECENT_FILES_MAX_SIZE_PREFERENCE);
    }

    protected void checkParent(Node node) {
        if (node != null) {
            throw new IllegalArgumentException(ClassTools.shortClassNameForObject((Object)this) + " should not have a parent");
        }
    }

    public void addProjectNode(ApplicationNode applicationNode) {
        this.addItemToCollection(applicationNode, this.projectNodes, PROJECT_NODES_COLLECTION);
        ((Node)applicationNode.getValue()).setChangeNotifier(AWTChangeNotifier.instance());
        if (this.projectNodesAreAddedWithSynchronousValidators) {
            this.installSynchronousValidatorOn(applicationNode);
        } else {
            this.installAsynchronousValidatorOn(applicationNode);
        }
    }

    private void installAsynchronousValidatorOn(ApplicationNode applicationNode) {
        Node node = (Node)applicationNode.getValue();
        SynchronizedBoolean synchronizedBoolean = new SynchronizedBoolean(true);
        node.setValidator(PluggableValidator.buildAsynchronousValidator((SynchronizedBoolean)synchronizedBoolean));
        SynchronizedBoolean synchronizedBoolean2 = new SynchronizedBoolean(true);
        this.continueValidationThreadFlags.put(applicationNode, synchronizedBoolean2);
        Thread thread = new Thread((Runnable)new RunnableValidation(node, synchronizedBoolean, synchronizedBoolean2, this.logger(), Level.WARNING, "VALIDATION_EXCEPTION"), "Validation Thread : " + node.displayString());
        thread.setPriority(1);
        this.validationThreads.put(applicationNode, thread);
        thread.start();
    }

    private void installSynchronousValidatorOn(ApplicationNode applicationNode) {
        Node node = (Node)applicationNode.getValue();
        node.setValidator(PluggableValidator.buildSynchronousValidator((Node)node));
        this.synchronousProjectNodes.add(applicationNode);
    }

    public void removeProjectNode(ApplicationNode applicationNode) {
        this.removeItemFromCollection(applicationNode, this.projectNodes, PROJECT_NODES_COLLECTION);
        if (!this.synchronousProjectNodes.remove(applicationNode)) {
            SynchronizedBoolean synchronizedBoolean = (SynchronizedBoolean)this.continueValidationThreadFlags.remove(applicationNode);
            synchronizedBoolean.setFalse();
            Thread thread = (Thread)this.validationThreads.remove(applicationNode);
            thread.interrupt();
        }
    }

    public ApplicationNode[] projectNodesFor(Plugin plugin) {
        ArrayList<ApplicationNode> arrayList = new ArrayList<ApplicationNode>();
        Iterator iterator = this.projectNodes();
        while (iterator.hasNext()) {
            ApplicationNode applicationNode = (ApplicationNode)iterator.next();
            if (applicationNode.getPlugin() != plugin) continue;
            arrayList.add(applicationNode);
        }
        return arrayList.toArray(new ApplicationNode[arrayList.size()]);
    }

    public TreeNodeValueModel getRootNode() {
        return this.rootNode;
    }

    public String displayString() {
        return null;
    }

    public ChangeNotifier getChangeNotifier() {
        return DefaultChangeNotifier.instance();
    }

    public Node.Validator getValidator() {
        return Node.NULL_VALIDATOR;
    }

    Iterator projectNodes() {
        return this.projectNodes.iterator();
    }

    int projectNodesSize() {
        return this.projectNodes.size();
    }

    RecentFilesManager getRecentFilesManager() {
        return this.recentFilesManager;
    }

    boolean projectNodesAreAddedWithSynchronousValidators() {
        return this.projectNodesAreAddedWithSynchronousValidators;
    }

    boolean toggleAddProjectNodesWithSynchronousValidators() {
        this.projectNodesAreAddedWithSynchronousValidators = !this.projectNodesAreAddedWithSynchronousValidators;
        return this.projectNodesAreAddedWithSynchronousValidators;
    }

    private Logger logger() {
        return this.application.getLogger();
    }

    void open(File file, WorkbenchContext workbenchContext) {
        ApplicationNode applicationNode = this.projectNodeFor(file);
        if (applicationNode == null) {
            this.openNew(file, workbenchContext);
            return;
        }
        if (applicationNode.isDirty() && this.userWantsToRevert(file, workbenchContext)) {
            workbenchContext.getNavigatorSelectionModel().pushExpansionState();
            this.removeProjectNode(applicationNode);
            this.openNew(file, workbenchContext);
            workbenchContext.getNavigatorSelectionModel().popAndRestoreExpansionState();
        } else {
            workbenchContext.getNavigatorSelectionModel().setSelectedNode(applicationNode);
        }
    }

    private ApplicationNode projectNodeFor(File file) {
        Iterator iterator = this.projectNodes();
        while (iterator.hasNext()) {
            ApplicationNode applicationNode = (ApplicationNode)iterator.next();
            File file2 = applicationNode.saveFile();
            if (file2 == null || !file2.equals(file)) continue;
            return applicationNode;
        }
        return null;
    }

    private void openNew(File file, WorkbenchContext workbenchContext) {
        Thread thread = new Thread((Runnable)new RunnableProjectLoader(this, file, workbenchContext), "Project Loader");
        thread.setPriority(5);
        thread.start();
    }

    synchronized ApplicationNode openCallback(File file, WorkbenchContext workbenchContext) throws UnsupportedFileException, OpenException {
        return this.application.open(file, workbenchContext);
    }

    void addProjectNodeCallback(ApplicationNode applicationNode, File file, WorkbenchContext workbenchContext) {
        this.addProjectNode(applicationNode);
        workbenchContext.getNavigatorSelectionModel().expandNode(applicationNode);
        workbenchContext.getNavigatorSelectionModel().setSelectedNode(applicationNode);
        this.recentFilesManager.setMostRecentFile(file);
    }

    private boolean userWantsToRevert(File file, WorkbenchContext workbenchContext) {
        int n = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), workbenchContext.getApplicationContext().getResourceRepository().getString("REVERT_TO_SAVED.message", file), workbenchContext.getApplicationContext().getResourceRepository().getString("REVERT_TO_SAVED.title"), 0);
        return n == 0;
    }

    void exit(WorkbenchContext workbenchContext) {
        ArrayList arrayList = new ArrayList(this.projectNodes);
        this.application.saveTreeExpansionStates();
        if (this.closeAll(workbenchContext)) {
            this.saveProjectsState(arrayList.iterator());
            arrayList = null;
            this.application.exit();
        }
    }

    private void saveProjectsState(Iterator iterator) {
        Preferences preferences = this.application.generalPreferences().node("projects");
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int n = 0;
        while (iterator.hasNext()) {
            ApplicationNode applicationNode = (ApplicationNode)iterator.next();
            if (applicationNode.saveFile() == null) continue;
            preferences.put(String.valueOf(n++), applicationNode.saveFile().getAbsolutePath());
        }
    }

    protected void restoreProjectsState(WorkbenchWindow workbenchWindow, Preferences preferences) {
        String[] stringArray;
        Preferences preferences2 = this.application.generalPreferences().node("projects");
        try {
            stringArray = preferences2.keys();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            String string = preferences2.get(stringArray[i], null);
            if (string == null || !(file = new File(string)).exists()) continue;
            this.open(file, workbenchWindow.getContext());
        }
        workbenchWindow.restoreTreeExpansionState(preferences);
    }

    boolean closeAll(WorkbenchContext workbenchContext) {
        return this.close(this.projectNodes.toArray(new ApplicationNode[this.projectNodes.size()]), workbenchContext);
    }

    boolean close(ApplicationNode[] applicationNodeArray, WorkbenchContext workbenchContext) {
        Collection collection;
        try {
            collection = this.promptToSave(this.dirtyNodesFrom(applicationNodeArray), workbenchContext);
        }
        catch (CancelException cancelException) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.save((ApplicationNode)iterator.next(), workbenchContext)) continue;
            return false;
        }
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            this.removeProjectNode(applicationNodeArray[n]);
        }
        return true;
    }

    private Collection dirtyNodesFrom(ApplicationNode[] applicationNodeArray) {
        ArrayList<ApplicationNode> arrayList = new ArrayList<ApplicationNode>(applicationNodeArray.length);
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            ApplicationNode applicationNode = applicationNodeArray[n];
            if (!applicationNode.isDirty()) continue;
            arrayList.add(applicationNode);
        }
        return arrayList;
    }

    private Collection promptToSave(Collection collection, WorkbenchContext workbenchContext) {
        if (collection.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        SaveModifiedProjectsDialog saveModifiedProjectsDialog = new SaveModifiedProjectsDialog(workbenchContext, collection);
        saveModifiedProjectsDialog.show();
        if (saveModifiedProjectsDialog.wasCanceled()) {
            throw new CancelException();
        }
        return saveModifiedProjectsDialog.selectedNodes();
    }

    public boolean save(ApplicationNode applicationNode, WorkbenchContext workbenchContext) {
        boolean bl = applicationNode.save(this.getMostRecentSaveDirectory(), workbenchContext);
        if (bl) {
            this.recentFilesManager.setMostRecentFile(applicationNode.getProjectRoot().saveFile());
            this.setMostRecentSaveDirectory(applicationNode.getProjectRoot().saveFile());
        }
        return bl;
    }

    private File getMostRecentSaveDirectory() {
        return new File(this.application.generalPreferences().get(MOST_RECENT_SAVE_LOCATION_PREFERENCE, MOST_RECENT_SAVE_LOCATION_PREFERENCE_DEFAULT));
    }

    private void setMostRecentSaveDirectory(File file) {
        this.application.generalPreferences().put(MOST_RECENT_SAVE_LOCATION_PREFERENCE, file.getParentFile().getAbsolutePath());
    }

    boolean saveAs(ApplicationNode applicationNode, WorkbenchContext workbenchContext) {
        boolean bl = applicationNode.saveAs(this.getMostRecentSaveDirectory(), workbenchContext);
        if (bl) {
            this.recentFilesManager.setMostRecentFile(applicationNode.getProjectRoot().saveFile());
            this.setMostRecentSaveDirectory(applicationNode.getProjectRoot().saveFile());
        }
        return bl;
    }

    void saveAll(WorkbenchContext workbenchContext) {
        Iterator iterator = this.projectNodes();
        while (iterator.hasNext()) {
            ApplicationNode applicationNode = (ApplicationNode)iterator.next();
            if (!applicationNode.isDirty()) continue;
            this.save(applicationNode, workbenchContext);
        }
    }
}

