/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;

final class JavaHeapInformationAction
extends AbstractFrameworkAction {
    private JLabel totalMemoryLabel;
    private JLabel freeMemoryLabel;
    private JLabel maxMemoryLabel;
    private static final int MB = 0x100000;

    JavaHeapInformationAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("JAVA_HEAP_INFO");
    }

    protected void execute() {
        this.totalMemoryLabel = new JLabel();
        this.freeMemoryLabel = new JLabel();
        this.maxMemoryLabel = new JLabel();
        this.refreshLabels();
        JOptionPane.showMessageDialog(this.currentWindow(), this.buildPanel(), this.resourceRepository().getString("JAVA_HEAP_INFO"), 1);
    }

    private Object buildPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.totalMemoryLabel);
        jPanel.add(this.freeMemoryLabel);
        jPanel.add(this.maxMemoryLabel);
        jPanel.add(this.buildGCButton());
        return jPanel;
    }

    private void refreshLabels() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.totalMemoryLabel.setText("Current Heap Size: " + numberFormat.format(runtime.totalMemory() / 0x100000L) + " MB");
        this.freeMemoryLabel.setText("Available Heap Space: " + numberFormat.format(runtime.freeMemory() / 0x100000L) + " MB");
        this.maxMemoryLabel.setText("Max Heap Size: " + numberFormat.format(runtime.maxMemory() / 0x100000L) + " MB");
    }

    private JButton buildGCButton() {
        return new JButton(this.buildGCAction());
    }

    private Action buildGCAction() {
        AbstractAction abstractAction = new AbstractAction("Collect Garbage"){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHeapInformationAction.this.gc();
            }
        };
        abstractAction.setEnabled(true);
        return abstractAction;
    }

    void gc() {
        System.gc();
        this.refreshLabels();
    }
}

