/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblemContainer;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemListListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemStateListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class MultiSelectionPseudoNode
extends AbstractApplicationNode {
    private SimpleListValueModel selectedNodesHolder;
    private LocalPropertiesPage propertiesPage;

    MultiSelectionPseudoNode(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.selectedNodesHolder = new SimpleListValueModel();
        ItemListListValueModelAdapter itemListListValueModelAdapter = new ItemListListValueModelAdapter((ListValueModel)this.selectedNodesHolder, "branchApplicationProblems");
        itemListListValueModelAdapter.addListChangeListener("value", this.buildBranchApplicationProblemsListener());
    }

    private ListChangeListener buildBranchApplicationProblemsListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                MultiSelectionPseudoNode.this.branchProblemsChanged();
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                MultiSelectionPseudoNode.this.branchProblemsChanged();
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                MultiSelectionPseudoNode.this.branchProblemsChanged();
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                MultiSelectionPseudoNode.this.branchProblemsChanged();
            }

            public String toString() {
                return StringTools.buildToStringFor((Object)this, (Object)"branch app problems listener");
            }
        };
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    protected String buildDisplayString() {
        return this.resourceRepository().getString("MULTI_SELECTION_DISPLAY_STRING");
    }

    protected IconBuilder buildIconBuilder() {
        return IconBuilder.NULL_INSTANCE;
    }

    protected boolean buildDirtyFlag() {
        return false;
    }

    protected void branchProblemsChanged() {
        super.branchProblemsChanged();
    }

    protected void addExclusiveApplicationProblemsTo(List list) {
        Iterator iterator = this.selectedNodes();
        while (iterator.hasNext()) {
            ((ApplicationProblemContainer)iterator.next()).addApplicationProblemsTo(list);
        }
    }

    public void addBranchApplicationProblemsTo(List list) {
        Iterator iterator = this.selectedNodes();
        while (iterator.hasNext()) {
            ((ApplicationProblemContainer)iterator.next()).addBranchApplicationProblemsTo(list);
        }
    }

    public boolean containsBranchApplicationProblemFor(Problem problem) {
        throw new UnsupportedOperationException();
    }

    public void printBranchApplicationProblemsOn(IndentingPrintWriter indentingPrintWriter) {
        if (this.branchApplicationProblemsSize() == 0) {
            return;
        }
        Iterator iterator = this.selectedNodes();
        while (iterator.hasNext()) {
            ((ApplicationProblemContainer)iterator.next()).printBranchApplicationProblemsOn(indentingPrintWriter);
        }
    }

    protected void engageValueBranchProblems() {
    }

    protected void disengageValueBranchProblems() {
    }

    protected void engageValuePropertiesPageTitleIcon() {
        this.rebuildPropertiesPageTitleIconBuilder();
        this.rebuildPropertiesPageTitleIcon();
    }

    protected void disengageValuePropertiesPageTitleIcon() {
    }

    protected void engageValuePropertiesPageTitleText() {
        this.rebuildPropertiesPageTitleText();
    }

    protected void disengageValuePropertiesPageTitleText() {
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        throw new UnsupportedOperationException();
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        throw new UnsupportedOperationException();
    }

    public Component propertiesPage(WorkbenchContext workbenchContext) {
        if (this.propertiesPage == null) {
            WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
            this.propertiesPage = new LocalPropertiesPage(workbenchContext2);
            this.propertiesPage.setNode(this, workbenchContext2);
        }
        return this.propertiesPage;
    }

    public void releasePropertiesPage(Component component) {
    }

    void setSelectedNodes(ApplicationNode[] applicationNodeArray) {
        this.selectedNodesHolder.clear();
        this.selectedNodesHolder.addItems(0, Arrays.asList(applicationNodeArray));
    }

    ListValueModel getSelectedNodesHolder() {
        return this.selectedNodesHolder;
    }

    private Iterator selectedNodes() {
        return (Iterator)this.selectedNodesHolder.getValue();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("[multiple nodes]");
    }

    private class LocalPropertiesPage
    extends TitledPropertiesPage {
        LocalPropertiesPage(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected Component buildPage() {
            JList jList = SwingComponentFactory.buildList(this.buildSelectedNodesListModel());
            jList.setBorder(BorderFactory.createEmptyBorder());
            jList.setCellRenderer(new DisplayableListCellRenderer());
            jList.setBackground(UIManager.getColor("Panel.background"));
            jList.setForeground(UIManager.getColor("List.foreground"));
            jList.setSelectionBackground(UIManager.getColor("ScrollPane.background"));
            jList.setSelectionForeground(jList.getForeground());
            JScrollPane jScrollPane = new JScrollPane(jList);
            jScrollPane.setBorder(new EmptyBorder(5, 0, 0, 0));
            jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            return jScrollPane;
        }

        private ListModel buildSelectedNodesListModel() {
            return new ListModelAdapter(this.buildStateChangeAdapter());
        }

        private ListValueModel buildStateChangeAdapter() {
            return new ItemStateListValueModelAdapter(MultiSelectionPseudoNode.this.getSelectedNodesHolder());
        }
    }
}

