/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesView;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;

final class PreferencesDialog
extends AbstractDialog {
    private PreferencesView view;
    private Action importAction;
    private Action exportAction;

    PreferencesDialog(WorkbenchContext workbenchContext, PreferencesView preferencesView) {
        super(workbenchContext, workbenchContext.getApplicationContext().getResourceRepository().getString("PREFERENCES.DIALOG.TITLE"));
        this.view = preferencesView;
    }

    protected void initializeActions() {
        super.initializeActions();
        this.importAction = this.buildImportAction();
        this.exportAction = this.buildExportAction();
    }

    protected Component buildMainPanel() {
        return this.view.getComponent();
    }

    protected Iterator buildCustomActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(this.importAction);
        arrayList.add(this.exportAction);
        return arrayList.iterator();
    }

    protected String helpTopicId() {
        return "preferences";
    }

    protected void prepareToShow() {
        this.setSize(600, 400);
        this.setLocationRelativeTo(this.getParent());
        this.helpManager().removeTopicID(this.view.getView().getTree());
    }

    protected Component initialFocusComponent() {
        return this.view.initialFocusComponent();
    }

    protected void okConfirmed() {
        this.view.triggerAccept();
        super.okConfirmed();
    }

    protected void cancelPressed() {
        this.view.triggerReset();
        super.cancelPressed();
    }

    protected Action buildImportAction() {
        return new AbstractAction(this.buildImportText()){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.importPressed();
            }
        };
    }

    protected String buildImportText() {
        return this.resourceRepository().getString("PREFERENCES.DIALOG.IMPORT");
    }

    protected void importPressed() {
        JFileChooser jFileChooser = new JFileChooser(){

            public void approveSelection() {
                File file = this.getSelectedFile();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, PreferencesDialog.this.resourceRepository().getString("PREFERENCES.DIALOG.IMPORT.INVALID_IMPORT_FILE", file.getPath()), PreferencesDialog.this.getApplicationContext().getApplication().getShortProductName(), 0);
                } else {
                    super.approveSelection();
                }
            }
        };
        int n = jFileChooser.showOpenDialog(this.currentWindow());
        if (n != 0) {
            return;
        }
        this.view.importPreferences(jFileChooser.getSelectedFile());
        this.view.triggerReset();
        JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("PREFERENCES.DIALOG.IMPORT.SUCCESS.DIALOG"), this.getApplicationContext().getApplication().getShortProductName(), 1);
    }

    protected Action buildExportAction() {
        return new AbstractAction(this.buildExportText()){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.exportPressed();
            }
        };
    }

    protected String buildExportText() {
        return this.resourceRepository().getString("PREFERENCES.DIALOG.EXPORT");
    }

    protected void exportPressed() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this.currentWindow());
        if (n != 0) {
            return;
        }
        this.view.exportPreferences(jFileChooser.getSelectedFile());
        JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("PREFERENCES.DIALOG.EXPORT.SUCCESS.DIALOG"), this.getApplicationContext().getApplication().getShortProductName(), 1);
    }
}

