/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class PreferencesNavigatorView {
    private JTree tree;
    private AbstractPreferencesNode rootNode;
    private JPanel panel;

    public PreferencesNavigatorView(AbstractPreferencesNode abstractPreferencesNode) {
        this.initialize(abstractPreferencesNode);
    }

    private void initialize(AbstractPreferencesNode abstractPreferencesNode) {
        this.rootNode = abstractPreferencesNode;
        this.tree = this.buildTree(abstractPreferencesNode);
        this.panel = this.buildPanel();
        this.expandAll(this.rootNode);
    }

    private void expandAll(TreeNode treeNode) {
        this.tree.expandPath(this.buildPath(treeNode));
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (treeNode2.isLeaf()) continue;
            this.expandAll(treeNode2);
        }
    }

    private TreePath buildPath(TreeNode treeNode) {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        do {
            vector.add(0, treeNode);
        } while ((treeNode = treeNode.getParent()) != null);
        return new TreePath(vector.toArray());
    }

    private JTree buildTree(PreferencesNode preferencesNode) {
        JTree jTree = new JTree(preferencesNode);
        jTree.setShowsRootHandles(true);
        jTree.setRootVisible(false);
        jTree.setCellRenderer(new PreferencesTreeCellRenderer());
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addKeyListener(this.buildF1KeyListener());
        jTree.addMouseListener(this.buildMouseListener());
        return jTree;
    }

    private MouseListener buildMouseListener() {
        return new LocalMouseListener(this.getRootNode().resourceRepository().getString("HELP_POPUP"));
    }

    private KeyListener buildF1KeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AbstractPreferencesNode abstractPreferencesNode;
                if (keyEvent.getKeyCode() == 112 && (abstractPreferencesNode = (AbstractPreferencesNode)PreferencesNavigatorView.this.getTree().getLastSelectedPathComponent()) != null) {
                    abstractPreferencesNode.showHelp();
                }
            }
        };
    }

    private JPanel buildPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setMinimumSize(new Dimension(0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.setBorder(null);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    synchronized void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    synchronized void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    Component getComponent() {
        return this.panel;
    }

    Component initialFocusComponent() {
        return this.tree;
    }

    JTree getTree() {
        return this.tree;
    }

    AbstractPreferencesNode getRootNode() {
        return this.rootNode;
    }

    void selectFirstChild() {
        this.tree.setSelectionPath(this.buildPath(this.rootNode.getChildAt(0)));
    }

    private class LocalMouseListener
    extends MouseAdapter {
        PopupMenu popupMenu;
        int x;
        int y;

        LocalMouseListener(String string) {
            this.initialize(string);
        }

        private void initialize(String string) {
            MenuItem menuItem = new MenuItem(string);
            menuItem.addActionListener(this.buildMenuItemListener());
            this.popupMenu = new PopupMenu();
            this.popupMenu.add(menuItem);
        }

        private ActionListener buildMenuItemListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LocalMouseListener.this.showHelp();
                    LocalMouseListener.this.popupMenu.getParent().remove(LocalMouseListener.this.popupMenu);
                }
            };
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent);
        }

        private void handleMouseEvent(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            PreferencesNavigatorView.this.getTree().add(this.popupMenu);
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.popupMenu.show(PreferencesNavigatorView.this.getTree(), mouseEvent.getX(), mouseEvent.getY());
        }

        void showHelp() {
            int n = PreferencesNavigatorView.this.getTree().getRowForLocation(this.x, this.y);
            if (n != -1) {
                AbstractPreferencesNode abstractPreferencesNode;
                TreePath treePath = PreferencesNavigatorView.this.tree.getPathForRow(n);
                Object[] objectArray = PreferencesNavigatorView.this.tree.getSelectionPaths();
                if (objectArray == null || !CollectionTools.contains((Object[])objectArray, (Object)treePath)) {
                    PreferencesNavigatorView.this.tree.setSelectionPath(treePath);
                }
                if ((abstractPreferencesNode = (AbstractPreferencesNode)PreferencesNavigatorView.this.getTree().getLastSelectedPathComponent()) != null) {
                    abstractPreferencesNode.showHelp();
                }
            }
        }
    }

    private static class NodeRenderer
    extends SimpleTreeCellRenderer {
        private static final Border BORDER = BorderFactory.createEmptyBorder(0, 2, 0, 0);

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setBorder(BORDER);
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        protected Icon buildIcon(Object object) {
            return null;
        }

        protected String buildText(Object object) {
            return ((PreferencesNode)object).displayString();
        }
    }

    private static class PreferencesTreeCellRenderer
    implements TreeCellRenderer {
        private PreferencesTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            NodeRenderer nodeRenderer = new NodeRenderer();
            return nodeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }
}

