/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblem;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblemContainer;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.internal.ProblemReportAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ProblemsViewHelpAction;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTableCellRenderer;

final class ProblemsView {
    private ListValueModel applicationProblemsAdapter;
    private ListValueModel branchApplicationProblemsAdapter;
    private TableModelAdapter tableModel;
    private ListSelectionModel tableSelectionModel;
    private NavigatorSelectionModel navigatorSelectionModel;
    private Action problemReportAction;
    JPopupMenu popupMenu;
    private MouseListener popupMenuMouseListener;
    private KeyListener keyListener;
    private JPanel component;

    ProblemsView(ValueModel valueModel, NavigatorSelectionModel navigatorSelectionModel, WorkbenchContext workbenchContext) {
        this.navigatorSelectionModel = navigatorSelectionModel;
        this.initialize(valueModel, workbenchContext);
    }

    private void initialize(ValueModel valueModel, WorkbenchContext workbenchContext) {
        if (valueModel == null) {
            throw new NullPointerException();
        }
        this.applicationProblemsAdapter = this.buildApplicationProblemsAdapter(valueModel);
        this.branchApplicationProblemsAdapter = this.buildBranchApplicationProblemsAdapter(valueModel);
        ResourceRepository resourceRepository = workbenchContext.getApplicationContext().getResourceRepository();
        this.tableModel = new TableModelAdapter(this.branchApplicationProblemsAdapter, this.buildColumnAdapter(resourceRepository));
        this.tableSelectionModel = new DefaultListSelectionModel();
        this.tableSelectionModel.setSelectionMode(0);
        this.problemReportAction = new ProblemReportAction(valueModel, workbenchContext);
        this.popupMenu = this.buildPopupMenu(workbenchContext);
        this.popupMenuMouseListener = this.buildPopupMenuMouseListener();
        this.keyListener = this.buildKeyListener(workbenchContext.getApplicationContext().getHelpManager());
        this.component = this.buildComponent(resourceRepository);
    }

    private ListValueModel buildApplicationProblemsAdapter(ValueModel valueModel) {
        return new ListAspectAdapter(valueModel, "applicationProblems"){

            protected ListIterator getValueFromSubject() {
                return ((ApplicationProblemContainer)this.subject).applicationProblems();
            }

            protected int sizeFromSubject() {
                return ((ApplicationProblemContainer)this.subject).applicationProblemsSize();
            }
        };
    }

    private ListValueModel buildBranchApplicationProblemsAdapter(ValueModel valueModel) {
        return new ListAspectAdapter(valueModel, "branchApplicationProblems"){

            protected ListIterator getValueFromSubject() {
                return ((ApplicationProblemContainer)this.subject).branchApplicationProblems();
            }

            protected int sizeFromSubject() {
                return ((ApplicationProblemContainer)this.subject).branchApplicationProblemsSize();
            }
        };
    }

    private ColumnAdapter buildColumnAdapter(ResourceRepository resourceRepository) {
        return new ProblemColumnAdapter(resourceRepository);
    }

    private JPopupMenu buildPopupMenu(WorkbenchContext workbenchContext) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.problemReportAction);
        jPopupMenu.add(new ProblemsViewHelpAction(workbenchContext));
        return jPopupMenu;
    }

    private KeyListener buildKeyListener(final HelpManager helpManager) {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 112) {
                    helpManager.showTopic("problemsPane");
                    keyEvent.consume();
                }
            }
        };
    }

    private JPanel buildComponent(ResourceRepository resourceRepository) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setMinimumSize(new Dimension(0, 0));
        JLabel jLabel = new JLabel(resourceRepository.getString("PROBLEMS_LABEL"));
        jLabel.setDisplayedMnemonic(resourceRepository.getMnemonic("PROBLEMS_LABEL"));
        jLabel.setIcon(resourceRepository.getIcon("problems"));
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jPanel.getBackground().brighter()), BorderFactory.createMatteBorder(0, 0, 1, 0, jPanel.getBackground().darker())), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jLabel.setLabelFor(jPanel);
        jPanel.add((Component)jLabel, "First");
        JTable jTable = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        jScrollPane.setBorder(null);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.addMouseListener(this.popupMenuMouseListener);
        jPanel.addKeyListener(this.keyListener);
        return jPanel;
    }

    private JTable buildTable() {
        JTable jTable = new JTable(this.tableModel, null, this.tableSelectionModel);
        jTable.setDoubleBuffered(true);
        jTable.setRowHeight(20);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new DisplayableTableCellRenderer());
        tableColumn.setPreferredWidth(100);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(20);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(500);
        jTable.addMouseListener(this.buildTableMouseListener());
        jTable.addMouseListener(this.popupMenuMouseListener);
        jTable.addKeyListener(this.keyListener);
        return jTable;
    }

    private MouseListener buildTableMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ProblemsView.this.tableDoubleClicked();
                }
            }
        };
    }

    private MouseListener buildPopupMenuMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            private void handleMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ProblemsView.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
    }

    Component getComponent() {
        return this.component;
    }

    Action getProblemReportAction() {
        return this.problemReportAction;
    }

    void toggle() {
        if (this.tableModel.getModel() == this.applicationProblemsAdapter) {
            this.tableModel.setModel(this.branchApplicationProblemsAdapter);
        } else {
            this.tableModel.setModel(this.applicationProblemsAdapter);
        }
    }

    void tableDoubleClicked() {
        int n = this.tableSelectionModel.getMinSelectionIndex();
        ApplicationProblem applicationProblem = (ApplicationProblem)this.tableModel.getModel().getItem(n);
        this.navigatorSelectionModel.setSelectedNode(applicationProblem.getSource());
    }

    void close() {
    }

    private static class ProblemColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        static final int COLUMN_COUNT = 3;
        static final int NODE_COLUMN = 0;
        static final int CODE_COLUMN = 1;
        static final int MESSAGE_COLUMN = 2;
        private static final String[] COLUMN_NAMES = new String[]{"PROBLEM_NODE", "PROBLEM_CODE", "PROBLEM_MESSAGE"};

        ProblemColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAMES[n]);
        }

        public Class getColumnClass(int n) {
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            ApplicationProblem applicationProblem = (ApplicationProblem)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{new ReadOnlyPropertyValueModel(applicationProblem.getSource()), new ReadOnlyPropertyValueModel(applicationProblem.getMessageCode()), new ReadOnlyPropertyValueModel(applicationProblem.getMessage())};
            return propertyValueModelArray;
        }
    }
}

