/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkExceptionDialog;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;

final class RunnableProjectLoader
implements Runnable {
    private volatile FrameworkNodeManager nodeManager;
    private File projectFile;
    private WorkbenchContext context;
    Dialog waitDialog;

    RunnableProjectLoader(FrameworkNodeManager frameworkNodeManager, File file, WorkbenchContext workbenchContext) {
        this.nodeManager = frameworkNodeManager;
        this.projectFile = file;
        this.context = workbenchContext;
        this.waitDialog = this.buildWaitDialog();
    }

    private Dialog buildWaitDialog() {
        Window window = this.context.getCurrentWindow();
        ResourceRepository resourceRepository = this.context.getApplicationContext().getResourceRepository();
        Icon icon = resourceRepository.getIcon("file.mwp.large");
        String string = resourceRepository.getString("PROJECT_LOADER_DIALOG.TITLE");
        String string2 = resourceRepository.getString("OPENING_PROJECT_MESSAGE", this.projectFile.getName());
        return window instanceof Frame ? new WaitDialog((Frame)window, icon, string, string2) : new WaitDialog((Dialog)window, icon, string, string2);
    }

    public void run() {
        try {
            this.run2();
        }
        catch (Throwable throwable) {
            this.waitDialog.dispose();
            EventQueue.invokeLater(this.buildDialogLauncher(this.buildExceptionDialog("OPEN_EXCEPTION", new Object[]{this.projectFile.getName()}, throwable)));
        }
    }

    private void run2() throws InterruptedException, InvocationTargetException {
        EventQueue.invokeLater(this.buildDialogLauncher(this.waitDialog));
        ApplicationNode applicationNode = null;
        try {
            applicationNode = this.nodeManager.openCallback(this.projectFile, this.context);
        }
        catch (OpenException openException) {
            this.waitDialog.dispose();
            EventQueue.invokeLater(this.buildDialogLauncher(this.buildExceptionDialog("OPEN_EXCEPTION", new Object[]{this.projectFile.getName()}, openException)));
            return;
        }
        catch (UnsupportedFileException unsupportedFileException) {
            this.waitDialog.dispose();
            EventQueue.invokeLater(this.buildDialogLauncher(this.buildExceptionDialog("UNSUPPORTED_FILE_TYPE", new Object[]{this.projectFile.getName()}, unsupportedFileException)));
            return;
        }
        catch (CancelException cancelException) {
            this.waitDialog.dispose();
            return;
        }
        EventQueue.invokeAndWait(new NodeInstaller(this.nodeManager, applicationNode, this.projectFile, this.context));
        this.waitDialog.dispose();
    }

    private Runnable buildDialogLauncher(final Dialog dialog) {
        return new Runnable(){

            public void run() {
                dialog.show();
            }
        };
    }

    Dialog buildExceptionDialog(String string, Object[] objectArray, Throwable throwable) {
        Window window = this.context.getCurrentWindow();
        String string2 = this.context.getApplicationContext().getResourceRepository().getString(string, objectArray);
        return window instanceof Frame ? new FrameworkExceptionDialog(string2, throwable, this.context) : new FrameworkExceptionDialog(string2, throwable, this.context, (Dialog)window);
    }

    private static class NodeInstaller
    implements Runnable {
        private FrameworkNodeManager nodeManager;
        private ApplicationNode projectNode;
        private File projectFile;
        private WorkbenchContext context;

        NodeInstaller(FrameworkNodeManager frameworkNodeManager, ApplicationNode applicationNode, File file, WorkbenchContext workbenchContext) {
            this.nodeManager = frameworkNodeManager;
            this.projectNode = applicationNode;
            this.projectFile = applicationNode.saveFile() != null ? applicationNode.saveFile() : file;
            this.context = workbenchContext;
        }

        public void run() {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("this method must be executed in the AWT event dispatcher thread");
            }
            this.nodeManager.addProjectNodeCallback(this.projectNode, this.projectFile, this.context);
        }
    }
}

