/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class SaveModifiedProjectsDialog
extends AbstractDialog {
    private Collection dirtyNodes;
    private ObjectListSelectionModel selectionModel;
    private CheckList checkList;
    private Action selectAllAction;
    private Action unselectAllAction;

    SaveModifiedProjectsDialog(WorkbenchContext workbenchContext, Collection collection) {
        this(workbenchContext, collection, new ArrayList(collection));
    }

    SaveModifiedProjectsDialog(WorkbenchContext workbenchContext, Collection collection, Collection collection2) {
        super(workbenchContext);
        this.initialize(collection, collection2);
    }

    protected void initialize() {
        super.initialize();
        this.setName("File.SaveAll");
        this.setTitle(this.resourceRepository().getString("saveModifiedDocuments.title"));
    }

    private void initialize(Collection collection, Collection collection2) {
        this.dirtyNodes = collection;
        ReadOnlyCollectionValueModel readOnlyCollectionValueModel = new ReadOnlyCollectionValueModel(collection);
        this.selectionModel = new ObjectListSelectionModel(new ListModelAdapter(readOnlyCollectionValueModel));
        this.checkList = new CheckList(readOnlyCollectionValueModel, (ListSelectionModel)this.selectionModel, this.buildCellRendererAdapter());
        this.selectionModel.setSelectedValues(collection);
    }

    private CellRendererAdapter buildCellRendererAdapter() {
        return new AbstractCellRendererAdapter(){

            public String buildAccessibleName(Object object) {
                ApplicationNode applicationNode = (ApplicationNode)object;
                String string = applicationNode.accessibleName();
                File file = applicationNode.saveFile();
                if (string != null && file != null && !file.toString().equals(applicationNode.displayString())) {
                    string = string + " [" + file + "]";
                }
                return string;
            }

            public Icon buildIcon(Object object) {
                return ((Displayable)object).icon();
            }

            public String buildText(Object object) {
                ApplicationNode applicationNode = (ApplicationNode)object;
                String string = applicationNode.displayString();
                File file = applicationNode.saveFile();
                if (file != null && !file.toString().equals(string)) {
                    string = string + " [" + file + "]";
                }
                return string;
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(405, 250));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.resourceRepository().getString("saveModifiedDocuments.message"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("saveModifiedDocuments.message"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("saveModifiedDocuments.message"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setLabelFor(this.checkList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.checkList, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.selectAllAction = this.buildSelectAllAction();
        JButton jButton = new JButton(this.selectAllAction);
        jButton.setText(this.resourceRepository().getString("selectAll"));
        jButton.setMnemonic(this.resourceRepository().getMnemonic("selectAll"));
        jButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("selectAll"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.unselectAllAction = this.buildUnselectAllAction();
        JButton jButton2 = new JButton(this.unselectAllAction);
        jButton2.setText(this.resourceRepository().getString("deselectAll"));
        jButton2.setMnemonic(this.resourceRepository().getMnemonic("deselectAll"));
        jButton2.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("deselectAll"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel2.add((Component)jButton2, gridBagConstraints);
        return jPanel;
    }

    protected String helpTopicId() {
        return "dialog.file.saveAll";
    }

    protected Component initialFocusComponent() {
        return this.checkList;
    }

    private Action buildSelectAllAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveModifiedProjectsDialog.this.selectAllPressed();
            }
        };
    }

    private void selectAllPressed() {
        this.selectionModel.setSelectionInterval(0, this.dirtyNodes.size() - 1);
    }

    private Action buildUnselectAllAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveModifiedProjectsDialog.this.unselectAllPressed();
            }
        };
    }

    private void unselectAllPressed() {
        this.selectionModel.clearSelection();
    }

    Collection selectedNodes() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        return Arrays.asList(this.selectionModel.getSelectedValues());
    }
}

