/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;

final class WorkbenchSaveAction
extends AbstractFrameworkAction {
    private TreeSelectionListener treeSelectionListener;
    private FrameworkNodeManager nodeManager;
    private ApplicationNode[] selectedProjectNodes;
    private PropertyChangeListener dirtyListener;
    private WindowListener windowListener;

    WorkbenchSaveAction(WorkbenchContext workbenchContext, FrameworkNodeManager frameworkNodeManager) {
        super(workbenchContext);
        this.nodeManager = frameworkNodeManager;
    }

    protected void initialize() {
        super.initialize();
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.initializeTextAndMnemonic("file.save");
        this.initializeIcon("file.save");
        this.initializeToolTipText("file.save.toolTipText");
        this.initializeAccelerator("file.save.ACCELERATOR");
        this.selectedProjectNodes = new ApplicationNode[0];
        this.dirtyListener = this.buildDirtyListener();
        this.windowListener = this.buildWorkbenchWindowListener();
        this.currentWindow().addWindowListener(this.windowListener);
        this.navigatorSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        this.updateEnabledState();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                WorkbenchSaveAction workbenchSaveAction = WorkbenchSaveAction.this;
                synchronized (workbenchSaveAction) {
                    WorkbenchSaveAction.this.update();
                }
            }
        };
    }

    private PropertyChangeListener buildDirtyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkbenchSaveAction.this.updateEnabledState();
            }
        };
    }

    private WindowListener buildWorkbenchWindowListener() {
        return new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                WorkbenchSaveAction.this.workbenchWindowClosed();
            }
        };
    }

    void update() {
        this.disengageSelectedProjectNodes();
        this.selectedProjectNodes = this.selectedProjectNodes();
        this.engageSelectedProjectNodes();
        this.updateEnabledState();
    }

    void updateEnabledState() {
        if (this.selectedNodes().length == 0) {
            this.setEnabled(false);
            return;
        }
        ApplicationNode[] applicationNodeArray = this.selectedProjectNodes();
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            if (applicationNodeArray[n].isDirty()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private void engageSelectedProjectNodes() {
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            this.selectedProjectNodes[n].addPropertyChangeListener("dirty", this.dirtyListener);
        }
    }

    private void disengageSelectedProjectNodes() {
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            this.selectedProjectNodes[n].removePropertyChangeListener("dirty", this.dirtyListener);
        }
        this.selectedProjectNodes = null;
    }

    protected void execute() {
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            this.nodeManager.save(this.selectedProjectNodes[n], this.getWorkbenchContext());
        }
    }

    void workbenchWindowClosed() {
        this.navigatorSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        this.disengageSelectedProjectNodes();
        this.currentWindow().removeWindowListener(this.windowListener);
    }
}

