/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ActionRepository;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpFacade;
import org.eclipse.persistence.tools.workbench.framework.internal.AboutAction;
import org.eclipse.persistence.tools.workbench.framework.internal.DevelopmentConsoleAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ExamplesAction;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkActionRepository;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.framework.internal.GoToAction;
import org.eclipse.persistence.tools.workbench.framework.internal.HelpAction;
import org.eclipse.persistence.tools.workbench.framework.internal.HomeAction;
import org.eclipse.persistence.tools.workbench.framework.internal.JavaDocAction;
import org.eclipse.persistence.tools.workbench.framework.internal.JavaHeapInformationAction;
import org.eclipse.persistence.tools.workbench.framework.internal.NewWindowAction;
import org.eclipse.persistence.tools.workbench.framework.internal.OpenRecentFileAction;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ShowProblemsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.SynchronousProblemsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ThreadBrowserAction;
import org.eclipse.persistence.tools.workbench.framework.internal.UsersGuideAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchCloseAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchSaveAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchSaveAsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkspaceView;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.DropDownButton;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;

final class WorkbenchWindow
extends JFrame {
    private FrameworkApplication application;
    private WorkbenchContext context;
    private WorkspaceView workspace;
    private JMenu fileMenu;
    private int recentFilesSize;
    private StateChangeListener recentFilesListener;
    private FrameworkActionRepository actionRepository;
    private ButtonModel showProblemsButtonModel;
    private ButtonModel synchronousProblemsButtonModel;
    private PropertyValueModel selectionMenuDescriptionHolder;
    private TreeSelectionListener treeSelectionListener;
    private JMenu workbenchMenu;
    private JMenu selectionMenu;
    private Map pluginToolBarActions;
    private JToolBar selectionToolBar;
    private Set selectionActions;
    private Set workbenchActions;
    private WindowListener windowListener;
    private static final Icon EMPTY_ICON = new EmptyIcon(16);

    WorkbenchWindow(FrameworkApplication frameworkApplication) {
        this.application = frameworkApplication;
        this.initialize();
    }

    WorkbenchWindow(FrameworkApplication frameworkApplication, WorkbenchWindow workbenchWindow) {
        this(frameworkApplication);
        this.copySettingsFrom(workbenchWindow);
    }

    private void initialize() {
        this.recentFilesSize = 0;
        this.recentFilesListener = this.buildRecentFilesListener();
        this.application.recentFilesManager().addStateChangeListener(this.recentFilesListener);
        this.context = new LocalWorkbenchContext();
        this.selectionMenuDescriptionHolder = new SimplePropertyValueModel();
        this.workspace = new WorkspaceView(this.context, this.selectionMenuDescriptionHolder);
        this.actionRepository = new FrameworkActionRepository(this);
        this.selectionActions = new HashSet();
        this.workbenchActions = new HashSet();
        this.setBounds(50, 50, 800, 725);
        this.setDefaultCloseOperation(0);
        this.initializeTitleBar();
        this.windowListener = new LocalWindowListener();
        this.addWindowListener(this.windowListener);
        this.getRootPane().setJMenuBar(this.buildMenuBar());
        this.getContentPane().add((Component)this.buildToolBarPanel(), "North");
        this.getContentPane().add(this.workspace.getComponent(), "Center");
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.getWorkspace().addNavigatorTreeSelectionListener(this.treeSelectionListener);
    }

    private void initializeTitleBar() {
        this.setTitle(this.application.getFullProductName());
        Icon icon = this.resourceRepository().getIcon("oracle.logo.large");
        if (icon instanceof ImageIcon) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
    }

    private void copySettingsFrom(WorkbenchWindow workbenchWindow) {
        this.setSize(workbenchWindow.getWidth(), workbenchWindow.getHeight());
        this.setExtendedState(workbenchWindow.getExtendedState());
        int n = workbenchWindow.getLocationOnScreen().y - workbenchWindow.getRootPane().getLocationOnScreen().y;
        int n2 = workbenchWindow.getLocationOnScreen().x - n;
        int n3 = workbenchWindow.getLocationOnScreen().y - n;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (n2 + dimension2.width > dimension.width || n3 + dimension2.height > dimension.height) {
            this.setLocation(0, 0);
        } else {
            this.setLocation(n2, n3);
        }
        this.workspace.copySettingsFrom(workbenchWindow.getWorkspace());
    }

    private JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = this.buildFileMenu();
        this.rebuildRecentFilesMenuItems();
        jMenuBar.add(this.fileMenu);
        this.workbenchMenu = this.buildWorkbenchMenu();
        jMenuBar.add(this.workbenchMenu);
        this.selectionMenu = this.buildSelectionMenu();
        jMenuBar.add(this.selectionMenu);
        jMenuBar.add(this.buildToolsMenu());
        jMenuBar.add(this.buildWindowMenu());
        jMenuBar.add(this.buildHelpMenu());
        return jMenuBar;
    }

    private JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.resourceRepository().getString("FILE_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("FILE_MENU"));
        jMenu.add(this.buildNewMenu());
        jMenu.add(new JMenuItem(this.actionRepository.getOpenAction()));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new WorkbenchSaveAction(this.getContext(), this.nodeManager())));
        jMenu.add(new JMenuItem(new WorkbenchSaveAsAction(this.getContext(), this.nodeManager())));
        jMenu.add(new JMenuItem(this.actionRepository.getSaveAllAction()));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new WorkbenchCloseAction(this.getContext(), this.nodeManager())));
        jMenu.add(new JMenuItem(this.actionRepository.getCloseAllAction()));
        jMenu.addSeparator();
        jMenu.addSeparator();
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.actionRepository.getExitAction()));
        return jMenu;
    }

    private JMenu buildNewMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setIcon(this.resourceRepository().getIcon("file"));
        jMenu.setText(this.resourceRepository().getString("file.new"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("file.new"));
        jMenu.setToolTipText(this.resourceRepository().getString("file.new.toolTipText"));
        Plugin[] pluginArray = this.plugins();
        for (int i = 0; i < pluginArray.length; ++i) {
            JMenuItem[] jMenuItemArray = pluginArray[i].buildNewMenuItems(this.context);
            for (int j = 0; j < jMenuItemArray.length; ++j) {
                jMenu.add(jMenuItemArray[j]);
            }
        }
        return jMenu;
    }

    private JMenu buildMigrateMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setIcon(EMPTY_ICON);
        jMenu.setText(this.resourceRepository().getString("file.migrate"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("file.migrate"));
        jMenu.setToolTipText(this.resourceRepository().getString("file.migrate.toolTipText"));
        Plugin[] pluginArray = this.plugins();
        return jMenu;
    }

    private JMenu buildWorkbenchMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.resourceRepository().getString("WORKBENCH_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("WORKBENCH_MENU"));
        jMenu.setEnabled(false);
        return jMenu;
    }

    private JMenu buildSelectionMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.resourceRepository().getString("SELECTED_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("SELECTED_MENU"));
        jMenu.setEnabled(false);
        return jMenu;
    }

    private JMenu buildToolsMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.resourceRepository().getString("TOOLS_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("TOOLS_MENU"));
        jMenu.add(new GoToAction(this.getContext()));
        jMenu.add(this.workspace.problemReportAction());
        jMenu.add(new PreferencesAction(this.getContext(), this.application));
        if (this.application.isDevelopmentMode()) {
            jMenu.add(this.buildDevelopmentMenu());
        }
        return jMenu;
    }

    private JMenu buildDevelopmentMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setIcon(EMPTY_ICON);
        jMenu.setText(this.resourceRepository().getString("DEV_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("DEV_MENU"));
        jMenu.add(new DevelopmentConsoleAction(this.getContext(), this.application));
        jMenu.add(HelpFacade.buildHelpTopicIDWindowAction(this.getContext()));
        jMenu.add(new ThreadBrowserAction(this.getContext()));
        jMenu.add(new JavaHeapInformationAction(this.getContext()));
        jMenu.add(this.buildSynchronousProblemsMenuItem());
        return jMenu;
    }

    private JMenuItem buildSynchronousProblemsMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new SynchronousProblemsAction(this));
        this.synchronousProblemsButtonModel = jCheckBoxMenuItem.getModel();
        this.synchronousProblemsButtonModel.setSelected(this.application.getNodeManager().projectNodesAreAddedWithSynchronousValidators());
        return jCheckBoxMenuItem;
    }

    private JMenu buildWindowMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.resourceRepository().getString("WINDOW_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("WINDOW_MENU"));
        jMenu.add(new NewWindowAction(this.getContext(), this.application));
        jMenu.add(this.buildShowProblemsMenuItem());
        return jMenu;
    }

    private JMenuItem buildShowProblemsMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowProblemsAction(this));
        this.showProblemsButtonModel = jCheckBoxMenuItem.getModel();
        this.showProblemsButtonModel.setSelected(this.workspace.problemsAreVisible());
        return jCheckBoxMenuItem;
    }

    private JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.resourceRepository().getString("HELP_MENU"));
        jMenu.setMnemonic(this.resourceRepository().getMnemonic("HELP_MENU"));
        jMenu.add(new HomeAction(this.getContext()));
        jMenu.add(new UsersGuideAction(this.getContext()));
        jMenu.add(new ExamplesAction(this.getContext()));
        jMenu.add(new JavaDocAction(this.getContext()));
        jMenu.addSeparator();
        jMenu.add(new AboutAction(this.getContext()));
        return jMenu;
    }

    private JPanel buildToolBarPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.buildMainToolBar());
        this.selectionToolBar = this.buildToolBar("SELECTION_TOOL_BAR");
        jPanel.add(this.selectionToolBar);
        return jPanel;
    }

    private JToolBar buildMainToolBar() {
        JToolBar jToolBar = this.buildToolBar("MAIN_TOOL_BAR");
        jToolBar.add(this.buildNewToolBarButton());
        JButton jButton = jToolBar.add(this.actionRepository.getOpenAction());
        jButton.setMnemonic('\u0000');
        jButton = jToolBar.add(new WorkbenchSaveAction(this.getContext(), this.nodeManager()));
        jButton.setMnemonic('\u0000');
        jButton = jToolBar.add(new WorkbenchSaveAsAction(this.getContext(), this.nodeManager()));
        jButton.setMnemonic('\u0000');
        jButton = jToolBar.add(this.actionRepository.getSaveAllAction());
        jButton.setMnemonic('\u0000');
        jButton = jToolBar.add(new WorkbenchCloseAction(this.getContext(), this.nodeManager()));
        jButton.setMnemonic('\u0000');
        jButton = jToolBar.add(this.actionRepository.getCloseAllAction());
        jButton.setMnemonic('\u0000');
        this.pluginToolBarActions = new HashMap();
        Plugin[] pluginArray = this.plugins();
        for (int i = 0; i < pluginArray.length; ++i) {
            Plugin plugin = pluginArray[i];
            ComponentContainerDescription componentContainerDescription = plugin.buildToolBarDescription(this.getContext());
            if (componentContainerDescription.hasComponents()) {
                jToolBar.addSeparator();
            }
            Object object = componentContainerDescription.components();
            while (object.hasNext()) {
                jToolBar.add((Component)object.next());
            }
            object = new ArrayList();
            Iterator iterator = componentContainerDescription.actions();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                action.setEnabled(false);
                object.add(action);
            }
            this.pluginToolBarActions.put(plugin, object);
        }
        jToolBar.addSeparator();
        jButton = jToolBar.add(new HelpAction(this.getContext()));
        jButton.setMnemonic('\u0000');
        return jToolBar;
    }

    private DropDownButton buildNewToolBarButton() {
        DropDownButton dropDownButton = new DropDownButton();
        dropDownButton.putClientProperty("hideActionText", Boolean.TRUE);
        dropDownButton.setAction(this.buildNewToolBarAction());
        dropDownButton.setMenu(this.buildNewMenu().getPopupMenu());
        dropDownButton.setMnemonic('\u0000');
        return dropDownButton;
    }

    private FrameworkAction buildNewToolBarAction() {
        return new AbstractFrameworkAction(this.getContext()){

            protected void initialize() {
                this.initializeIcon("file");
                this.initializeText("file.new");
                this.initializeToolTipText("file.new.toolTipText");
            }

            protected void execute() {
            }
        };
    }

    private JToolBar buildToolBar(String string) {
        JToolBar jToolBar = new JToolBar(this.resourceRepository().getString(string));
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, jToolBar.getBackground().darker());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(0, 0, 1, 0, jToolBar.getBackground().brighter());
        jToolBar.setBorder(BorderFactory.createCompoundBorder(matteBorder2, matteBorder));
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                WorkbenchWindow.this.treeSelectionChanged();
            }
        };
    }

    void treeSelectionChanged() {
        ApplicationNode[] applicationNodeArray = this.navigatorSelectionModel().getSelectedNodes();
        Plugin plugin = this.selectedPlugin(applicationNodeArray);
        this.updateWorkbenchActions(plugin);
        this.enablePluginToolBarActions(plugin);
        this.updateSelectionActions(applicationNodeArray, plugin);
    }

    private Plugin selectedPlugin(ApplicationNode[] applicationNodeArray) {
        int n = applicationNodeArray.length;
        if (n == 0) {
            return null;
        }
        Plugin plugin = applicationNodeArray[0].getPlugin();
        for (int i = 1; i < n; ++i) {
            if (applicationNodeArray[i].getPlugin() == plugin) continue;
            return null;
        }
        return plugin;
    }

    private void enablePluginToolBarActions(Plugin plugin) {
        for (Map.Entry entry : this.pluginToolBarActions.entrySet()) {
            boolean bl = entry.getKey() == plugin;
            Iterator iterator = ((Collection)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                ((Action)iterator.next()).setEnabled(bl);
            }
        }
    }

    private void updateWorkbenchActions(Plugin plugin) {
        this.tearDownWorkbenchActions();
        this.workbenchActions.clear();
        this.workbenchMenu.removeAll();
        if (plugin != null) {
            ComponentContainerDescription componentContainerDescription = plugin.buildMenuDescription(this.getContext());
            ListIterator listIterator = componentContainerDescription.components();
            while (listIterator.hasNext()) {
                this.workbenchMenu.add((Component)listIterator.next());
            }
            CollectionTools.addAll((Collection)this.workbenchActions, (Iterator)componentContainerDescription.actions());
            this.setUpWorkbenchActions();
        }
        this.workbenchMenu.setEnabled(this.workbenchMenu.getMenuComponentCount() > 0);
    }

    private void setUpWorkbenchActions() {
        Iterator iterator = this.workbenchActions.iterator();
        while (iterator.hasNext()) {
            ((FrameworkAction)iterator.next()).setUp();
        }
    }

    private void tearDownWorkbenchActions() {
        Iterator iterator = this.workbenchActions.iterator();
        while (iterator.hasNext()) {
            ((FrameworkAction)iterator.next()).tearDown();
        }
    }

    private void updateSelectionActions(ApplicationNode[] applicationNodeArray, Plugin plugin) {
        this.tearDownSelectionActions();
        this.selectionActions.clear();
        this.updateSelectionMenu(applicationNodeArray, plugin);
        this.updateSelectionToolBar(applicationNodeArray, plugin);
        this.setUpSelectionActions();
    }

    private void setUpSelectionActions() {
        Iterator iterator = this.selectionActions.iterator();
        while (iterator.hasNext()) {
            ((FrameworkAction)iterator.next()).setUp();
        }
    }

    private void tearDownSelectionActions() {
        Iterator iterator = this.selectionActions.iterator();
        while (iterator.hasNext()) {
            ((FrameworkAction)iterator.next()).tearDown();
        }
    }

    private void updateSelectionMenu(ApplicationNode[] applicationNodeArray, Plugin plugin) {
        this.selectionMenu.removeAll();
        if (plugin == null) {
            this.selectionMenu.setEnabled(false);
            this.selectionMenuDescriptionHolder.setValue(new RootMenuDescription());
            return;
        }
        GroupContainerDescription groupContainerDescription = applicationNodeArray[0].buildMenuDescription(this.context);
        for (int i = 1; i < applicationNodeArray.length; ++i) {
            groupContainerDescription.mergeWith(applicationNodeArray[i].buildMenuDescription(this.context));
        }
        ListIterator listIterator = groupContainerDescription.components();
        while (listIterator.hasNext()) {
            this.selectionMenu.add((Component)listIterator.next());
        }
        this.selectionMenu.setEnabled(this.selectionMenu.getMenuComponentCount() > 0);
        CollectionTools.addAll((Collection)this.selectionActions, (Iterator)groupContainerDescription.actions());
        this.selectionMenuDescriptionHolder.setValue(groupContainerDescription);
    }

    private void updateSelectionToolBar(ApplicationNode[] applicationNodeArray, Plugin plugin) {
        this.selectionToolBar.removeAll();
        this.selectionToolBar.revalidate();
        this.selectionToolBar.repaint();
        if (plugin == null) {
            return;
        }
        GroupContainerDescription groupContainerDescription = applicationNodeArray[0].buildToolBarDescription(this.context);
        for (int i = 1; i < applicationNodeArray.length; ++i) {
            groupContainerDescription.mergeWith(applicationNodeArray[i].buildToolBarDescription(this.context));
        }
        ListIterator listIterator = groupContainerDescription.components();
        while (listIterator.hasNext()) {
            this.selectionToolBar.add((Component)listIterator.next());
        }
        CollectionTools.addAll((Collection)this.selectionActions, (Iterator)groupContainerDescription.actions());
    }

    private StateChangeListener buildRecentFilesListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent stateChangeEvent) {
                WorkbenchWindow.this.recentFilesChanged();
            }
        };
    }

    void recentFilesChanged() {
        this.rebuildRecentFilesMenuItems();
    }

    private void rebuildRecentFilesMenuItems() {
        int n = this.fileMenu.getMenuComponentCount();
        n -= 2;
        n -= this.recentFilesSize;
        for (int i = 0; i < this.recentFilesSize; ++i) {
            this.fileMenu.remove(n);
        }
        File[] fileArray = this.application.recentFilesManager().getRecentFiles();
        this.recentFilesSize = fileArray.length;
        for (int i = 0; i < this.recentFilesSize; ++i) {
            this.fileMenu.insert(this.buildRecentFileMenuItem(i + 1, fileArray[i]), n + i);
        }
        this.fileMenu.getMenuComponent(this.fileMenu.getMenuComponentCount() - 2).setVisible(fileArray.length > 0);
    }

    private JMenuItem buildRecentFileMenuItem(int n, File file) {
        return new JMenuItem(new OpenRecentFileAction(this, n, file));
    }

    void saveState(Preferences preferences) {
        preferences.putInt("x-location", this.getLocation().x);
        preferences.putInt("y-location", this.getLocation().y);
        preferences.putInt("height", this.getSize().height);
        preferences.putInt("width", this.getSize().width);
        preferences.putInt("extended state", this.getExtendedState());
        this.workspace.saveState(preferences);
        preferences.putBoolean("problems view visible", this.workspace.problemsAreVisible());
    }

    void restoreState(Preferences preferences) {
        int n = preferences.getInt("x-location", this.getLocation().x);
        int n2 = preferences.getInt("y-location", this.getLocation().y);
        this.setLocation(n, n2);
        int n3 = preferences.getInt("height", this.getSize().height);
        int n4 = preferences.getInt("width", this.getSize().width);
        this.setSize(n4, n3);
        this.setExtendedState(preferences.getInt("extended state", this.getExtendedState()));
        this.workspace.restoreState(preferences);
        if (!preferences.getBoolean("problems view visible", true)) {
            this.toggleShowProblems();
        }
    }

    void saveTreeExpansionState(Preferences preferences) {
        this.workspace.saveTreeExpansionState(preferences);
    }

    void restoreTreeExpansionState(Preferences preferences) {
        this.workspace.restoreTreeExpansionState(preferences);
    }

    void toggleShowProblems() {
        this.showProblemsButtonModel.setSelected(this.workspace.toggleShowProblems());
    }

    void toggleSynchronousProblems() {
        this.synchronousProblemsButtonModel.setSelected(this.application.getNodeManager().toggleAddProjectNodesWithSynchronousValidators());
    }

    void closing() {
        this.application.close(this);
    }

    void closed() {
        this.application.recentFilesManager().removeStateChangeListener(this.recentFilesListener);
        this.getWorkspace().removeNavigatorTreeSelectionListener(this.treeSelectionListener);
        this.tearDownSelectionActions();
        this.workspace.close();
        this.removeWindowListener(this.windowListener);
    }

    FrameworkApplication getApplication() {
        return this.application;
    }

    WorkbenchContext getContext() {
        return this.context;
    }

    WorkspaceView getWorkspace() {
        return this.workspace;
    }

    ActionRepository getActionRepository() {
        return this.actionRepository;
    }

    Plugin[] plugins() {
        return this.application.getPlugins();
    }

    ResourceRepository resourceRepository() {
        return this.application.getResourceRepository();
    }

    ApplicationContext applicationContext() {
        return this.application.getRootApplicationContext();
    }

    FrameworkNodeManager nodeManager() {
        return this.application.getNodeManager();
    }

    TreeNodeValueModel rootNode() {
        return this.nodeManager().getRootNode();
    }

    NavigatorSelectionModel navigatorSelectionModel() {
        return this.workspace.navigatorSelectionModel();
    }

    Component getPropertiesPage() {
        return this.workspace.getPropertiesPage();
    }

    private class LocalWindowListener
    extends WindowAdapter {
        private LocalWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            WorkbenchWindow.this.closing();
        }

        public void windowClosed(WindowEvent windowEvent) {
            WorkbenchWindow.this.closed();
        }
    }

    private class LocalWorkbenchContext
    extends AbstractWorkbenchContext {
        private LocalWorkbenchContext() {
        }

        public ApplicationContext getApplicationContext() {
            return WorkbenchWindow.this.applicationContext();
        }

        public Window getCurrentWindow() {
            return WorkbenchWindow.this;
        }

        public NavigatorSelectionModel getNavigatorSelectionModel() {
            return WorkbenchWindow.this.navigatorSelectionModel();
        }

        public ActionRepository getActionRepository() {
            return WorkbenchWindow.this.getActionRepository();
        }

        public Component getPropertiesPage() {
            return WorkbenchWindow.this.getPropertiesPage();
        }
    }
}

